/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.smithwaterman;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.smithwaterman.SWPairwiseAlignment;

public class SWPairwiseAlignmentMain {
    public static void main(String[] argv) {
        String ref = null;
        String read = null;
        Map<String, List<String>> args = SWPairwiseAlignmentMain.processArgs(argv);
        List<String> l2 = args.get("SEQ");
        args.remove("SEQ");
        if (l2 == null) {
            System.err.println("SEQ argument is missing. Two input sequences must be provided");
            System.exit(1);
        }
        if (l2.size() != 2) {
            System.err.println("Two input sequences (SEQ arguments) must be provided. Found " + l2.size() + " instead");
            System.exit(1);
        }
        ref = l2.get(0);
        read = l2.get(1);
        Double m2 = SWPairwiseAlignmentMain.extractSingleDoubleArg("MATCH", args);
        Double mm = SWPairwiseAlignmentMain.extractSingleDoubleArg("MISMATCH", args);
        Double open = SWPairwiseAlignmentMain.extractSingleDoubleArg("OPEN", args);
        Double ext = SWPairwiseAlignmentMain.extractSingleDoubleArg("EXTEND", args);
        Boolean reverse = SWPairwiseAlignmentMain.extractSingleBooleanArg("REVERSE", args);
        if (reverse != null && reverse.booleanValue()) {
            ref = Utils.reverse(ref);
            read = Utils.reverse(read);
        }
        Boolean print_mat = SWPairwiseAlignmentMain.extractSingleBooleanArg("PRINT_MATRIX", args);
        Boolean cut = SWPairwiseAlignmentMain.extractSingleBooleanArg("CUTOFF", args);
        if (cut != null) {
            SWPairwiseAlignment.cutoff = cut;
        }
        if (args.size() != 0) {
            System.err.println("Unknown argument on the command line: " + args.keySet().iterator().next());
            System.exit(1);
        }
        double w_match = m2 == null ? 30.0 : m2;
        double w_mismatch = mm == null ? -10.0 : mm;
        double w_open = open == null ? -10.0 : open;
        double w_extend = ext == null ? -2.0 : ext;
        SWPairwiseAlignment.keepScoringMatrix = true;
        SWPairwiseAlignment a2 = new SWPairwiseAlignment(ref.getBytes(), read.getBytes(), w_match, w_mismatch, w_open, w_extend);
        System.out.println("start=" + a2.getAlignmentStart2wrt1() + ", cigar=" + a2.getCigar() + " length1=" + ref.length() + " length2=" + read.length());
        System.out.println();
        a2.printAlignment(ref.getBytes(), read.getBytes());
        System.out.println();
        if (print_mat != null && print_mat.booleanValue()) {
            SWPairwiseAlignmentMain.print(a2.SW, ref.getBytes(), read.getBytes());
        }
    }

    private static void print(double[] s2, byte[] a2, byte[] b2) {
        int n2 = a2.length + 1;
        int m2 = b2.length + 1;
        System.out.print("         ");
        for (int j2 = 1; j2 < m2; ++j2) {
            System.out.printf(" %5c", Character.valueOf((char)b2[j2 - 1]));
        }
        System.out.println();
        int i2 = 0;
        int row_offset = 0;
        while (i2 < n2) {
            if (i2 > 0) {
                System.out.print((char)a2[i2 - 1]);
            } else {
                System.out.print(' ');
            }
            System.out.print("  ");
            for (int j3 = 0; j3 < m2; ++j3) {
                System.out.printf(" %5.1f", s2[row_offset + j3]);
            }
            System.out.println();
            ++i2;
            row_offset += m2;
        }
    }

    static Pair<String, Integer> getArg(String prefix, String[] argv, int i2) {
        String arg = null;
        if (argv[i2].startsWith(prefix)) {
            arg = argv[i2].substring(prefix.length());
            if (arg.length() == 0) {
                if (++i2 < argv.length) {
                    arg = argv[i2];
                } else {
                    System.err.println("No value found after " + prefix + " argument tag");
                    System.exit(1);
                }
            }
            ++i2;
        }
        return new Pair<Object, Integer>(arg, i2);
    }

    static Map<String, List<String>> processArgs(String[] argv) {
        HashMap<String, List<String>> args = new HashMap<String, List<String>>();
        for (int i2 = 0; i2 < argv.length; ++i2) {
            ArrayList<String> l2;
            String val;
            String arg = argv[i2];
            int pos = arg.indexOf(61);
            if (pos < 0) {
                System.err.println("Argument " + arg + " is not of the form <ARG>=<VAL>");
                System.exit(1);
            }
            if ((val = arg.substring(pos + 1)).length() == 0) {
                if (++i2 < argv.length) {
                    val = argv[i2];
                } else {
                    System.err.println("No value found after " + arg + " argument tag");
                    System.exit(1);
                }
            }
            if ((l2 = (ArrayList<String>)args.get(arg = arg.substring(0, pos))) == null) {
                l2 = new ArrayList<String>();
                args.put(arg, l2);
            }
            l2.add(val);
        }
        return args;
    }

    static Double extractSingleDoubleArg(String argname, Map<String, List<String>> args) {
        List<String> l2 = args.get(argname);
        args.remove(argname);
        if (l2 == null) {
            return null;
        }
        if (l2.size() > 1) {
            System.err.println("Only one " + argname + " argument is allowed");
            System.exit(1);
        }
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(l2.get(0));
        }
        catch (NumberFormatException e2) {
            System.err.println("Can not parse value provided for " + argname + " argument (" + l2.get(0) + ")");
            System.exit(1);
        }
        System.out.println("Argument " + argname + " set to " + d2);
        return new Double(d2);
    }

    static Boolean extractSingleBooleanArg(String argname, Map<String, List<String>> args) {
        List<String> l2 = args.get(argname);
        args.remove(argname);
        if (l2 == null) {
            return null;
        }
        if (l2.size() > 1) {
            System.err.println("Only one " + argname + " argument is allowed");
            System.exit(1);
        }
        if (l2.get(0).equals("true")) {
            return true;
        }
        if (l2.get(0).equals("false")) {
            return false;
        }
        System.err.println("Can not parse value provided for " + argname + " argument (" + l2.get(0) + "); true/false are allowed");
        System.exit(1);
        return false;
    }
}

