/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class NWaySAMFileWriter
implements SAMFileWriter {
    private Map<SAMReaderID, SAMFileWriter> writerMap = null;
    private boolean presorted;
    GenomeAnalysisEngine toolkit;
    boolean KEEP_ALL_PG_RECORDS = false;

    public NWaySAMFileWriter(GenomeAnalysisEngine toolkit, Map<String, String> in2out, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5, SAMProgramRecord pRecord, boolean keep_records) {
        this.presorted = presorted;
        this.toolkit = toolkit;
        this.KEEP_ALL_PG_RECORDS = keep_records;
        this.writerMap = new HashMap<SAMReaderID, SAMFileWriter>();
        this.setupByReader(toolkit, in2out, order, presorted, indexOnTheFly, generateMD5, pRecord);
    }

    public NWaySAMFileWriter(GenomeAnalysisEngine toolkit, String ext, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5, SAMProgramRecord pRecord, boolean keep_records) {
        this.presorted = presorted;
        this.toolkit = toolkit;
        this.KEEP_ALL_PG_RECORDS = keep_records;
        this.writerMap = new HashMap<SAMReaderID, SAMFileWriter>();
        this.setupByReader(toolkit, ext, order, presorted, indexOnTheFly, generateMD5, pRecord);
    }

    public NWaySAMFileWriter(GenomeAnalysisEngine toolkit, Map<String, String> in2out, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5) {
        this(toolkit, in2out, order, presorted, indexOnTheFly, generateMD5, null, false);
    }

    public NWaySAMFileWriter(GenomeAnalysisEngine toolkit, String ext, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5) {
        this(toolkit, ext, order, presorted, indexOnTheFly, generateMD5, null, false);
    }

    public void setupByReader(GenomeAnalysisEngine toolkit, Map<String, String> in2out, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5, SAMProgramRecord pRecord) {
        if (in2out == null) {
            throw new StingException("input-output bam filename map for n-way-out writing is NULL");
        }
        for (SAMReaderID rid : toolkit.getReadsDataSource().getReaderIDs()) {
            String fName = toolkit.getReadsDataSource().getSAMFile(rid).getName();
            if (!in2out.containsKey(fName)) {
                throw new UserException.BadInput("Input-output bam filename map does not contain an entry for the input file " + fName);
            }
            String outName = in2out.get(fName);
            if (this.writerMap.containsKey(rid)) {
                throw new StingException("nWayOut mode: Reader id for input sam file " + fName + " is already registered; " + "map file likely contains multiple entries for this input file");
            }
            this.addWriter(rid, outName, order, presorted, indexOnTheFly, generateMD5, pRecord);
        }
    }

    public void setupByReader(GenomeAnalysisEngine toolkit, String ext, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5, SAMProgramRecord pRecord) {
        for (SAMReaderID rid : toolkit.getReadsDataSource().getReaderIDs()) {
            int pos;
            String fName = toolkit.getReadsDataSource().getSAMFile(rid).getName();
            if (fName.toUpperCase().endsWith(".BAM")) {
                pos = fName.toUpperCase().lastIndexOf(".BAM");
            } else if (fName.toUpperCase().endsWith(".SAM")) {
                pos = fName.toUpperCase().lastIndexOf(".SAM");
            } else {
                throw new UserException.BadInput("Input file name " + fName + " does not end with .sam or .bam");
            }
            String prefix = fName.substring(0, pos);
            String outName = prefix + ext;
            if (this.writerMap.containsKey(rid)) {
                throw new StingException("nWayOut mode: Reader id for input sam file " + fName + " is already registered");
            }
            this.addWriter(rid, outName, order, presorted, indexOnTheFly, generateMD5, pRecord);
        }
    }

    private void addWriter(SAMReaderID id, String outName, SAMFileHeader.SortOrder order, boolean presorted, boolean indexOnTheFly, boolean generateMD5, SAMProgramRecord programRecord) {
        File f2 = new File(outName);
        SAMFileHeader header = Utils.setupWriter(this.toolkit.getSAMFileHeader(id), programRecord);
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        factory.setCreateIndex(indexOnTheFly);
        factory.setCreateMd5File(generateMD5);
        SAMFileWriter sw = factory.makeSAMOrBAMWriter(header, presorted, f2);
        this.writerMap.put(id, sw);
    }

    public Collection<SAMFileWriter> getWriters() {
        return this.writerMap.values();
    }

    @Override
    public void addAlignment(SAMRecord samRecord) {
        SAMReaderID id = this.toolkit.getReaderIDForRead(samRecord);
        String rg = samRecord.getStringAttribute("RG");
        if (rg != null) {
            String rg_orig = this.toolkit.getReadsDataSource().getOriginalReadGroupId(rg);
            samRecord.setAttribute("RG", (Object)rg_orig);
        }
        this.addAlignment(samRecord, id);
    }

    public void addAlignment(SAMRecord samRecord, SAMReaderID readerID) {
        this.writerMap.get(readerID).addAlignment(samRecord);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.toolkit.getSAMFileHeader();
    }

    @Override
    public void close() {
        for (SAMFileWriter w2 : this.writerMap.values()) {
            w2.close();
        }
    }
}

