/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.runtime.CapturedStreamOutput;
import org.broadinstitute.sting.utils.runtime.InputStreamSettings;
import org.broadinstitute.sting.utils.runtime.ProcessOutput;
import org.broadinstitute.sting.utils.runtime.ProcessSettings;
import org.broadinstitute.sting.utils.runtime.StreamLocation;
import org.broadinstitute.sting.utils.runtime.StreamOutput;

public class ProcessController {
    private static Logger logger = Logger.getLogger(ProcessController.class);
    private static final Set<ProcessController> running = Collections.synchronizedSet(new HashSet());
    private Process process;
    private final OutputCapture stdoutCapture;
    private final OutputCapture stderrCapture;
    private boolean destroyed = false;
    private final Map<ProcessStream, CapturedStreamOutput> toCapture = new EnumMap<ProcessStream, CapturedStreamOutput>(ProcessStream.class);
    private final Map<ProcessStream, StreamOutput> fromCapture = new EnumMap<ProcessStream, StreamOutput>(ProcessStream.class);
    private static int nextControllerId = 0;
    private final int controllerId;
    private static final ThreadLocal<ProcessController> threadProcessController = new ThreadLocal<ProcessController>(){

        @Override
        protected ProcessController initialValue() {
            return new ProcessController();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessController() {
        Set<ProcessController> set = running;
        synchronized (set) {
            this.controllerId = nextControllerId++;
        }
        this.stdoutCapture = new OutputCapture(ProcessStream.Stdout, this.controllerId);
        this.stderrCapture = new OutputCapture(ProcessStream.Stderr, this.controllerId);
        this.stdoutCapture.start();
        this.stderrCapture.start();
    }

    public static ProcessController getThreadLocal() {
        if (ProcessController.threadProcessController.get().destroyed) {
            threadProcessController.remove();
        }
        return threadProcessController.get();
    }

    public static int exec(String[] command) {
        ProcessController controller = ProcessController.getThreadLocal();
        return controller.exec(new ProcessSettings(command)).getExitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessOutput exec(ProcessSettings settings) {
        int exitCode;
        Map<ProcessStream, CapturedStreamOutput> map;
        if (this.destroyed) {
            throw new IllegalStateException("This controller was destroyed");
        }
        ProcessBuilder builder = new ProcessBuilder(settings.getCommand());
        builder.directory(settings.getDirectory());
        Map<String, String> settingsEnvironment = settings.getEnvironment();
        if (settingsEnvironment != null) {
            Map<String, String> builderEnvironment = builder.environment();
            builderEnvironment.clear();
            builderEnvironment.putAll(settingsEnvironment);
        }
        builder.redirectErrorStream(settings.isRedirectErrorStream());
        StreamOutput stdout = null;
        StreamOutput stderr = null;
        try {
            Map<ProcessStream, CapturedStreamOutput> map2 = this.toCapture;
            synchronized (map2) {
                this.process = builder.start();
            }
            running.add(this);
        }
        catch (IOException e2) {
            throw new ReviewedStingException("Unable to start command: " + StringUtils.join(builder.command(), (String)" "));
        }
        try {
            map = this.toCapture;
            synchronized (map) {
                this.toCapture.put(ProcessStream.Stdout, new CapturedStreamOutput(settings.getStdoutSettings(), this.process.getInputStream(), System.out));
                this.toCapture.put(ProcessStream.Stderr, new CapturedStreamOutput(settings.getStderrSettings(), this.process.getErrorStream(), System.err));
                this.toCapture.notifyAll();
            }
            InputStreamSettings stdinSettings = settings.getStdinSettings();
            Set<StreamLocation> streamLocations = stdinSettings.getStreamLocations();
            if (!streamLocations.isEmpty()) {
                try {
                    OutputStream stdinStream = this.process.getOutputStream();
                    for (StreamLocation location : streamLocations) {
                        InputStream inputStream;
                        switch (location) {
                            case Buffer: {
                                inputStream = new ByteArrayInputStream(stdinSettings.getInputBuffer());
                                break;
                            }
                            case File: {
                                try {
                                    inputStream = FileUtils.openInputStream(stdinSettings.getInputFile());
                                    break;
                                }
                                catch (IOException e3) {
                                    throw new UserException.BadInput(e3.getMessage());
                                }
                            }
                            case Standard: {
                                inputStream = System.in;
                                break;
                            }
                            default: {
                                throw new ReviewedStingException("Unexpected stream location: " + (Object)((Object)location));
                            }
                        }
                        try {
                            IOUtils.copy(inputStream, stdinStream);
                        }
                        finally {
                            if (location == StreamLocation.Standard) continue;
                            IOUtils.closeQuietly(inputStream);
                        }
                    }
                    stdinStream.flush();
                }
                catch (IOException e4) {
                    throw new ReviewedStingException("Error writing to stdin on command: " + StringUtils.join(builder.command(), (String)" "), e4);
                }
            }
            try {
                this.process.getOutputStream().close();
                this.process.waitFor();
            }
            catch (IOException e5) {
                throw new ReviewedStingException("Unable to close stdin on command: " + StringUtils.join(builder.command(), (String)" "), e5);
            }
            catch (InterruptedException e6) {
                throw new ReviewedStingException("Process interrupted", e6);
            }
            finally {
                while (!this.destroyed && stdout == null || stderr == null) {
                    Map<ProcessStream, StreamOutput> map3 = this.fromCapture;
                    synchronized (map3) {
                        if (this.fromCapture.containsKey((Object)ProcessStream.Stdout)) {
                            stdout = this.fromCapture.remove((Object)ProcessStream.Stdout);
                        }
                        if (this.fromCapture.containsKey((Object)ProcessStream.Stderr)) {
                            stderr = this.fromCapture.remove((Object)ProcessStream.Stderr);
                        }
                        try {
                            if (stdout == null || stderr == null) {
                                this.fromCapture.wait();
                            }
                        }
                        catch (InterruptedException e7) {
                            logger.error(e7);
                        }
                    }
                }
                if (this.destroyed) {
                    if (stdout == null) {
                        stdout = StreamOutput.EMPTY;
                    }
                    if (stderr == null) {
                        stderr = StreamOutput.EMPTY;
                    }
                }
            }
        }
        finally {
            map = this.toCapture;
            synchronized (map) {
                exitCode = this.process.exitValue();
                this.process = null;
            }
            running.remove(this);
        }
        return new ProcessOutput(exitCode, stdout, stderr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ProcessController> getRunning() {
        Set<ProcessController> set = running;
        synchronized (set) {
            return new HashSet<ProcessController>(running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryDestroy() {
        this.destroyed = true;
        Map<ProcessStream, CapturedStreamOutput> map = this.toCapture;
        synchronized (map) {
            if (this.process != null) {
                this.process.destroy();
                IOUtils.closeQuietly(this.process.getInputStream());
                IOUtils.closeQuietly(this.process.getErrorStream());
            }
            this.stdoutCapture.interrupt();
            this.stderrCapture.interrupt();
            this.toCapture.notifyAll();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.tryDestroy();
        }
        catch (Exception e2) {
            logger.error(e2);
        }
        super.finalize();
    }

    private class OutputCapture
    extends Thread {
        private final int controllerId;
        private final ProcessStream key;

        public OutputCapture(ProcessStream key, int controllerId) {
            super(String.format("OutputCapture-%d-%s-%s-%d", controllerId, key.name().toLowerCase(), Thread.currentThread().getName(), Thread.currentThread().getId()));
            this.controllerId = controllerId;
            this.key = key;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ProcessController.this.destroyed) {
                Map map;
                StreamOutput processStream = StreamOutput.EMPTY;
                try {
                    Object capturedProcessStream = null;
                    while (!ProcessController.this.destroyed && capturedProcessStream == null) {
                        map = ProcessController.this.toCapture;
                        synchronized (map) {
                            if (ProcessController.this.toCapture.containsKey((Object)this.key)) {
                                capturedProcessStream = (CapturedStreamOutput)ProcessController.this.toCapture.remove((Object)this.key);
                            } else {
                                ProcessController.this.toCapture.wait();
                            }
                        }
                    }
                    if (ProcessController.this.destroyed) continue;
                    processStream = capturedProcessStream;
                    ((CapturedStreamOutput)capturedProcessStream).readAndClose();
                }
                catch (InterruptedException e2) {
                    logger.info("OutputCapture interrupted, exiting");
                    break;
                }
                catch (IOException e3) {
                    logger.error("Error reading process output", e3);
                }
                finally {
                    map = ProcessController.this.fromCapture;
                    synchronized (map) {
                        ProcessController.this.fromCapture.put(this.key, processStream);
                        ProcessController.this.fromCapture.notify();
                    }
                }
            }
        }
    }

    private static enum ProcessStream {
        Stdout,
        Stderr;

    }
}

