/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration.covariates;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.covariates.ExperimentalCovariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;

public abstract class RepeatCovariate
implements ExperimentalCovariate {
    protected int MAX_REPEAT_LENGTH;
    protected int MAX_STR_UNIT_LENGTH;
    private final HashMap<String, Integer> repeatLookupTable = new HashMap();
    private final HashMap<Integer, String> repeatReverseLookupTable = new HashMap();
    private int nextId = 0;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.MAX_STR_UNIT_LENGTH = RAC.MAX_STR_UNIT_LENGTH;
        this.MAX_REPEAT_LENGTH = RAC.MAX_REPEAT_LENGTH;
    }

    @Override
    public void recordValues(GATKSAMRecord read, ReadCovariates values) {
        byte[] originalBases = (byte[])read.getReadBases().clone();
        boolean negativeStrand = read.getReadNegativeStrandFlag();
        byte[] bases = read.getReadBases();
        if (negativeStrand) {
            bases = BaseUtils.simpleReverseComplement(bases);
        }
        if (!BaseUtils.isAllRegularBases(bases)) {
            return;
        }
        for (int i2 = 0; i2 < bases.length; ++i2) {
            Pair<byte[], Integer> res = this.findTandemRepeatUnits(bases, i2);
            String repeatID = this.getCovariateValueFromUnitAndLength((byte[])res.first, (Integer)res.second);
            int key = this.keyForRepeat(repeatID);
            int readOffset = negativeStrand ? bases.length - i2 - 1 : i2;
            values.addCovariate(key, key, key, readOffset);
        }
        read.setReadBases(originalBases);
    }

    private Pair<byte[], Integer> findTandemRepeatUnits(byte[] readBases, int offset) {
        int maxBW = 0;
        byte[] bestBWRepeatUnit = new byte[]{readBases[offset]};
        for (int str = 1; str <= this.MAX_STR_UNIT_LENGTH && offset + 1 - str >= 0; ++str) {
            byte[] backwardRepeatUnit = Arrays.copyOfRange(readBases, offset - str + 1, offset + 1);
            maxBW = GATKVariantContextUtils.findNumberofRepetitions(backwardRepeatUnit, Arrays.copyOfRange(readBases, 0, offset + 1), false);
            if (maxBW <= 1) continue;
            bestBWRepeatUnit = (byte[])backwardRepeatUnit.clone();
            break;
        }
        byte[] bestRepeatUnit = bestBWRepeatUnit;
        int maxRL = maxBW;
        if (offset < readBases.length - 1) {
            byte[] bestFWRepeatUnit = new byte[]{readBases[offset + 1]};
            int maxFW = 0;
            for (int str = 1; str <= this.MAX_STR_UNIT_LENGTH && offset + str + 1 <= readBases.length; ++str) {
                byte[] forwardRepeatUnit = Arrays.copyOfRange(readBases, offset + 1, offset + str + 1);
                maxFW = GATKVariantContextUtils.findNumberofRepetitions(forwardRepeatUnit, Arrays.copyOfRange(readBases, offset + 1, readBases.length), true);
                if (maxFW <= 1) continue;
                bestFWRepeatUnit = (byte[])forwardRepeatUnit.clone();
                break;
            }
            if (Arrays.equals(bestFWRepeatUnit, bestBWRepeatUnit)) {
                maxRL = maxBW + maxFW;
                bestRepeatUnit = bestFWRepeatUnit;
            } else {
                maxBW = GATKVariantContextUtils.findNumberofRepetitions(bestFWRepeatUnit, Arrays.copyOfRange(readBases, 0, offset + 1), false);
                maxRL = maxFW + maxBW;
                bestRepeatUnit = bestFWRepeatUnit;
            }
        }
        if (maxRL > this.MAX_REPEAT_LENGTH) {
            maxRL = this.MAX_REPEAT_LENGTH;
        }
        return new Pair<byte[], Integer>(bestRepeatUnit, maxRL);
    }

    @Override
    public final Object getValue(String str) {
        return str;
    }

    @Override
    public synchronized String formatKey(int key) {
        return this.repeatReverseLookupTable.get(key);
    }

    @Requires(value={"repeatLength>=0", "repeatFromUnitAndLength != null"})
    @Ensures(value={"result != null"})
    protected abstract String getCovariateValueFromUnitAndLength(byte[] var1, int var2);

    @Override
    public int keyFromValue(Object value) {
        return this.keyForRepeat((String)value);
    }

    public Set<Map.Entry<String, Integer>> getKeyMap() {
        return this.repeatLookupTable.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int keyForRepeat(String repeatID) {
        if (!this.repeatLookupTable.containsKey(repeatID)) {
            RepeatCovariate repeatCovariate = this;
            synchronized (repeatCovariate) {
                if (!this.repeatLookupTable.containsKey(repeatID)) {
                    this.repeatLookupTable.put(repeatID, this.nextId);
                    this.repeatReverseLookupTable.put(this.nextId, repeatID);
                    ++this.nextId;
                }
            }
        }
        return this.repeatLookupTable.get(repeatID);
    }

    @Requires(value={"value != null"})
    @Ensures(value={"result.first != null", "result.second>=0"})
    public static Pair<String, Integer> getRUandNRfromCovariate(String value) {
        int k2 = 0;
        for (k2 = 0; k2 < value.length() && BaseUtils.isRegularBase(value.getBytes()[k2]); ++k2) {
        }
        Integer nr = Integer.valueOf(value.substring(k2, value.length()));
        if (k2 == value.length() || nr <= 0) {
            throw new IllegalStateException("Covariate is not of form (Repeat Unit) + Integer");
        }
        return new Pair<String, Integer>(value.substring(0, k2), nr);
    }

    @Requires(value={"numRepeats > 0", "repeatUnit != null"})
    @Ensures(value={"result != null"})
    public static String getBasesFromRUandNR(String repeatUnit, int numRepeats) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < numRepeats; ++i2) {
            sb.append(repeatUnit);
        }
        return sb.toString();
    }

    public static String getBasesFromRUandNR(String covariateValue) {
        Pair<String, Integer> pair = RepeatCovariate.getRUandNRfromCovariate(covariateValue);
        return RepeatCovariate.getBasesFromRUandNR(pair.getFirst(), pair.getSecond());
    }

    @Override
    public abstract int maximumKeyValue();
}

