/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.SAMUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.pairhmm.PairHMM;
import org.broadinstitute.sting.utils.text.XReadLines;

public class PairHMMTestData {
    public final String ref;
    private final String read;
    public final byte[] baseQuals;
    public final byte[] insQuals;
    public final byte[] delQuals;
    public final byte[] gcp;
    public final double log10l;

    PairHMMTestData(String ref, String read, byte[] baseQuals, byte[] insQuals, byte[] delQuals, byte[] gcp, double log10l) {
        this.ref = ref;
        this.read = read;
        this.baseQuals = baseQuals;
        this.insQuals = insQuals;
        this.delQuals = delQuals;
        this.gcp = gcp;
        this.log10l = log10l;
    }

    PairHMMTestData(String ref, String read, byte qual) {
        this.ref = ref;
        this.read = read;
        this.delQuals = Utils.dupBytes(qual, read.length());
        this.insQuals = this.delQuals;
        this.baseQuals = this.delQuals;
        this.gcp = Utils.dupBytes((byte)10, read.length());
        this.log10l = -1.0;
    }

    public double runHMM(PairHMM hmm) {
        hmm.initialize(this.getRead().length(), this.ref.length());
        return hmm.computeReadLikelihoodGivenHaplotypeLog10(this.ref.getBytes(), this.getRead().getBytes(), this.baseQuals, this.insQuals, this.delQuals, this.gcp, true);
    }

    public String toString() {
        return "Info{ref='" + this.ref + '\'' + ", read='" + this.getRead() + '\'' + ", log10l=" + this.log10l + '}';
    }

    public static void runHMMs(PairHMM hmm, List<PairHMMTestData> data, boolean runSingly) {
        if (runSingly) {
            for (PairHMMTestData datum : data) {
                datum.runHMM(hmm);
            }
        } else {
            PairHMMTestData first = data.get(0);
            int maxHaplotypeLen = PairHMMTestData.calcMaxHaplotypeLen(data);
            hmm.initialize(first.getRead().length(), maxHaplotypeLen);
            for (PairHMMTestData datum : data) {
                hmm.computeReadLikelihoodGivenHaplotypeLog10(datum.ref.getBytes(), datum.getRead().getBytes(), datum.baseQuals, datum.insQuals, datum.delQuals, datum.gcp, false);
            }
        }
    }

    public static int calcMaxHaplotypeLen(List<PairHMMTestData> data) {
        int maxHaplotypeLen = 0;
        for (PairHMMTestData datum : data) {
            maxHaplotypeLen = Math.max(maxHaplotypeLen, datum.ref.length());
        }
        return maxHaplotypeLen;
    }

    public static Map<String, List<PairHMMTestData>> readLikelihoods(File file) throws IOException {
        LinkedHashMap<String, List<PairHMMTestData>> results = new LinkedHashMap<String, List<PairHMMTestData>>();
        InputStream in = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        for (String line : new XReadLines(in)) {
            String[] parts = line.split(" ");
            PairHMMTestData info = new PairHMMTestData(parts[0], parts[1], SAMUtils.fastqToPhred(parts[2]), SAMUtils.fastqToPhred(parts[3]), SAMUtils.fastqToPhred(parts[4]), SAMUtils.fastqToPhred(parts[5]), Double.parseDouble(parts[6]));
            if (!results.containsKey(info.read)) {
                results.put(info.read, new LinkedList());
            }
            List byHap = (List)results.get(info.read);
            byHap.add(info);
        }
        return results;
    }

    public String getRead() {
        return this.read;
    }
}

