/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Requires;
import org.broadinstitute.sting.utils.pairhmm.PairHMM;

abstract class N2MemoryPairHMM
extends PairHMM {
    protected double[][] transition = null;
    protected double[][] prior = null;
    protected double[][] matchMatrix = null;
    protected double[][] insertionMatrix = null;
    protected double[][] deletionMatrix = null;

    N2MemoryPairHMM() {
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        this.matchMatrix = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
        this.insertionMatrix = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
        this.deletionMatrix = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
    }

    protected void dumpMatrices() {
        this.dumpMatrix("matchMetricArray", this.matchMatrix);
        this.dumpMatrix("insertionMatrix", this.insertionMatrix);
        this.dumpMatrix("deletionMatrix", this.deletionMatrix);
    }

    @Requires(value={"name != null", "matrix != null"})
    private void dumpMatrix(String name, double[][] matrix) {
        System.out.printf("%s%n", name);
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            System.out.printf("\t%s[%d]", name, i2);
            for (int j2 = 0; j2 < matrix[i2].length; ++j2) {
                if (Double.isInfinite(matrix[i2][j2])) {
                    System.out.printf(" %15s", String.format("%f", matrix[i2][j2]));
                    continue;
                }
                System.out.printf(" % 15.5e", matrix[i2][j2]);
            }
            System.out.println();
        }
    }
}

