/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broad.tribble.FeatureCodec;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.walkers.qc.DocumentationTest;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocletUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeatureHandler;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeatureObject;
import org.broadinstitute.sting.utils.help.ForumAPIUtils;
import org.broadinstitute.sting.utils.help.GATKDocWorkUnit;
import org.broadinstitute.sting.utils.help.GenericDocumentationHandler;
import org.broadinstitute.sting.utils.text.XReadLines;

public class GATKDoclet {
    protected static final Logger logger = Logger.getLogger(GATKDoclet.class);
    protected static final File SETTINGS_DIR = new File("settings/helpTemplates");
    protected static final File DESTINATION_DIR = new File("gatkdocs");
    private static final String FORUM_KEY_FILE = "/local/gsa-engineering/gatkdocs_publisher/forum.key";
    protected static String buildTimestamp = null;
    protected static String absoluteVersion = null;
    protected static boolean showHiddenFeatures = false;
    protected static boolean testOnly = false;
    private static final List<Class<?>> testOnlyKeepers = Arrays.asList(DocumentationTest.class, CommandLineGATK.class, UserException.class);
    RootDoc rootDoc;
    Set<GATKDocWorkUnit> myWorkUnits;
    static final Collection<DocumentedGATKFeatureObject> STATIC_DOCS = new ArrayList<DocumentedGATKFeatureObject>();

    public static boolean start(RootDoc rootDoc) throws IOException {
        logger.setLevel(Level.INFO);
        for (String[] options : rootDoc.options()) {
            if (options[0].equals("-build-timestamp")) {
                buildTimestamp = options[1];
            }
            if (options[0].equals("-absolute-version")) {
                absoluteVersion = options[1];
            }
            if (options[0].equals("-include -hidden")) {
                showHiddenFeatures = true;
            }
            if (!options[0].equals("-test")) continue;
            testOnly = true;
        }
        new GATKDoclet().processDocs(rootDoc);
        return true;
    }

    public static int optionLength(String option) {
        if (option.equals("-build-timestamp") || option.equals("-absolute-version") || option.equals("-include-hidden")) {
            return 2;
        }
        if (option.equals("-test")) {
            return 1;
        }
        return 0;
    }

    public boolean showHiddenFeatures() {
        return showHiddenFeatures;
    }

    private void processDocs(RootDoc rootDoc) {
        this.rootDoc = rootDoc;
        try {
            DESTINATION_DIR.mkdirs();
            FileUtils.copyFile(new File(SETTINGS_DIR + "/bootstrap.min.css"), new File(DESTINATION_DIR + "/bootstrap.min.css"));
            FileUtils.copyFile(new File(SETTINGS_DIR + "/bootstrap.min.js"), new File(DESTINATION_DIR + "/bootstrap.min.js"));
            FileUtils.copyFile(new File(SETTINGS_DIR + "/jquery.min.js"), new File(DESTINATION_DIR + "/jquery.min.js"));
            FileUtils.writeByteArrayToFile(new File(DESTINATION_DIR + "/current.version.txt"), GATKDoclet.getSimpleVersion(absoluteVersion).getBytes());
            Configuration cfg = new Configuration();
            cfg.setDirectoryForTemplateLoading(SETTINGS_DIR);
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            this.myWorkUnits = this.computeWorkUnits();
            ArrayList<Map<String, String>> groups = new ArrayList<Map<String, String>>();
            HashSet<String> seenDocumentationFeatures = new HashSet<String>();
            ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
            for (GATKDocWorkUnit workUnit : this.myWorkUnits) {
                data.add(workUnit.indexDataMap());
                if (seenDocumentationFeatures.contains(workUnit.annotation.groupName())) continue;
                groups.add(GATKDoclet.toMap(workUnit.annotation));
                seenDocumentationFeatures.add(workUnit.annotation.groupName());
            }
            for (GATKDocWorkUnit workUnit : this.myWorkUnits) {
                this.processDocWorkUnit(cfg, workUnit, groups, data);
            }
            this.processIndex(cfg, new ArrayList<GATKDocWorkUnit>(this.myWorkUnits));
            File forumKeyFile = new File(FORUM_KEY_FILE);
            if (forumKeyFile.exists()) {
                String forumKey = null;
                Iterator<String> i$ = new XReadLines(forumKeyFile).iterator();
                while (i$.hasNext()) {
                    String line;
                    forumKey = line = i$.next();
                }
                this.updateForum(this.myWorkUnits, forumKey);
            }
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private void updateForum(Set<GATKDocWorkUnit> docWorkUnits, String forumKey) {
        List<String> old = ForumAPIUtils.getPostedTools(forumKey);
        for (String s2 : old) {
            System.out.println(s2);
        }
        System.out.printf("Forum has %d items%n", old.size());
        System.out.printf("Docs have %d items%n", docWorkUnits.size());
        ArrayList<GATKDocWorkUnit> toAdd = new ArrayList<GATKDocWorkUnit>();
        for (GATKDocWorkUnit tool : docWorkUnits) {
            if (old.contains(tool.name)) continue;
            System.out.println("WILL POST: " + tool.name + " TO FORUM");
            toAdd.add(tool);
        }
        for (GATKDocWorkUnit tool : toAdd) {
            ForumAPIUtils.postToForum(tool, forumKey);
        }
    }

    private Set<GATKDocWorkUnit> computeWorkUnits() {
        TreeSet<GATKDocWorkUnit> m2 = new TreeSet<GATKDocWorkUnit>();
        for (ClassDoc doc : this.rootDoc.classes()) {
            DocumentedGATKFeatureObject feature;
            DocumentedGATKFeatureHandler handler;
            Class<? extends Object> clazz = this.getClassForClassDoc(doc);
            if (clazz != null && testOnly && !testOnlyKeepers.contains(clazz) || (handler = this.createHandler(doc, feature = this.getFeatureForClassDoc(doc))) == null || !handler.includeInDocs(doc)) continue;
            String filename = handler.getDestinationFilename(doc, clazz);
            GATKDocWorkUnit unit = new GATKDocWorkUnit(doc.name(), filename, feature.groupName(), feature, handler, doc, clazz, buildTimestamp, absoluteVersion);
            m2.add(unit);
        }
        return m2;
    }

    private DocumentedGATKFeatureHandler createHandler(ClassDoc doc, DocumentedGATKFeatureObject feature) {
        if (feature != null) {
            if (feature.enable()) {
                GenericDocumentationHandler handler = new GenericDocumentationHandler();
                handler.setDoclet(this);
                return handler;
            }
            logger.info("Skipping disabled Documentation for " + doc);
        }
        return null;
    }

    private DocumentedGATKFeatureObject getFeatureForClassDoc(ClassDoc doc) {
        Class<? extends Object> docClass = this.getClassForClassDoc(doc);
        if (docClass == null) {
            return null;
        }
        if (docClass.isAnnotationPresent(DocumentedGATKFeature.class)) {
            DocumentedGATKFeature f2 = docClass.getAnnotation(DocumentedGATKFeature.class);
            return new DocumentedGATKFeatureObject(docClass, f2.enable(), f2.groupName(), f2.summary(), f2.extraDocs());
        }
        for (DocumentedGATKFeatureObject staticDocs : STATIC_DOCS) {
            if (!staticDocs.getClassToDoc().isAssignableFrom(docClass)) continue;
            return new DocumentedGATKFeatureObject(docClass, staticDocs.enable(), staticDocs.groupName(), staticDocs.summary(), staticDocs.extraDocs());
        }
        return null;
    }

    private Class<? extends Object> getClassForClassDoc(ClassDoc doc) {
        try {
            return DocletUtils.getClassForDoc((ProgramElementDoc)doc);
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
        catch (NoClassDefFoundError e3) {
            return null;
        }
        catch (UnsatisfiedLinkError e4) {
            return null;
        }
    }

    private void processIndex(Configuration cfg, List<GATKDocWorkUnit> indexData) throws IOException {
        Template temp = cfg.getTemplate("generic.index.template.html");
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(new File(DESTINATION_DIR + "/index.html")));
        try {
            temp.process(this.groupIndexData(indexData), (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException e2) {
            throw new ReviewedStingException("Failed to create GATK documentation", e2);
        }
    }

    private Map<String, Object> groupIndexData(List<GATKDocWorkUnit> indexData) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Collections.sort(indexData);
        ArrayList<Map<String, String>> groups = new ArrayList<Map<String, String>>();
        HashSet<String> seenDocumentationFeatures = new HashSet<String>();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        for (GATKDocWorkUnit workUnit : indexData) {
            data.add(workUnit.indexDataMap());
            if (seenDocumentationFeatures.contains(workUnit.annotation.groupName())) continue;
            groups.add(GATKDoclet.toMap(workUnit.annotation));
            seenDocumentationFeatures.add(workUnit.annotation.groupName());
        }
        root.put("data", data);
        root.put("groups", groups);
        root.put("timestamp", buildTimestamp);
        root.put("version", absoluteVersion);
        return root;
    }

    private static final Map<String, String> toMap(DocumentedGATKFeatureObject annotation) {
        HashMap<String, String> root = new HashMap<String, String>();
        root.put("id", annotation.groupName().replaceAll("\\W", ""));
        root.put("name", annotation.groupName());
        root.put("summary", annotation.summary());
        String supercatValue = annotation.groupName().endsWith(" Tools") ? "tools" : (annotation.groupName().endsWith(" Utilities") ? "utilities" : (annotation.groupName().startsWith("Engine ") ? "engine" : "other"));
        root.put("supercat", supercatValue);
        return root;
    }

    public final GATKDocWorkUnit findWorkUnitForClass(Class c2) {
        for (GATKDocWorkUnit unit : this.myWorkUnits) {
            if (!unit.clazz.equals(c2)) continue;
            return unit;
        }
        return null;
    }

    public ClassDoc getClassDocForClass(Class clazz) {
        return this.rootDoc.classNamed(clazz.getName());
    }

    private void processDocWorkUnit(Configuration cfg, GATKDocWorkUnit unit, List<Map<String, String>> groups, List<Map<String, String>> data) throws IOException {
        unit.handler.processOne(unit);
        unit.forTemplate.put("groups", groups);
        unit.forTemplate.put("data", data);
        Template temp = cfg.getTemplate(unit.handler.getTemplateName(unit.classDoc));
        File outputPath = new File(DESTINATION_DIR + "/" + unit.filename);
        try {
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outputPath));
            temp.process(unit.forTemplate, (Writer)out);
            ((Writer)out).flush();
        }
        catch (TemplateException e2) {
            throw new ReviewedStingException("Failed to create GATK documentation", e2);
        }
    }

    private static String getSimpleVersion(String absoluteVersion) {
        String[] parts = absoluteVersion.split("-");
        for (int i2 = 1; i2 < 2; ++i2) {
            parts[0] = parts[0].concat("-");
            parts[0] = parts[0].concat(parts[i2]);
        }
        return parts[0];
    }

    static {
        STATIC_DOCS.add(new DocumentedGATKFeatureObject(FeatureCodec.class, "ROD Codecs", "Tribble codecs for reading reference ordered data (ROD) files such as VCF or BED"));
    }
}

