/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.haplotypeBAMWriter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.SAMFileWriter;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.genotyper.MostLikelyAllele;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.haplotype.Haplotype;
import org.broadinstitute.sting.utils.haplotypeBAMWriter.HaplotypeBAMWriter;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.Allele;

class CalledHaplotypeBAMWriter
extends HaplotypeBAMWriter {
    public CalledHaplotypeBAMWriter(SAMFileWriter bamWriter) {
        super(bamWriter);
    }

    @Override
    public void writeReadsAlignedToHaplotypes(List<Haplotype> haplotypes, GenomeLoc paddedReferenceLoc, List<Haplotype> bestHaplotypes, Set<Haplotype> calledHaplotypes, Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap) {
        if (calledHaplotypes.isEmpty()) {
            return;
        }
        this.writeHaplotypesAsReads(calledHaplotypes, calledHaplotypes, paddedReferenceLoc);
        HashMap<Allele, Haplotype> alleleToHaplotypeMap = new HashMap<Allele, Haplotype>(haplotypes.size());
        for (Haplotype haplotype : calledHaplotypes) {
            alleleToHaplotypeMap.put(Allele.create(haplotype.getBases()), haplotype);
        }
        Set<Allele> allelesOfCalledHaplotypes = alleleToHaplotypeMap.keySet();
        for (PerReadAlleleLikelihoodMap readAlleleLikelihoodMap : stratifiedReadMap.values()) {
            for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> entry : readAlleleLikelihoodMap.getLikelihoodReadMap().entrySet()) {
                if (entry.getKey().getMappingQuality() <= 0) continue;
                MostLikelyAllele bestAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele(entry.getValue(), allelesOfCalledHaplotypes);
                this.writeReadAgainstHaplotype(entry.getKey(), (Haplotype)alleleToHaplotypeMap.get(bestAllele.getMostLikelyAllele()), paddedReferenceLoc.getStart(), bestAllele.isInformative());
            }
        }
    }
}

