/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class RODMergingIterator
implements Iterator<RODRecordList>,
Iterable<RODRecordList> {
    PriorityQueue<Element> queue = new PriorityQueue();

    @Override
    public Iterator<RODRecordList> iterator() {
        return this;
    }

    public RODMergingIterator() {
    }

    public RODMergingIterator(Iterator<RODRecordList> it) {
        this.add(it);
    }

    public RODMergingIterator(Collection<Iterator<RODRecordList>> its) {
        for (Iterator<RODRecordList> it : its) {
            this.add(it);
        }
    }

    public void add(Iterator<RODRecordList> it) {
        if (it.hasNext()) {
            this.queue.add(new Element(it));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public RODRecordList next() {
        Element e2 = this.queue.poll();
        RODRecordList value = e2.next();
        if (e2.nextLoc != null) {
            this.queue.add(e2);
        }
        return value;
    }

    public GenomeLoc peekLocation() {
        return this.queue.peek().nextLoc;
    }

    public Collection<RODRecordList> allElementsLTE(RODRecordList elt) {
        return this.allElementsLTE(elt, true);
    }

    public Collection<RODRecordList> allElementsLTE(RODRecordList elt, boolean includeElt) {
        LinkedList<RODRecordList> all = new LinkedList<RODRecordList>();
        if (includeElt) {
            all.add(elt);
        }
        while (this.hasNext()) {
            Element x2 = this.queue.peek();
            int cmp = elt.getLocation().compareTo(x2.nextLoc);
            if (cmp < 0) break;
            all.add(this.next());
        }
        return all;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class Element
    implements Comparable<Element> {
        public LocationAwareSeekableRODIterator it = null;
        public GenomeLoc nextLoc = null;

        public Element(Iterator<RODRecordList> it) {
            if (it instanceof LocationAwareSeekableRODIterator) {
                this.it = (LocationAwareSeekableRODIterator)it;
                if (!it.hasNext()) {
                    throw new ReviewedStingException("Iterator is empty");
                }
            } else {
                throw new ReviewedStingException("Iterator passed to RODMergingIterator is not LocationAwareSeekableRODIterator");
            }
            this.update();
        }

        public Element update() {
            this.nextLoc = this.it.peekNextLocation();
            return this;
        }

        @Override
        public int compareTo(Element other) {
            if (this.nextLoc == null) {
                if (other.nextLoc != null) {
                    return 1;
                }
                return 0;
            }
            if (other.nextLoc == null) {
                return -1;
            }
            return this.nextLoc.compareTo(other.nextLoc);
        }

        public RODRecordList next() {
            RODRecordList value = (RODRecordList)this.it.next();
            this.update();
            return value;
        }
    }
}

