/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.refseq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.codecs.refseq.Transcript;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class RefSeqFeature
implements Transcript,
Feature {
    private String transcript_id;
    private int strand;
    private GenomeLoc transcript_interval;
    private GenomeLoc transcript_coding_interval;
    private List<GenomeLoc> exons;
    private String gene_name;
    private List<Integer> exon_frames;
    private String name;
    ArrayList<GenomeLoc> exonInRefOrderCache = null;

    public RefSeqFeature(GenomeLoc genomeLoc) {
        this.transcript_interval = genomeLoc;
    }

    @Override
    public String getTranscriptId() {
        return this.transcript_id;
    }

    @Override
    public int getStrand() {
        return this.strand;
    }

    @Override
    public GenomeLoc getLocation() {
        return this.transcript_interval;
    }

    @Override
    public GenomeLoc getCodingLocation() {
        return this.transcript_coding_interval;
    }

    @Override
    public String getGeneName() {
        return this.gene_name;
    }

    @Override
    public int getNumExons() {
        return this.exons.size();
    }

    @Override
    public GenomeLoc getExonLocation(int n2) {
        if (n2 >= this.exons.size() || n2 < 0) {
            throw new ReviewedStingException("Index out-of-bounds. Transcript has " + this.exons.size() + " exons; requested: " + n2);
        }
        return this.exons.get(n2);
    }

    @Override
    public List<GenomeLoc> getExons() {
        return this.exons;
    }

    public List<GenomeLoc> getExonsInInterval(GenomeLoc interval) {
        ArrayList<GenomeLoc> relevantExons = new ArrayList<GenomeLoc>(this.exons.size());
        for (GenomeLoc exon : this.getExons()) {
            if (!interval.containsP(exon)) continue;
            relevantExons.add(exon);
        }
        return relevantExons;
    }

    public List<Integer> getExonNumbersInInterval(GenomeLoc interval) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int iNo = 0;
        for (GenomeLoc exon : this.getExons()) {
            if (interval.containsP(exon)) {
                numbers.add(iNo);
            }
            ++iNo;
        }
        return numbers;
    }

    public String getTranscriptUniqueGeneName() {
        return String.format("%s(%s)", this.getGeneName(), this.getTranscriptId());
    }

    public String getOverlapString(GenomeLoc position) {
        boolean is_exon = false;
        StringBuilder overlapString = new StringBuilder();
        int exonNo = 1;
        for (GenomeLoc exon : this.exons) {
            if (exon.containsP(position)) {
                overlapString.append(String.format("exon_%d", exonNo));
                is_exon = true;
                break;
            }
            ++exonNo;
        }
        if (!is_exon) {
            if (this.overlapsCodingP(position)) {
                overlapString.append("Intron");
            } else {
                overlapString.append("UTR");
            }
        }
        return overlapString.toString();
    }

    public Integer getSortedOverlapInteger(GenomeLoc position) {
        ArrayList<GenomeLoc> exonsInReferenceOrder;
        int exonNo = -1;
        ArrayList<GenomeLoc> arrayList = exonsInReferenceOrder = this.exonInRefOrderCache != null ? this.exonInRefOrderCache : new ArrayList<GenomeLoc>(this.exons);
        if (this.exonInRefOrderCache == null) {
            Collections.sort(exonsInReferenceOrder);
        }
        this.exonInRefOrderCache = exonsInReferenceOrder;
        for (GenomeLoc exon : exonsInReferenceOrder) {
            if (exon.overlapsP(position)) {
                return ++exonNo;
            }
            ++exonNo;
        }
        return -1;
    }

    public GenomeLoc getSortedExonLoc(int offset) {
        ArrayList<GenomeLoc> exonsInReferenceOrder;
        ArrayList<GenomeLoc> arrayList = exonsInReferenceOrder = this.exonInRefOrderCache != null ? this.exonInRefOrderCache : new ArrayList<GenomeLoc>(this.exons);
        if (this.exonInRefOrderCache == null) {
            Collections.sort(exonsInReferenceOrder);
        }
        this.exonInRefOrderCache = exonsInReferenceOrder;
        return exonsInReferenceOrder.get(offset);
    }

    @Override
    public boolean overlapsP(GenomeLoc that) {
        return this.getLocation().overlapsP(that);
    }

    @Override
    public boolean overlapsCodingP(GenomeLoc that) {
        return this.transcript_coding_interval.overlapsP(that);
    }

    @Override
    public boolean overlapsExonP(GenomeLoc that) {
        for (GenomeLoc e2 : this.exons) {
            if (!e2.overlapsP(that)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder("000\t");
        b2.append(this.transcript_id);
        b2.append('\t');
        b2.append(this.getLocation().getContig());
        b2.append('\t');
        b2.append(this.strand == 1 ? (char)'+' : '-');
        b2.append('\t');
        b2.append(this.getLocation().getStart() - 1);
        b2.append('\t');
        b2.append(this.getLocation().getStop());
        b2.append('\t');
        b2.append(this.transcript_coding_interval.getStart() - 1);
        b2.append('\t');
        b2.append(this.transcript_coding_interval.getStop());
        b2.append('\t');
        b2.append(this.exons.size());
        b2.append('\t');
        for (GenomeLoc loc : this.exons) {
            b2.append(loc.getStart() - 1);
            b2.append(',');
        }
        b2.append('\t');
        for (GenomeLoc loc : this.exons) {
            b2.append(loc.getStop());
            b2.append(',');
        }
        b2.append("\t0\t");
        b2.append(this.gene_name);
        b2.append("\tcmpl\tcmpl\t");
        for (Integer f2 : this.exon_frames) {
            b2.append(f2);
            b2.append(',');
        }
        return b2.toString();
    }

    public static boolean isExon(RODRecordList l2) {
        if (l2 == null) {
            return false;
        }
        GenomeLoc loc = l2.getLocation();
        for (GATKFeature t2 : l2) {
            if (!((RefSeqFeature)t2.getUnderlyingObject()).overlapsExonP(loc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCoding(RODRecordList l2) {
        if (l2 == null) {
            return false;
        }
        GenomeLoc loc = l2.getLocation();
        for (GATKFeature t2 : l2) {
            if (!((RefSeqFeature)t2.getUnderlyingObject()).overlapsCodingP(loc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCodingExon(RODRecordList l2) {
        if (l2 == null) {
            return false;
        }
        GenomeLoc loc = l2.getLocation();
        for (GATKFeature t2 : l2) {
            if (!((RefSeqFeature)t2.getUnderlyingObject()).overlapsCodingP(loc) || !((RefSeqFeature)t2.getUnderlyingObject()).overlapsExonP(loc)) continue;
            return true;
        }
        return false;
    }

    public void setTranscript_id(String transcript_id) {
        this.transcript_id = transcript_id;
    }

    public void setStrand(int strand) {
        this.strand = strand;
    }

    public void setTranscript_interval(GenomeLoc transcript_interval) {
        this.transcript_interval = transcript_interval;
    }

    public void setTranscript_coding_interval(GenomeLoc transcript_coding_interval) {
        this.transcript_coding_interval = transcript_coding_interval;
    }

    public void setExons(List<GenomeLoc> exons) {
        this.exons = exons;
    }

    public void setGene_name(String gene_name) {
        this.gene_name = gene_name;
    }

    public void setExon_frames(List<Integer> exon_frames) {
        this.exon_frames = exon_frames;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getChr() {
        return this.transcript_interval.getContig();
    }

    @Override
    public int getStart() {
        return this.transcript_interval.getStart();
    }

    @Override
    public int getEnd() {
        return this.transcript_interval.getStop();
    }
}

