/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.util.LinkedList;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public enum NGSPlatform {
    ILLUMINA("ILLUMINA", "SLX", "SOLEXA"),
    SOLID("SOLID"),
    LS454("454"),
    COMPLETE_GENOMICS("COMPLETE"),
    PACBIO("PACBIO"),
    ION_TORRENT("IONTORRENT"),
    CAPILLARY("CAPILLARY"),
    HELICOS("HELICOS"),
    UNKNOWN("UNKNOWN");

    protected final String[] BAM_PL_NAMES;

    private NGSPlatform(String ... BAM_PL_NAMES) {
        if (BAM_PL_NAMES.length == 0) {
            throw new IllegalStateException("Platforms must have at least one name");
        }
        for (int i2 = 0; i2 < BAM_PL_NAMES.length; ++i2) {
            BAM_PL_NAMES[i2] = BAM_PL_NAMES[i2].toUpperCase();
        }
        this.BAM_PL_NAMES = BAM_PL_NAMES;
    }

    public final String getDefaultPlatform() {
        return this.BAM_PL_NAMES[0];
    }

    public static NGSPlatform fromRead(GATKSAMRecord read) {
        if (read == null) {
            throw new IllegalArgumentException("read cannot be null");
        }
        GATKSAMReadGroupRecord rg = read.getReadGroup();
        return rg == null ? UNKNOWN : rg.getNGSPlatform();
    }

    public static NGSPlatform fromReadGroupPL(String plFromRG) {
        if (plFromRG == null) {
            return UNKNOWN;
        }
        String pl = plFromRG.toUpperCase();
        for (NGSPlatform ngsPlatform : NGSPlatform.values()) {
            for (String bamPLName : ngsPlatform.BAM_PL_NAMES) {
                if (!pl.contains(bamPLName)) continue;
                return ngsPlatform;
            }
        }
        return UNKNOWN;
    }

    public static boolean isKnown(String platform) {
        return NGSPlatform.fromReadGroupPL(platform) != UNKNOWN;
    }

    public static String knownPlatformsString() {
        LinkedList<String> names = new LinkedList<String>();
        for (NGSPlatform pl : NGSPlatform.values()) {
            for (String name : pl.BAM_PL_NAMES) {
                names.add(name);
            }
        }
        return Utils.join(",", names);
    }
}

