/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;

public class CompareBAMAlignments
extends CommandLineProgram {
    @Argument(fullName="input", shortName="i", doc="xxx", required=true)
    public List<String> filenames;
    @Argument(fullName="maxIsize", shortName="s", doc="xxx", required=false)
    public int maxISize = -1;
    @Argument(fullName="incr", shortName="incr", doc="xxx", required=false)
    int incr = -1;

    @Override
    protected int execute() {
        try {
            ArrayList<SAMRecordIterator> readers = new ArrayList<SAMRecordIterator>();
            for (String filename : this.filenames) {
                File file = new File(filename);
                SAMFileReader reader = new SAMFileReader(file);
                reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
                readers.add(reader.iterator());
            }
            System.out.println("Reading...");
            int next = this.incr;
            int counter = 0;
            while (true) {
                ArrayList reads = new ArrayList();
                for (Iterator iterator : readers) {
                    if (!iterator.hasNext()) {
                        System.exit(0);
                    }
                    reads.add(iterator.next());
                }
                SAMRecord read1 = (SAMRecord)reads.get(0);
                if (read1.getInferredInsertSize() > this.maxISize) {
                    for (SAMRecord read : reads) {
                        if (this.incr > 0 && counter % this.incr == 0) {
                            next += this.incr;
                            System.err.println(new Date() + " - counter " + counter);
                            System.err.println("read: " + read.format());
                        }
                        if (!read1.getReadName().equals(read.getReadName())) {
                            this.bad(read1, read, "Names not equal");
                            continue;
                        }
                        if (read1.getAlignmentStart() != read.getAlignmentStart()) {
                            this.bad(read1, read, "Alignment starts not equal");
                        }
                        if (read1.getCigarString().equals(read.getCigarString())) continue;
                        this.bad(read1, read, "Unequal CIGAR strings");
                    }
                }
                ++counter;
            }
        }
        catch (Exception e2) {
            System.err.println("ERROR: " + e2);
            e2.printStackTrace();
            return 0;
        }
    }

    private void bad(SAMRecord read1, SAMRecord read2, String msg) {
        System.out.printf("%nBAD: %s%n", msg);
        System.out.printf("  read1:  %s %s %s %s%n", read1.getReadName(), read1.getAlignmentStart(), read1.getCigarString(), read1.getInferredInsertSize());
        System.out.printf("  read2:  %s %s %s %s%n", read2.getReadName(), read2.getAlignmentStart(), read2.getCigarString(), read2.getInferredInsertSize());
    }

    public static void main(String[] args) {
        try {
            CommandLineProgram.start(new CompareBAMAlignments(), args);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }
}

