/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.variant.bcf2.BCF2Codec;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFHeader;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools")
public class CatVariants
extends CommandLineProgram {
    private static Logger logger = Logger.getRootLogger();
    @Input(fullName="reference", shortName="R", doc="genome reference file <name>.fasta", required=true)
    private File refFile = null;
    @Input(fullName="variant", shortName="V", doc="Input VCF file/s named <name>.vcf or <name>.bcf", required=true)
    private List<File> variant = null;
    @Output(fullName="outputFile", shortName="out", doc="output file name <name>.vcf or <name>.bcf", required=true)
    private File outputFile = null;
    @Argument(fullName="assumeSorted", shortName="assumeSorted", doc="assumeSorted should be true if he input files are already sorted (based on the position of the variants", required=false)
    private Boolean assumeSorted = false;

    private static void printUsage() {
        System.err.println("Usage: java -cp dist/GenomeAnalysisTK.jar org.broadinstitute.sting.tools.CatVariants <reference> <input VCF or BCF files> <outputFile> [sorted (optional)]");
        System.err.println("    The input files can be of type: VCF (ends in .vcf or .VCF)");
        System.err.println("                                    BCF2 (ends in .bcf or .BCF)");
        System.err.println("    Output file must be vcf or bcf file (.vcf or .bcf)");
        System.err.println("    if the input files are already sorted, the last argument can indicate that");
    }

    @Override
    protected int execute() throws Exception {
        ReferenceSequenceFile ref;
        BasicConfigurator.configure();
        logger.setLevel(Level.INFO);
        try {
            ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.refFile);
        }
        catch (Exception e2) {
            throw new UserException("Couldn't load provided reference sequence file " + this.refFile, e2);
        }
        PositionComparator positionComparator = new PositionComparator();
        AbstractCollection priorityQueue = this.assumeSorted != false ? new LinkedList() : new PriorityQueue<Pair<Integer, File>>(10000, positionComparator);
        for (File file : this.variant) {
            if (!(file.getName().endsWith(".vcf") || file.getName().endsWith(".VCF") || file.getName().endsWith(".bcf") || file.getName().endsWith(".BCF"))) {
                System.err.println("File " + file.getAbsolutePath() + " should be <name>.vcf or <name>.bcf");
                CatVariants.printUsage();
                return 1;
            }
            if (this.assumeSorted.booleanValue()) {
                priorityQueue.add(new Pair<Integer, File>(0, file));
                continue;
            }
            if (!file.exists()) {
                throw new UserException(String.format("File %s doesn't exist", file.getAbsolutePath()));
            }
            boolean useVCF = file.getName().endsWith(".vcf") || file.getName().endsWith(".VCF");
            AbstractFeatureReader<VariantContext, Object> reader = useVCF ? AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), new VCFCodec(), false) : AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), new BCF2Codec(), false);
            CloseableTribbleIterator it = reader.iterator();
            if (!it.hasNext()) {
                System.err.println(String.format("File %s is empty. This file will be ignored", file.getAbsolutePath()));
                continue;
            }
            VariantContext vc = (VariantContext)it.next();
            int firstPosition = vc.getStart();
            reader.close();
            priorityQueue.add(new Pair<Integer, File>(firstPosition, file));
        }
        if (!this.outputFile.getName().endsWith(".vcf") && !this.outputFile.getName().endsWith(".VCF")) {
            throw new UserException(String.format("Output file %s should be <name>.vcf", this.outputFile));
        }
        FileOutputStream outputStream = new FileOutputStream(this.outputFile);
        EnumSet<Options> options = EnumSet.of(Options.INDEX_ON_THE_FLY);
        VariantContextWriter outputWriter = VariantContextWriterFactory.create(this.outputFile, outputStream, ref.getSequenceDictionary(), options);
        boolean firstFile = true;
        int count = 0;
        while (!priorityQueue.isEmpty()) {
            File file;
            ++count;
            file = (File)((Pair)priorityQueue.remove()).getSecond();
            if (!file.exists()) {
                throw new UserException(String.format("File %s doesn't exist", file.getAbsolutePath()));
            }
            boolean useVCF = file.getName().endsWith(".vcf") || file.getName().endsWith(".VCF");
            AbstractFeatureReader<VariantContext, Object> reader = useVCF ? AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), new VCFCodec(), false) : AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), new BCF2Codec(), false);
            if (count % 10 == 0) {
                System.out.print(count);
            } else {
                System.out.print(".");
            }
            if (firstFile) {
                VCFHeader header = (VCFHeader)reader.getHeader();
                outputWriter.writeHeader(header);
                firstFile = false;
            }
            CloseableTribbleIterator it = reader.iterator();
            while (it.hasNext()) {
                VariantContext vc = (VariantContext)it.next();
                outputWriter.add(vc);
            }
            reader.close();
        }
        System.out.println();
        outputStream.close();
        outputWriter.close();
        return 0;
    }

    public static void main(String[] args) {
        try {
            CatVariants instance = new CatVariants();
            CatVariants.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e2) {
            CatVariants.printUsage();
            CatVariants.exitSystemWithUserError(e2);
        }
        catch (Exception e3) {
            CatVariants.exitSystemWithError(e3);
        }
    }

    private static class PositionComparator
    implements Comparator<Pair<Integer, File>> {
        private PositionComparator() {
        }

        @Override
        public int compare(Pair<Integer, File> p1, Pair<Integer, File> p2) {
            int startPositionP2;
            int startPositionP1 = p1.getFirst();
            if (startPositionP1 == (startPositionP2 = p2.getFirst().intValue())) {
                return 0;
            }
            return startPositionP1 < startPositionP2 ? -1 : 1;
        }
    }
}

