/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.util.Hashtable;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class BCMMarkDupes {
    static final String inHT = "ht";

    public static void main(String[] args) throws Exception {
        int cnt = 0;
        int dcnt = 0;
        String inputfile = args[0];
        String index = inputfile + ".bai";
        String outputfile = args[1];
        boolean isBam = true;
        SAMFileReader sfr = null;
        sfr = isBam ? new SAMFileReader(new File(inputfile), new File(index)) : new SAMFileReader(new File(inputfile));
        SAMRecordIterator iter = sfr.iterator();
        SAMFileWriter fw = null;
        SAMFileHeader header = sfr.getFileHeader();
        fw = isBam ? new SAMFileWriterFactory().makeBAMWriter(header, true, new File(outputfile)) : new SAMFileWriterFactory().makeSAMWriter(header, true, new File(outputfile));
        Hashtable<String, String> ht = new Hashtable<String, String>(2000000);
        while (iter.hasNext()) {
            SAMRecord rec = (SAMRecord)iter.next();
            int start = 0;
            String strand = "N";
            if (rec.getReadNegativeStrandFlag()) {
                start = rec.getAlignmentEnd();
            } else {
                strand = "P";
                start = rec.getAlignmentStart();
            }
            if (start == 0) continue;
            ++cnt;
            String chromo = rec.getReferenceName();
            String key = chromo + strand + start;
            String s2 = (String)ht.get(key);
            if (s2 == null) {
                ht.put(key, inHT);
            } else {
                rec.setDuplicateReadFlag(true);
                ++dcnt;
            }
            fw.addAlignment(rec);
        }
        fw.close();
        System.err.println("Total records:" + cnt);
        System.err.println("Records marked as duplicates:" + dcnt);
        System.err.println("HT:" + ht.size());
    }

    public static String usage() {
        return "usage:\n\t<sam or bam file> [index file if using bam] <output file>";
    }
}

