/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.pipeline;

import edu.mit.broad.picard.util.PicardAggregationFsUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.sf.picard.io.IoUtil;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.pipeline.PicardAnalysisFiles;
import org.broadinstitute.sting.pipeline.PicardIntervals;
import org.broadinstitute.sting.pipeline.PicardSample;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.io.IOUtils;

public class PicardAggregationUtils {
    private static final Logger log = Logger.getLogger(PicardAggregationUtils.class);
    public static final String PICARD_AGGREGATION_DIR = "/seq/picard_aggregation/";
    private static final PicardAggregationFsUtil aggregationFsUtil = new PicardAggregationFsUtil(new File("/seq/picard_aggregation/"));

    public static List<PicardSample> parseSamples(File tsv) {
        return PicardAggregationUtils.parseSamples(tsv, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PicardSample> parseSamples(File tsv, boolean throwErrors) {
        ArrayList<PicardSample> picardSamples = new ArrayList<PicardSample>();
        int errors = 0;
        LineIterator it = IOUtils.lineIterator(tsv);
        try {
            int lineNum = 1;
            while (it.hasNext()) {
                String line = it.nextLine();
                String[] tokens = line.split("\t");
                if (tokens.length != 2) {
                    log.error(String.format("Line %d: Does not contain two tab separated values a project/sample: %s", lineNum, line));
                    ++errors;
                } else {
                    String project = tokens[0];
                    String sample = tokens[1];
                    int version = PicardAggregationUtils.getLatestVersion(project, sample);
                    if (version == 0) {
                        log.error(String.format("Line %d: Unable to find a latest version: %s", lineNum, line));
                        ++errors;
                    } else {
                        picardSamples.add(new PicardSample(project, sample, version));
                    }
                }
                ++lineNum;
            }
        }
        finally {
            it.close();
        }
        if (throwErrors && errors > 0) {
            throw new UserException.CouldNotReadInputFile(tsv, String.format("See logger errors for problematic lines.", new Object[0]));
        }
        return picardSamples;
    }

    public static PicardIntervals readAnalysisIntervals(List<PicardSample> picardSamples) {
        LinkedHashSet<PicardIntervals> seenIntervals = new LinkedHashSet<PicardIntervals>();
        for (PicardSample picardSample : picardSamples) {
            PicardAnalysisFiles analysis = new PicardAnalysisFiles(picardSample.getProject(), picardSample.getSample(), picardSample.getVersion());
            PicardIntervals picardIntervals = new PicardIntervals(analysis.getReferenceSequence(), analysis.getTargetIntervals());
            seenIntervals.add(picardIntervals);
        }
        if (seenIntervals.isEmpty()) {
            return null;
        }
        if (seenIntervals.size() == 1) {
            return (PicardIntervals)seenIntervals.iterator().next();
        }
        throw new UserException.BadArgumentValue("picardSamples", String.format("%d intervals found: %s", seenIntervals.size(), seenIntervals));
    }

    public static List<String> getSampleBams(List<PicardSample> picardSamples) {
        ArrayList<String> bams = new ArrayList<String>();
        for (PicardSample picardSample : picardSamples) {
            bams.add(PicardAggregationUtils.getSampleBam(picardSample.getProject(), picardSample.getSample(), picardSample.getVersion()));
        }
        return bams;
    }

    public static String getSampleBam(String project, String sample, int version) {
        return PicardAggregationUtils.getSampleFile(project, sample, version, "bam");
    }

    public static String getSampleFile(String project, String sample, int version, String extension) {
        return PicardAggregationUtils.getSampleDir(project, sample, version) + IoUtil.makeFileNameSafe(sample) + "." + extension;
    }

    public static String getSampleBam(String project, String sample) {
        return PicardAggregationUtils.getSampleFile(project, sample, "bam");
    }

    public static String getSampleFile(String project, String sample, String extension) {
        return PicardAggregationUtils.getSampleDir(project, sample) + IoUtil.makeFileNameSafe(sample) + "." + extension;
    }

    public static String getSampleDir(String project, String sample, int version) {
        return PICARD_AGGREGATION_DIR + String.format("%s/%s/v%d/", IoUtil.makeFileNameSafe(project), IoUtil.makeFileNameSafe(sample), version);
    }

    public static String getCurrentSampleDir(String project, String sample) {
        return PICARD_AGGREGATION_DIR + String.format("%s/%s/current/", IoUtil.makeFileNameSafe(project), IoUtil.makeFileNameSafe(sample));
    }

    public static String getCurrentSampleBam(String project, String sample) {
        return PicardAggregationUtils.getCurrentSampleFile(project, sample, "bam");
    }

    public static String getCurrentSampleFile(String project, String sample, String extension) {
        return PICARD_AGGREGATION_DIR + String.format("%1$s/%2$s/current/%2$s.%3$s", IoUtil.makeFileNameSafe(project), IoUtil.makeFileNameSafe(sample), extension);
    }

    public static String getSampleDir(String project, String sample) {
        int latestVersion = PicardAggregationUtils.getLatestVersion(project, sample);
        if (latestVersion == 0) {
            throw new UserException.BadArgumentValue("project/sample", "Unable to find a finished directory for project sample " + project + "/" + sample);
        }
        return PicardAggregationUtils.getSampleDir(project, sample, latestVersion);
    }

    public static int getLatestVersion(String project, String sample) {
        File sampleDirectory = new File(PICARD_AGGREGATION_DIR + project + "/" + IoUtil.makeFileNameSafe(sample));
        if (!sampleDirectory.exists()) {
            return 0;
        }
        File[] versions = sampleDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith("v") && file.isDirectory();
            }
        });
        int latestVersion = 0;
        File latest = null;
        for (File f2 : versions) {
            if (!aggregationFsUtil.isFinished(f2)) continue;
            int v2 = Integer.parseInt(f2.getName().substring(1));
            if (latest != null && v2 <= latestVersion) continue;
            latestVersion = v2;
            latest = f2;
        }
        return latestVersion;
    }

    public static boolean isFinished(String project, String sample, int version) {
        return aggregationFsUtil.isFinished(new File(PicardAggregationUtils.getSampleDir(project, sample, version)));
    }
}

