/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.LineReaderUtil;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.readers.TabixIteratorLineReader;
import org.broad.tribble.readers.TabixReader;
import org.broad.tribble.util.ParsingUtils;

public class TabixFeatureReader<T extends Feature, SOURCE>
extends AbstractFeatureReader<T, SOURCE> {
    TabixReader tabixReader;
    List<String> sequenceNames;

    public TabixFeatureReader(String featureFile, AsciiFeatureCodec codec) throws IOException {
        super(featureFile, codec);
        this.tabixReader = new TabixReader(featureFile);
        this.sequenceNames = new ArrayList<String>(this.tabixReader.mChr2tid.keySet());
        this.readHeader();
    }

    private void readHeader() throws IOException {
        Object source = null;
        try {
            source = this.codec.makeSourceFromStream(new PositionalBufferedStream(new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path))));
            this.header = this.codec.readHeader(source);
        }
        catch (Exception e2) {
            throw new TribbleException.MalformedFeatureFile("Unable to parse header with error: " + e2.getMessage(), this.path, e2);
        }
        finally {
            if (source != null) {
                this.codec.close(source);
            }
        }
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    @Override
    public CloseableTribbleIterator<T> query(String chr, int start, int end) throws IOException {
        List<String> mp = this.getSequenceNames();
        if (mp == null) {
            throw new TribbleException.TabixReaderFailure("Unable to find sequence named " + chr + " in the tabix index. ", this.path);
        }
        if (!mp.contains(chr)) {
            return new AbstractFeatureReader.EmptyIterator();
        }
        TabixIteratorLineReader lineReader = new TabixIteratorLineReader(this.tabixReader.query(this.tabixReader.mChr2tid.get(chr), start - 1, end));
        return new FeatureIterator(lineReader, start - 1, end);
    }

    @Override
    public CloseableTribbleIterator<T> iterator() throws IOException {
        BlockCompressedInputStream is = new BlockCompressedInputStream(ParsingUtils.openInputStream(this.path));
        PositionalBufferedStream stream = new PositionalBufferedStream(is);
        LineReader reader = LineReaderUtil.fromBufferedStream(stream, LineReaderUtil.LineReaderOption.SYNCHRONOUS);
        return new FeatureIterator(reader, 0, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
    }

    class FeatureIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        private T currentRecord;
        private LineReader lineReader;
        private int start;
        private int end;

        public FeatureIterator(LineReader lineReader, int start, int end) throws IOException {
            this.lineReader = lineReader;
            this.start = start;
            this.end = end;
            this.readNextRecord();
        }

        protected void readNextRecord() throws IOException {
            String nextLine;
            this.currentRecord = null;
            while (this.currentRecord == null && (nextLine = this.lineReader.readLine()) != null) {
                try {
                    Object f2 = ((AsciiFeatureCodec)TabixFeatureReader.this.codec).decode(nextLine);
                    if (f2 == null) continue;
                    if (f2.getStart() > this.end) {
                        return;
                    }
                    if (f2.getEnd() <= this.start) continue;
                    this.currentRecord = f2;
                }
                catch (TribbleException e2) {
                    e2.setSource(TabixFeatureReader.this.path);
                    throw e2;
                }
                catch (NumberFormatException e3) {
                    String error = "Error parsing line: " + nextLine;
                    throw new TribbleException.MalformedFeatureFile(error, TabixFeatureReader.this.path, e3);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public T next() {
            T ret = this.currentRecord;
            try {
                this.readNextRecord();
            }
            catch (IOException e2) {
                throw new RuntimeException("Unable to read the next record, the last record was at " + ret.getChr() + ":" + ret.getStart() + "-" + ret.getEnd(), e2);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported in Iterators");
        }

        @Override
        public void close() {
            this.lineReader.close();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

