/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.Iterator;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TabixFeatureReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.TribbleIndexedFeatureReader;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.ParsingUtils;

public abstract class AbstractFeatureReader<T extends Feature, SOURCE>
implements FeatureReader<T> {
    String path;
    protected final FeatureCodec<T, SOURCE> codec;
    protected FeatureCodecHeader header;
    private static ComponentMethods methods = new ComponentMethods();

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureFile, FeatureCodec<FEATURE, SOURCE> codec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureFile, codec, true);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, FeatureCodec<FEATURE, SOURCE> codec, boolean requireIndex) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureResource, null, codec, requireIndex);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, String indexResource, FeatureCodec<FEATURE, SOURCE> codec, boolean requireIndex) throws TribbleException {
        try {
            if (methods.isTabix(featureResource, indexResource)) {
                if (!(codec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + codec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(featureResource, (AsciiFeatureCodec)codec);
            }
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(featureResource, codec, requireIndex);
        }
        catch (IOException e2) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", featureResource, e2);
        }
        catch (TribbleException e3) {
            e3.setSource(featureResource);
            throw e3;
        }
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, FeatureCodec<FEATURE, SOURCE> codec, Index index) throws TribbleException {
        try {
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(featureResource, codec, index);
        }
        catch (IOException e2) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", featureResource, e2);
        }
    }

    protected AbstractFeatureReader(String path, FeatureCodec<T, SOURCE> codec) {
        this.path = path;
        this.codec = codec;
    }

    public boolean hasIndex() {
        return false;
    }

    public static void setComponentMethods(ComponentMethods methods) {
        AbstractFeatureReader.methods = methods;
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    public static class ComponentMethods {
        public boolean isTabix(String resourcePath, String indexPath) throws IOException {
            if (indexPath == null) {
                indexPath = ParsingUtils.appendToPath(resourcePath, ".tbi");
            }
            return resourcePath.endsWith(".gz") && ParsingUtils.resourceExists(indexPath);
        }
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

