/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import com.google.common.primitives.Ints;
import java.io.IOException;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;

public class IGVSeekableBufferedStream
extends SeekableStream {
    private static Logger log = Logger.getLogger(IGVSeekableBufferedStream.class);
    public static final int DEFAULT_BUFFER_SIZE = 512000;
    private final int maxBufferSize;
    final SeekableStream wrappedStream;
    long position;
    long length;
    int markpos;
    int marklimit;
    byte[] buffer;
    long bufferStartPosition;
    int bufferSize;

    public IGVSeekableBufferedStream(SeekableStream stream, int bsize) {
        this.maxBufferSize = bsize;
        this.wrappedStream = stream;
        this.position = 0L;
        this.length = this.wrappedStream.length();
        this.buffer = new byte[this.maxBufferSize];
        this.bufferStartPosition = -1L;
        this.bufferSize = 0;
    }

    public IGVSeekableBufferedStream(SeekableStream stream) {
        this(stream, 512000);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long skip(long skipLength) throws IOException {
        long maxSkip = Long.MAX_VALUE;
        if (this.length >= 0L) {
            maxSkip = this.length - this.position - 1L;
        }
        long actualSkip = Math.min(maxSkip, skipLength);
        this.position += actualSkip;
        return actualSkip;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.position = this.markpos;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markpos = (int)this.position;
        this.marklimit = readlimit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public boolean eof() throws IOException {
        return this.length >= 0L && this.position >= this.length;
    }

    @Override
    public String getSource() {
        return this.wrappedStream.getSource();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    private boolean needFillBuffer(int len) {
        return this.bufferSize == 0 || this.position < this.bufferStartPosition || this.position + (long)len > this.bufferStartPosition + (long)this.bufferSize;
    }

    @Override
    public int read() throws IOException {
        if (this.needFillBuffer(1)) {
            this.fillBuffer();
        }
        int offset = (int)(this.position - this.bufferStartPosition);
        byte b2 = this.buffer[offset];
        ++this.position;
        return b2;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.length >= 0L && this.position >= this.length) {
            return -1;
        }
        if (len > this.maxBufferSize) {
            this.wrappedStream.seek(this.position);
            int nBytes = this.wrappedStream.read(b2, off, len);
            this.position += (long)nBytes;
            return nBytes;
        }
        if (this.needFillBuffer(len)) {
            this.fillBuffer();
        }
        int bufferOffset = (int)(this.position - this.bufferStartPosition);
        int bytesCopied = Math.min(len, this.bufferSize - bufferOffset);
        System.arraycopy(this.buffer, bufferOffset, b2, off, bytesCopied);
        this.position += (long)bytesCopied;
        return bytesCopied;
    }

    private void fillBuffer() throws IOException {
        int szOverlap;
        long longRem = this.maxBufferSize;
        if (this.length >= 0L) {
            longRem = Math.min((long)this.maxBufferSize, this.length - this.position);
        }
        int bytesRemaining = Ints.saturatedCast(longRem);
        int toSkip = 0;
        int tmpBufferSize = 0;
        long bufferEnd = this.bufferStartPosition + (long)this.bufferSize;
        long requiredEnd = this.position + (long)bytesRemaining;
        if (this.position < bufferEnd && requiredEnd > bufferEnd) {
            szOverlap = (int)(bufferEnd - this.position);
            System.arraycopy(this.buffer, this.bufferSize - szOverlap, this.buffer, 0, szOverlap);
            toSkip = szOverlap;
            tmpBufferSize += szOverlap;
            bytesRemaining -= szOverlap;
        } else if (this.position < this.bufferStartPosition && requiredEnd > this.bufferStartPosition && requiredEnd < bufferEnd) {
            szOverlap = (int)(this.position + (long)bytesRemaining - this.bufferStartPosition);
            System.arraycopy(this.buffer, 0, this.buffer, this.bufferSize - szOverlap, szOverlap);
            bytesRemaining -= szOverlap;
            tmpBufferSize += szOverlap;
        }
        if (bytesRemaining > 0) {
            int count;
            int curOffset = toSkip;
            this.wrappedStream.seek(this.position + (long)toSkip);
            while (bytesRemaining > 0 && (count = this.wrappedStream.read(this.buffer, curOffset, bytesRemaining)) >= 0) {
                curOffset += count;
                bytesRemaining -= count;
                tmpBufferSize += count;
            }
            this.bufferStartPosition = this.position;
            this.bufferSize = tmpBufferSize;
        }
    }
}

