/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class StringUtils {
    private static Map<String, String> internedStrings = new WeakHashMap<String, String>();

    public static String intern(String string) {
        if (!internedStrings.containsKey(string)) {
            internedStrings.put(string, string);
        }
        return internedStrings.get(string);
    }

    public static List<String> breakQuotedString(String string, char splitToken) {
        if (string == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        if (string.length() == 0) {
            return strings;
        }
        char[] characters = string.toCharArray();
        boolean isQuoted = false;
        StringBuffer buff = new StringBuffer(100);
        for (int i2 = 0; i2 < characters.length; ++i2) {
            char c2 = characters[i2];
            if (isQuoted) {
                if (c2 == '\"') {
                    isQuoted = false;
                }
                buff.append(c2);
                continue;
            }
            if (c2 == '\"') {
                isQuoted = true;
                buff.append(c2);
                continue;
            }
            if (c2 == splitToken) {
                strings.add(buff.toString().trim());
                buff.setLength(0);
                continue;
            }
            buff.append(c2);
        }
        if (buff.length() > 0) {
            strings.add(buff.toString().trim());
        }
        return strings;
    }

    public static String checkLength(String string, int maxLength) {
        if (string.length() <= maxLength) {
            return string;
        }
        int nDots = maxLength > 10 ? 3 : (maxLength > 5 ? 2 : 1);
        int m2 = Math.max(1, (maxLength - nDots) / 2);
        StringBuffer newString = new StringBuffer(maxLength);
        newString.append(string.substring(0, m2));
        for (int i2 = 0; i2 < nDots; ++i2) {
            newString.append('.');
        }
        newString.append(string.substring(string.length() - m2));
        return newString.toString();
    }

    public static short genoToShort(String genotype) {
        byte[] bytes = genotype.getBytes();
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    public static String readString(ByteBuffer byteBuffer) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int b2 = -1;
        while (true) {
            byte by = byteBuffer.get();
            b2 = by;
            if (by == 0) break;
            bytes.write(b2);
        }
        return new String(bytes.toByteArray());
    }

    public static String decodeURL(String s2) {
        if (s2 == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String encodeURL(String s2) {
        if (s2 == null) {
            return null;
        }
        try {
            s2 = URLEncoder.encode(s2, "UTF-8");
            s2 = s2.replace("+", "%20");
            return s2;
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static URL encodeURLQueryString(URL url) throws MalformedURLException {
        String[] parts = url.toExternalForm().split("\\?", 2);
        if (parts.length > 1 && !parts[1].contains("%")) {
            String queryPart = parts[1];
            String[] params = queryPart.split("&");
            Object[] encParms = new String[params.length];
            int ii = 0;
            for (String kv : params) {
                String[] kvs = kv.split("\\=", 2);
                String encString = StringUtils.encodeURL(kvs[0]);
                if (kvs.length == 2) {
                    encString = String.format("%s=%s", encString, StringUtils.encodeURL(kvs[1]));
                }
                encParms[ii++] = encString;
            }
            String encQuery = org.apache.commons.lang.StringUtils.join((Object[])encParms, (String)"&");
            String newPath = parts[0] + "?" + encQuery;
            url = new URL(newPath);
        }
        return url;
    }

    public static void copyTextToClipboard(String text) {
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public static String capWords(String text) {
        String res = "";
        boolean capNext = true;
        for (char c2 : text.toLowerCase().toCharArray()) {
            String s2 = Character.toString(c2);
            if (capNext) {
                s2 = s2.toUpperCase();
            }
            res = res + s2;
            capNext = " ".equals(s2);
        }
        return res;
    }

    public static int countChar(String string, char c2) {
        int cnt = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (c2 != string.charAt(i2)) continue;
            ++cnt;
        }
        return cnt;
    }
}

