/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class ByteConverter {
    public static float[] convertBytesToFloats(byte[] bytes) {
        try {
            int nFloats = bytes.length / 4;
            float[] floats = new float[nFloats];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            for (int i2 = 0; i2 < nFloats; ++i2) {
                if (dis.available() < 4) continue;
                floats[i2] = dis.readFloat();
            }
            dis.close();
            return floats;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static int[] convertBytesToInts(byte[] bytes) {
        try {
            int nInts = bytes.length / 4;
            int[] ints = new int[nInts];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            for (int i2 = 0; i2 < nInts; ++i2) {
                if (dis.available() < 4) continue;
                ints[i2] = dis.readInt();
            }
            dis.close();
            return ints;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static long[] convertBytesToLongs(byte[] bytes) {
        try {
            int nLongs = bytes.length / 8;
            long[] longs = new long[nLongs];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            for (int i2 = 0; i2 < nLongs; ++i2) {
                if (dis.available() < 8) continue;
                longs[i2] = dis.readLong();
            }
            dis.close();
            return longs;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static String[] convertBytesToStrings(byte[] bytes, int nChars) {
        try {
            int nStrings = bytes.length / (nChars * 2);
            String[] strings = new String[nStrings];
            byte[] stringBytes = new byte[nChars * 2];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            for (int i2 = 0; i2 < nStrings; ++i2) {
                if (dis.available() < nChars * 2) continue;
                dis.read(stringBytes);
                strings[i2] = new String(stringBytes, "UTF-16BE").trim();
            }
            return strings;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

