/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.event;

import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.charts.ScatterPlotUtils;
import org.broad.igv.feature.AbstractFeature;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.Feature;

public class GlobalKeyDispatcher
implements KeyEventDispatcher {
    private static Logger log = Logger.getLogger(GlobalKeyDispatcher.class);
    private final InputMap keyStrokes = new InputMap();
    private final ActionMap actions = new ActionMap();

    public GlobalKeyDispatcher() {
        this.init();
    }

    public InputMap getInputMap() {
        return this.keyStrokes;
    }

    public ActionMap getActionMap() {
        return this.actions;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Action action;
        if (event.getKeyCode() == 27) {
            IGV.getInstance().clearSelections();
            IGV.getInstance().repaint();
            return true;
        }
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(event);
        String actionKey = (String)this.keyStrokes.get(ks);
        if (event.getKeyCode() == 17 || event.getKeyCode() == 18) {
            boolean flag = !event.isControlDown() && !event.isAltDown() && !event.isMetaDown();
            ToolTipManager.sharedInstance().setEnabled(flag);
        }
        if (actionKey != null && (action = this.actions.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(event.getSource(), event.getID(), actionKey, event.getModifiers()));
            return true;
        }
        return false;
    }

    public void init() {
        KeyStroke nextKey = KeyStroke.getKeyStroke(70, 2, false);
        KeyStroke prevKey = KeyStroke.getKeyStroke(66, 2, false);
        KeyStroke toolsKey = KeyStroke.getKeyStroke(84, 8, false);
        KeyStroke regionKey = KeyStroke.getKeyStroke(82, 2, false);
        KeyStroke regionCenterKey = KeyStroke.getKeyStroke(82, 3, false);
        KeyStroke nextExonKey = KeyStroke.getKeyStroke(70, 3, false);
        KeyStroke prevExonKey = KeyStroke.getKeyStroke(66, 3, false);
        KeyStroke backKey1 = KeyStroke.getKeyStroke(93, 256, false);
        KeyStroke backKey2 = KeyStroke.getKeyStroke(37, 512, false);
        KeyStroke forwardKey1 = KeyStroke.getKeyStroke(91, 256, false);
        KeyStroke forwardKey2 = KeyStroke.getKeyStroke(39, 512, false);
        KeyStroke scatterplotKey = KeyStroke.getKeyStroke(80, 2, false);
        KeyStroke sortByLastKey = KeyStroke.getKeyStroke(83, 128, false);
        EnableWrappedAction toolAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().enableExtrasMenu();
            }
        });
        EnableWrappedAction statusWindowAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().openStatusWindow();
            }
        });
        EnableWrappedAction nextAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GlobalKeyDispatcher.this.nextFeature(true);
            }
        });
        EnableWrappedAction prevAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GlobalKeyDispatcher.this.nextFeature(false);
            }
        });
        EnableWrappedAction nextExonAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GlobalKeyDispatcher.this.nextExon(true);
            }
        });
        EnableWrappedAction prevExonAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GlobalKeyDispatcher.this.nextExon(false);
            }
        });
        EnableWrappedAction regionAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (FrameManager.isGeneListMode()) {
                    return;
                }
                Range currentRange = FrameManager.getDefaultFrame().getCurrentRange();
                RegionOfInterest regionOfInterest = new RegionOfInterest(currentRange.getChr(), currentRange.getStart(), currentRange.getEnd(), null);
                IGV.getInstance().addRegionOfInterest(regionOfInterest);
            }
        });
        EnableWrappedAction regionCenterAction = new EnableWrappedAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (FrameManager.isGeneListMode()) {
                    return;
                }
                int center = (int)FrameManager.getDefaultFrame().getCenter();
                RegionOfInterest regionOfInterest = new RegionOfInterest(FrameManager.getDefaultFrame().getChrName(), center, center + 1, null);
                IGV.getInstance().addRegionOfInterest(regionOfInterest);
            }
        });
        AbstractAction backAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().getSession().getHistory().back();
            }
        };
        AbstractAction forwardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                IGV.getInstance().getSession().getHistory().forward();
            }
        };
        AbstractAction scatterplotAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (ScatterPlotUtils.hasPlottableTracks()) {
                    ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
                    String chr = defaultFrame.getChrName();
                    int start = (int)defaultFrame.getOrigin();
                    int end = (int)defaultFrame.getEnd();
                    int zoom = defaultFrame.getZoom();
                    ScatterPlotUtils.openPlot(chr, start, end, zoom);
                }
            }
        };
        AbstractAction sorAlignmentTracksAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String sortOptionString = PreferenceManager.getInstance().get("SAM>SORT_OPTION");
                if (sortOptionString != null) {
                    try {
                        AlignmentTrack.SortOption option = AlignmentTrack.SortOption.valueOf(sortOptionString);
                        String lastSortTag = PreferenceManager.getInstance().get("SAM.SORT_BY_TAG");
                        IGV.getInstance().sortAlignmentTracks(option, lastSortTag);
                        IGV.getInstance().repaintDataPanels();
                    }
                    catch (IllegalArgumentException e1) {
                        log.error("Unrecognized sort option: " + sortOptionString);
                    }
                }
            }
        };
        this.getInputMap().put(nextKey, "nextFeature");
        this.getActionMap().put("nextFeature", nextAction);
        this.getInputMap().put(prevKey, "prevFeature");
        this.getActionMap().put("prevFeature", prevAction);
        this.getInputMap().put(nextExonKey, "nextExon");
        this.getActionMap().put("nextExon", nextExonAction);
        this.getInputMap().put(prevExonKey, "prevExon");
        this.getActionMap().put("prevExon", prevExonAction);
        this.getInputMap().put(toolsKey, "tools");
        this.getActionMap().put("tools", toolAction);
        this.getInputMap().put(regionKey, "region");
        this.getActionMap().put("region", regionAction);
        this.getInputMap().put(regionCenterKey, "regionCenter");
        this.getActionMap().put("regionCenter", regionCenterAction);
        this.getInputMap().put(sortByLastKey, "sortByLast");
        this.getActionMap().put("sortByLast", sorAlignmentTracksAction);
        this.getInputMap().put(scatterplotKey, "scatterPlot");
        this.getActionMap().put("scatterPlot", scatterplotAction);
        this.getInputMap().put(backKey1, "back");
        this.getInputMap().put(backKey2, "back");
        this.getActionMap().put("back", backAction);
        this.getInputMap().put(forwardKey1, "forward");
        this.getInputMap().put(forwardKey2, "forward");
        this.getActionMap().put("forward", forwardAction);
    }

    private void nextExon(boolean forward) {
        if (FrameManager.isGeneListMode()) {
            return;
        }
        ReferenceFrame vc = FrameManager.getDefaultFrame();
        Collection<Track> tracks = IGV.getInstance().getSelectedTracks();
        if (tracks.size() == 1) {
            Track t2 = tracks.iterator().next();
            if (!(t2 instanceof FeatureTrack)) {
                return;
            }
            AbstractFeature e2 = null;
            if (t2 instanceof FeatureTrack) {
                Feature feature;
                int center = (int)vc.getCenter();
                FeatureTrack ft = (FeatureTrack)t2;
                if (ft.getDisplayMode() == Track.DisplayMode.COLLAPSED || ft.getSelectedFeatureRowIndex() == -1) {
                    MessageUtils.showMessage("Exon navigation is only allowed when track is expanded and a single feature row is selected.");
                    return;
                }
                List<Feature> featureList = ft.getFeaturesAtPositionInFeatureRow(center, ft.getSelectedFeatureRowIndex(), vc);
                Feature feature2 = feature = featureList != null && featureList.size() > 0 ? featureList.get(0) : null;
                if (feature == null) {
                    return;
                }
                if (feature instanceof BasicFeature) {
                    BasicFeature bf = (BasicFeature)feature;
                    List<Exon> exons = bf.getExons();
                    if (exons == null || exons.isEmpty()) {
                        MessageUtils.showMessage("At least one centered feature does not have exon structure");
                        return;
                    }
                    if (forward) {
                        for (Exon exon : bf.getExons()) {
                            if (!((double)exon.getStart() > vc.getCenter() + 1.0)) continue;
                            e2 = exon;
                            break;
                        }
                    } else {
                        for (int i2 = exons.size() - 1; i2 >= 0; --i2) {
                            Exon exon = exons.get(i2);
                            if (!((double)exon.getEnd() < vc.getCenter())) continue;
                            e2 = exon;
                            break;
                        }
                    }
                }
                if (e2 != null) {
                    vc.centerOnLocation(forward ? (double)e2.getStart() : (double)e2.getEnd());
                    int i3 = 3;
                }
            }
        } else {
            MessageUtils.showMessage("To use track panning you must first select a single feature track.");
        }
    }

    private void nextFeature(boolean forward) {
        block10: {
            if (FrameManager.isGeneListMode()) {
                return;
            }
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            Collection<Track> tracks = IGV.getInstance().getSelectedTracks();
            if (tracks.size() == 1) {
                try {
                    Track t2 = tracks.iterator().next();
                    if (!(t2 instanceof FeatureTrack) && !(t2 instanceof VariantTrack)) {
                        return;
                    }
                    Feature f2 = null;
                    if (t2 instanceof FeatureTrack) {
                        f2 = ((FeatureTrack)t2).nextFeature(frame.getChrName(), frame.getCenter(), forward, frame);
                    } else if (t2 instanceof VariantTrack) {
                        f2 = ((VariantTrack)t2).nextFeature(frame.getChrName(), frame.getCenter(), forward, frame);
                    }
                    if (f2 == null) break block10;
                    String chr = GenomeManager.getInstance().getCurrentGenome().getChromosomeAlias(f2.getChr());
                    double newCenter = f2.getStart();
                    if (!chr.equals(frame.getChrName())) {
                        double range = frame.getEnd() - frame.getOrigin();
                        int newOrigin = (int)Math.max(newCenter - range / 2.0, 0.0);
                        int newEnd = (int)((double)newOrigin + range);
                        frame.jumpTo(chr, newOrigin, newEnd);
                        break block10;
                    }
                    frame.centerOnLocation(newCenter);
                }
                catch (IOException e2) {
                    MessageUtils.showErrorMessage("Error encountered reading features: " + e2.getMessage(), e2);
                }
            } else {
                MessageUtils.showMessage("To use track panning you must first select a single feature track.");
            }
        }
    }

    private class EnableWrappedAction
    extends AbstractAction {
        private Action action;

        private EnableWrappedAction(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.setEnabled(false);
            this.action.actionPerformed(e2);
            this.setEnabled(true);
        }
    }
}

