/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.FileUtils;

public class ShutdownThread
extends Thread {
    private static Logger log = Logger.getLogger(ShutdownThread.class);

    public static void runS() {
        if (Globals.IS_MAC) {
            FileUtils.cleanupJnlpFiles();
        }
        DBManager.shutdown();
        CommandListener.halt();
        ShutdownThread.cleanupBamIndexCache();
        if (IGV.hasInstance()) {
            IGV.getInstance().saveStateForExit();
            for (Track t2 : IGV.getInstance().getAllTracks()) {
                t2.dispose();
            }
        }
    }

    @Override
    public void run() {
        ShutdownThread.runS();
    }

    private static void cleanupBamIndexCache() {
        File dir = DirectoryManager.getCacheDirectory();
        for (File f2 : dir.listFiles()) {
            f2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            log.info("A blank Region of Interest export file was supplied!");
            return;
        }
        try {
            Collection<RegionOfInterest> regions = IGV.getInstance().getSession().getAllRegionsOfInterest();
            if (regions == null || regions.isEmpty()) {
                return;
            }
            roiFile.createNewFile();
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(roiFile);
                for (RegionOfInterest regionOfInterest : regions) {
                    Integer regionStart = regionOfInterest.getStart();
                    if (regionStart == null) continue;
                    Integer regionEnd = regionOfInterest.getEnd();
                    if (regionEnd == null) {
                        regionEnd = regionStart;
                    }
                    writer.print(regionOfInterest.getChr());
                    writer.print("\t");
                    writer.print(regionStart);
                    writer.print("\t");
                    writer.print(regionEnd);
                    if (regionOfInterest.getDescription() != null) {
                        writer.print("\t");
                        writer.println(regionOfInterest.getDescription());
                        continue;
                    }
                    writer.println();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e2) {
            log.error("Failed to write Region of Interest export file!", e2);
        }
    }
}

