/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.dialog.ButtonPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.broad.igv.DirectoryManager;
import org.broad.igv.PreferenceManager;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.data.expression.ProbeToLocusMap;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.Main;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.legend.ColorMapEditor;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.FontChooser;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CollUtils;

public class PreferencesEditor
extends JDialog {
    private boolean canceled = false;
    Map<String, String> updatedPreferenceMap = Collections.synchronizedMap(new HashMap<String, String>(){

        @Override
        public String put(String k2, String v2) {
            String oldValue = PreferencesEditor.this.prefMgr.get(k2);
            if (v2 == null && oldValue != null || !v2.equals(oldValue)) {
                return super.put(k2, v2);
            }
            return v2;
        }
    });
    PreferenceManager prefMgr = PreferenceManager.getInstance();
    boolean updateOverlays = false;
    boolean inputValidated = true;
    private static int lastSelectedIndex = 0;
    boolean proxySettingsChanged = false;
    boolean tooltipSettingsChanged = false;
    private File newIGVDirectory;
    static String overlayText = "<html>These options control the treatment of mutation tracks.  Mutation data may optionally<br>be overlayed on other tracks that have a matching attribute value from the sample info <br>file. This is normally an attribute that identifies a sample or patient. The attribute key <br>is specified in thetext field below.";
    private JTabbedPane tabbedPane;
    private JPanel generalPanel;
    private JPanel jPanel10;
    private JLabel missingDataExplanation;
    private JCheckBox showDefaultTrackAttributesCB;
    private JCheckBox combinePanelsCB;
    private JCheckBox showAttributesDisplayCheckBox;
    private JCheckBox searchZoomCB;
    private JLabel zoomToFeatureExplanation;
    private JLabel label4;
    private JTextField geneListFlankingField;
    private JLabel zoomToFeatureExplanation2;
    private JLabel label5;
    private JLabel label6;
    private JTextField seqResolutionThreshold;
    private JLabel label10;
    private JTextField defaultFontField;
    private JButton fontChangeButton;
    private JCheckBox showRegionBoundariesCB;
    private JLabel label7;
    private JPanel backgroundColorPanel;
    private JButton resetBackgroundButton;
    private JCheckBox showMissingDataCB;
    private JLabel label32;
    private JPanel tracksPanel;
    private JPanel jPanel6;
    private JLabel jLabel5;
    private JTextField defaultChartTrackHeightField;
    private JLabel trackNameAttributeLabel;
    private JTextField trackNameAttributeField;
    private JLabel missingDataExplanation2;
    private JLabel jLabel8;
    private JTextField defaultTrackHeightField;
    private JLabel missingDataExplanation4;
    private JLabel missingDataExplanation5;
    private JLabel missingDataExplanation3;
    private JCheckBox expandCB;
    private JCheckBox normalizeCoverageCB;
    private JLabel missingDataExplanation8;
    private JCheckBox expandIconCB;
    private JPanel overlaysPanel;
    private JPanel jPanel5;
    private JLabel jLabel3;
    private JTextField overlayAttributeTextField;
    private JCheckBox overlayTrackCB;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JCheckBox colorCodeMutationsCB;
    private JButton chooseMutationColorsButton;
    private JLabel label11;
    private JCheckBox showOrphanedMutationsCB;
    private JLabel label12;
    private JPanel chartPanel;
    private JPanel jPanel4;
    private JCheckBox topBorderCB;
    private JLabel label1;
    private JCheckBox chartDrawTrackNameCB;
    private JCheckBox bottomBorderCB;
    private JLabel jLabel7;
    private JCheckBox colorBordersCB;
    private JCheckBox labelYAxisCB;
    private JCheckBox autoscaleCB;
    private JLabel jLabel9;
    private JCheckBox showDatarangeCB;
    private JPanel panel1;
    private JLabel label13;
    private JCheckBox showAllHeatmapFeauresCB;
    private JLabel label14;
    private JPanel alignmentPanel;
    private JPanel jPanel11;
    private JLabel jLabel11;
    private JTextField samMaxWindowSizeField;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JPanel panel4;
    private JCheckBox downsampleReadsCB;
    private JLabel label23;
    private JTextField samDownsampleCountField;
    private JLabel jLabel13;
    private JTextField samSamplingWindowField;
    private JPanel jPanel12;
    private JTextField snpThresholdField;
    private JLabel jLabel26;
    private JTextField samMinBaseQualityField;
    private JCheckBox samShadeMismatchedBaseCB;
    private JTextField samMaxBaseQualityField;
    private JCheckBox showCovTrackCB;
    private JCheckBox samFilterDuplicatesCB;
    private JCheckBox filterCB;
    private JTextField filterURL;
    private JCheckBox samFlagUnmappedPairCB;
    private JCheckBox filterFailedReadsCB;
    private JLabel label2;
    private JCheckBox showSoftClippedCB;
    private JCheckBox showCenterLineCB;
    private JCheckBox zeroQualityAlignmentCB;
    private JLabel jLabel15;
    private JTextField mappingQualityThresholdField;
    private JCheckBox filterSecondaryAlignmentsCB;
    private JCheckBox samFlagInsertionsCB;
    private JTextField filterURL2;
    private JTextField samFlagInsertionsThresholdField;
    private JLabel label31;
    private JPanel panel2;
    private JCheckBox isizeComputeCB;
    private JLabel jLabel17;
    private JTextField insertSizeMinThresholdField;
    private JLabel jLabel20;
    private JTextField insertSizeThresholdField;
    private JLabel jLabel30;
    private JLabel jLabel18;
    private JTextField insertSizeMinPercentileField;
    private JTextField insertSizeMaxPercentileField;
    private JLabel label8;
    private JLabel label9;
    private JPanel panel3;
    private JCheckBox showJunctionTrackCB;
    private JCheckBox showJunctionFlankingRegionsCB;
    private JTextField junctionFlankingTextField;
    private JLabel label15;
    private JLabel label16;
    private JTextField junctionCoverageTextField;
    private JPanel expressionPane;
    private JPanel jPanel8;
    private JRadioButton expMapToGeneCB;
    private JLabel jLabel24;
    private JRadioButton expMapToLociCB;
    private JLabel jLabel21;
    private JTextField probeMappingFileTextField;
    private JLabel label22;
    private JButton probeMappingBrowseButton;
    private JCheckBox useProbeMappingCB;
    private JPanel proxyPanel;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JTextField proxyUsernameField;
    private JLabel jLabel28;
    private JCheckBox authenticateProxyCB;
    private JLabel jLabel29;
    private JPasswordField proxyPasswordField;
    private JPanel jPanel17;
    private JTextField proxyHostField;
    private JTextField proxyPortField;
    private JLabel jLabel27;
    private JLabel jLabel23;
    private JCheckBox useProxyCB;
    private JComboBox proxyTypeCB;
    private JLabel label27;
    private JLabel label3;
    private JButton clearProxySettingsButton;
    private JPanel dbPanel;
    private JLabel label17;
    private JLabel label18;
    private JLabel label19;
    private JTextField dbHostField;
    private JTextField dbPortField;
    private JTextField dbNameField;
    private JLabel label20;
    private JPanel advancedPanel;
    private JButton clearGenomeCacheButton;
    private JCheckBox enablePortCB;
    private JTextField portField;
    private JLabel jLabel22;
    private JCheckBox genomeUpdateCB;
    private JLabel jLabel6;
    private JTextField dataServerURLTextField;
    private JLabel jLabel1;
    private JTextField genomeServerURLTextField;
    private JCheckBox editServerPropertiesCB;
    private JButton jButton1;
    private JButton igvDirectoryButton;
    private JLabel igvDirectoryField;
    private JLabel label21;
    private JPanel tooltipOptionsPanel;
    private JLabel label24;
    private JLabel label25;
    private JLabel label26;
    private JTextField toolTipInitialDelayField;
    private JTextField tooltipReshowDelayField;
    private JTextField tooltipDismissDelayField;
    private JCheckBox antialiasingCB;
    private JPanel ionTorrentPanel;
    private JPanel panel6;
    private JCheckBox hideFirstHP;
    private JTextField binSizeText;
    private JLabel label28;
    private JLabel label29;
    private JRadioButton radioLine;
    private JRadioButton radioArea;
    private JRadioButton radioBar;
    private JRadioButton radioStacked;
    private JPanel panel7;
    private JLabel label30;
    private JTextField textServer;
    private ButtonPanel okCancelButtonPanel;
    JButton okButton;
    private JButton cancelButton;
    static List<String> SAM_PREFERENCE_KEYS = Arrays.asList("SAM.QUALITY_THRESHOLD", "SAM.FILTER_ALIGNMENTS", "SAM.FILTER_URL", "SAM.MAX_VISIBLE_RANGE", "SAM.SHOW_DUPLICATES", "SAM.SHOW_SOFT_CLIPPED", "SAM.MAX_LEVELS", "SAM.SAMPLING_WINDOW", "SAM.FILTER_FAILED_READS", "SAM.DOWNSAMPLE_READS");
    static List<String> SPLICE_JUNCTION_KEYS = Arrays.asList("SAM.SHOW_JUNCTION_TRACK", "SAM.JUNCTION_MIN_FLANKING_WIDTH", "SAM.JUNCTION_MIN_COVERAGE");

    private void backgroundColorPanelMouseClicked(MouseEvent e2) {
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        Color backgroundColor = UIUtilities.showColorChooserDialog("Choose background color", prefMgr.getAsColor("BACKGROUND_COLOR"));
        if (backgroundColor != null) {
            prefMgr.put("BACKGROUND_COLOR", ColorUtilities.colorToString(backgroundColor));
            IGV.getInstance().getMainPanel().setBackground(backgroundColor);
            this.backgroundColorPanel.setBackground(backgroundColor);
        }
    }

    private void extractBinSize() {
        String sbin = this.binSizeText.getText();
        if (sbin != null) {
            sbin = sbin.trim();
            try {
                Integer.parseInt(sbin);
                this.updatedPreferenceMap.put("IONTORRENT.FLOWDIST_BINSIZE", sbin);
            }
            catch (NumberFormatException numberFormatException) {
                this.inputValidated = false;
                MessageUtils.showMessage("Bin size must be an integer.");
            }
        }
    }

    private void resetBackgroundButtonActionPerformed(ActionEvent e2) {
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        prefMgr.remove("BACKGROUND_COLOR");
        Color backgroundColor = prefMgr.getAsColor("BACKGROUND_COLOR");
        if (backgroundColor != null) {
            prefMgr.put("BACKGROUND_COLOR", ColorUtilities.colorToString(backgroundColor));
            IGV.getInstance().getMainPanel().setBackground(backgroundColor);
            this.backgroundColorPanel.setBackground(backgroundColor);
        }
    }

    private void binSizeTextActionPerformed(ActionEvent e2) {
        this.extractBinSize();
    }

    private void hideFirstHPActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("IONTORRENT.FLOWDIST_HIDE_FIRST_HP", String.valueOf(this.hideFirstHP.isSelected()));
    }

    private void radioButton1ActionPerformed(ActionEvent e2) {
        if (this.radioLine.isSelected()) {
            this.updatedPreferenceMap.put("IONTORRENT.FLOWDIST_CHARTTYPE", "LINE");
        }
    }

    private void radioLineActionPerformed(ActionEvent e2) {
        if (this.radioLine.isSelected()) {
            this.updatedPreferenceMap.put("IONTORRENT.FLOWDIST_CHARTTYPE", "LINE");
        }
    }

    private void radioAreaActionPerformed(ActionEvent e2) {
        if (this.radioArea.isSelected()) {
            this.updatedPreferenceMap.put("IONTORRENT.FLOWDIST_CHARTTYPE", "AREA");
        }
    }

    private void radioBarActionPerformed(ActionEvent e2) {
        if (this.radioBar.isSelected()) {
            this.updatedPreferenceMap.put("IONTORRENT.FLOWDIST_CHARTTYPE", "BAR");
        }
    }

    private void radioStackedActionPerformed(ActionEvent e2) {
        if (this.radioStacked.isSelected()) {
            this.updatedPreferenceMap.put("IONTORRENT.FLOWDIST_CHARTTYPE", "STACKED");
        }
    }

    private void textServerActionPerformed(ActionEvent e2) {
        String server = this.textServer.getText();
        if (server != null) {
            server = server.trim();
            this.updatedPreferenceMap.put("IONTORRENT.SERVER", server);
        }
    }

    private void binSizeTextFocusLost(FocusEvent e2) {
        this.extractBinSize();
    }

    private void filterSecondaryAlignmentsCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SAM.FILTER_SECONDARY_ALIGNMENTS", String.valueOf(this.filterSecondaryAlignmentsCB.isSelected()));
    }

    private void antialiasingCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("ENABLE_ANTIALIASING", String.valueOf(this.antialiasingCB.isSelected()));
    }

    private void showMissingDataCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("IGV.track.show.missing.data", String.valueOf(this.showMissingDataCB.isSelected()));
    }

    public PreferencesEditor(Frame parent, boolean modal) {
        super(parent, modal);
        int idx;
        this.initComponents();
        this.initValues();
        this.tabbedPane.setSelectedIndex(lastSelectedIndex);
        if (!this.prefMgr.getAsBoolean("DB_ENABLED") && (idx = this.tabbedPane.indexOfTab("Database")) > 0) {
            this.tabbedPane.remove(idx);
        }
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        Rectangle bounds;
        this.tabbedPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.jPanel10 = new JPanel();
        this.missingDataExplanation = new JLabel();
        this.showDefaultTrackAttributesCB = new JCheckBox();
        this.combinePanelsCB = new JCheckBox();
        this.showAttributesDisplayCheckBox = new JCheckBox();
        this.searchZoomCB = new JCheckBox();
        this.zoomToFeatureExplanation = new JLabel();
        this.label4 = new JLabel();
        this.geneListFlankingField = new JTextField();
        this.zoomToFeatureExplanation2 = new JLabel();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.seqResolutionThreshold = new JTextField();
        this.label10 = new JLabel();
        this.defaultFontField = new JTextField();
        this.fontChangeButton = new JButton();
        this.showRegionBoundariesCB = new JCheckBox();
        this.label7 = new JLabel();
        this.backgroundColorPanel = new JPanel();
        this.resetBackgroundButton = new JButton();
        this.showMissingDataCB = new JCheckBox();
        this.label32 = new JLabel();
        this.tracksPanel = new JPanel();
        this.jPanel6 = new JPanel();
        this.jLabel5 = new JLabel();
        this.defaultChartTrackHeightField = new JTextField();
        this.trackNameAttributeLabel = new JLabel();
        this.trackNameAttributeField = new JTextField();
        this.missingDataExplanation2 = new JLabel();
        this.jLabel8 = new JLabel();
        this.defaultTrackHeightField = new JTextField();
        this.missingDataExplanation4 = new JLabel();
        this.missingDataExplanation5 = new JLabel();
        this.missingDataExplanation3 = new JLabel();
        this.expandCB = new JCheckBox();
        this.normalizeCoverageCB = new JCheckBox();
        this.missingDataExplanation8 = new JLabel();
        this.expandIconCB = new JCheckBox();
        this.overlaysPanel = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.overlayAttributeTextField = new JTextField();
        this.overlayTrackCB = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.colorCodeMutationsCB = new JCheckBox();
        this.chooseMutationColorsButton = new JButton();
        this.label11 = new JLabel();
        this.showOrphanedMutationsCB = new JCheckBox();
        this.label12 = new JLabel();
        this.chartPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.topBorderCB = new JCheckBox();
        this.label1 = new JLabel();
        this.chartDrawTrackNameCB = new JCheckBox();
        this.bottomBorderCB = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.colorBordersCB = new JCheckBox();
        this.labelYAxisCB = new JCheckBox();
        this.autoscaleCB = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.showDatarangeCB = new JCheckBox();
        this.panel1 = new JPanel();
        this.label13 = new JLabel();
        this.showAllHeatmapFeauresCB = new JCheckBox();
        this.label14 = new JLabel();
        this.alignmentPanel = new JPanel();
        this.jPanel11 = new JPanel();
        this.jLabel11 = new JLabel();
        this.samMaxWindowSizeField = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel16 = new JLabel();
        this.panel4 = new JPanel();
        this.downsampleReadsCB = new JCheckBox();
        this.label23 = new JLabel();
        this.samDownsampleCountField = new JTextField();
        this.jLabel13 = new JLabel();
        this.samSamplingWindowField = new JTextField();
        this.jPanel12 = new JPanel();
        this.snpThresholdField = new JTextField();
        this.jLabel26 = new JLabel();
        this.samMinBaseQualityField = new JTextField();
        this.samShadeMismatchedBaseCB = new JCheckBox();
        this.samMaxBaseQualityField = new JTextField();
        this.showCovTrackCB = new JCheckBox();
        this.samFilterDuplicatesCB = new JCheckBox();
        this.filterCB = new JCheckBox();
        this.filterURL = new JTextField();
        this.samFlagUnmappedPairCB = new JCheckBox();
        this.filterFailedReadsCB = new JCheckBox();
        this.label2 = new JLabel();
        this.showSoftClippedCB = new JCheckBox();
        this.showCenterLineCB = new JCheckBox();
        this.zeroQualityAlignmentCB = new JCheckBox();
        this.jLabel15 = new JLabel();
        this.mappingQualityThresholdField = new JTextField();
        this.filterSecondaryAlignmentsCB = new JCheckBox();
        this.samFlagInsertionsCB = new JCheckBox();
        this.filterURL2 = new JTextField();
        this.samFlagInsertionsThresholdField = new JTextField();
        this.label31 = new JLabel();
        this.panel2 = new JPanel();
        this.isizeComputeCB = new JCheckBox();
        this.jLabel17 = new JLabel();
        this.insertSizeMinThresholdField = new JTextField();
        this.jLabel20 = new JLabel();
        this.insertSizeThresholdField = new JTextField();
        this.jLabel30 = new JLabel();
        this.jLabel18 = new JLabel();
        this.insertSizeMinPercentileField = new JTextField();
        this.insertSizeMaxPercentileField = new JTextField();
        this.label8 = new JLabel();
        this.label9 = new JLabel();
        this.panel3 = new JPanel();
        this.showJunctionTrackCB = new JCheckBox();
        this.showJunctionFlankingRegionsCB = new JCheckBox();
        this.junctionFlankingTextField = new JTextField();
        this.label15 = new JLabel();
        this.label16 = new JLabel();
        this.junctionCoverageTextField = new JTextField();
        this.expressionPane = new JPanel();
        this.jPanel8 = new JPanel();
        this.expMapToGeneCB = new JRadioButton();
        this.jLabel24 = new JLabel();
        this.expMapToLociCB = new JRadioButton();
        this.jLabel21 = new JLabel();
        this.probeMappingFileTextField = new JTextField();
        this.label22 = new JLabel();
        this.probeMappingBrowseButton = new JButton();
        this.useProbeMappingCB = new JCheckBox();
        this.proxyPanel = new JPanel();
        this.jPanel15 = new JPanel();
        this.jPanel16 = new JPanel();
        this.proxyUsernameField = new JTextField();
        this.jLabel28 = new JLabel();
        this.authenticateProxyCB = new JCheckBox();
        this.jLabel29 = new JLabel();
        this.proxyPasswordField = new JPasswordField();
        this.jPanel17 = new JPanel();
        this.proxyHostField = new JTextField();
        this.proxyPortField = new JTextField();
        this.jLabel27 = new JLabel();
        this.jLabel23 = new JLabel();
        this.useProxyCB = new JCheckBox();
        this.proxyTypeCB = new JComboBox();
        this.label27 = new JLabel();
        this.label3 = new JLabel();
        this.clearProxySettingsButton = new JButton();
        this.dbPanel = new JPanel();
        this.label17 = new JLabel();
        this.label18 = new JLabel();
        this.label19 = new JLabel();
        this.dbHostField = new JTextField();
        this.dbPortField = new JTextField();
        this.dbNameField = new JTextField();
        this.label20 = new JLabel();
        this.advancedPanel = new JPanel();
        this.clearGenomeCacheButton = new JButton();
        this.enablePortCB = new JCheckBox();
        this.portField = new JTextField();
        this.jLabel22 = new JLabel();
        this.genomeUpdateCB = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.dataServerURLTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.genomeServerURLTextField = new JTextField();
        this.editServerPropertiesCB = new JCheckBox();
        this.jButton1 = new JButton();
        this.igvDirectoryButton = new JButton();
        this.igvDirectoryField = new JLabel();
        this.label21 = new JLabel();
        this.tooltipOptionsPanel = new JPanel();
        this.label24 = new JLabel();
        this.label25 = new JLabel();
        this.label26 = new JLabel();
        this.toolTipInitialDelayField = new JTextField();
        this.tooltipReshowDelayField = new JTextField();
        this.tooltipDismissDelayField = new JTextField();
        this.antialiasingCB = new JCheckBox();
        this.ionTorrentPanel = new JPanel();
        this.panel6 = new JPanel();
        this.hideFirstHP = new JCheckBox();
        this.binSizeText = new JTextField();
        this.label28 = new JLabel();
        this.label29 = new JLabel();
        this.radioLine = new JRadioButton();
        this.radioArea = new JRadioButton();
        this.radioBar = new JRadioButton();
        this.radioStacked = new JRadioButton();
        this.panel7 = new JPanel();
        this.label30 = new JLabel();
        this.textServer = new JTextField();
        this.okCancelButtonPanel = new ButtonPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.generalPanel.setLayout(new BorderLayout());
        this.jPanel10.setBorder(new BevelBorder(0));
        this.jPanel10.setLayout(null);
        this.missingDataExplanation.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation.setText("Display default track attributes (NAME, DATA_TYPE, and DATA_FILE) in the attribute panel.");
        this.jPanel10.add(this.missingDataExplanation);
        this.missingDataExplanation.setBounds(55, 190, 565, this.missingDataExplanation.getPreferredSize().height);
        this.showDefaultTrackAttributesCB.setText("Show default track attributes");
        this.showDefaultTrackAttributesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showDefaultTrackAttributesCBActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.showDefaultTrackAttributesCB);
        this.showDefaultTrackAttributesCB.setBounds(new Rectangle(new Point(10, 160), this.showDefaultTrackAttributesCB.getPreferredSize()));
        this.combinePanelsCB.setText("Display all tracks in a single panel");
        this.combinePanelsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.combinePanelsCBActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.combinePanelsCB);
        this.combinePanelsCB.setBounds(new Rectangle(new Point(10, 90), this.combinePanelsCB.getPreferredSize()));
        this.showAttributesDisplayCheckBox.setText("Show attribute panel");
        this.showAttributesDisplayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showAttributesDisplayCheckBoxActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.showAttributesDisplayCheckBox);
        this.showAttributesDisplayCheckBox.setBounds(new Rectangle(new Point(10, 125), this.showAttributesDisplayCheckBox.getPreferredSize()));
        this.searchZoomCB.setText("Zoom to features");
        this.searchZoomCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.searchZoomCBActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.searchZoomCB);
        this.searchZoomCB.setBounds(new Rectangle(new Point(10, 260), this.searchZoomCB.getPreferredSize()));
        this.zoomToFeatureExplanation.setFont(new Font("Lucida Grande", 2, 12));
        this.zoomToFeatureExplanation.setText("<html>This option controls the behavior of feature searchs.  If true, the zoom level is changed as required to size the view to the feature size.  If false the zoom level is unchanged.");
        this.zoomToFeatureExplanation.setVerticalAlignment(1);
        this.jPanel10.add(this.zoomToFeatureExplanation);
        this.zoomToFeatureExplanation.setBounds(50, 285, 644, 50);
        this.label4.setText("Feature flanking region (bp or %): ");
        this.jPanel10.add(this.label4);
        this.label4.setBounds(new Rectangle(new Point(15, 420), this.label4.getPreferredSize()));
        this.geneListFlankingField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.geneListFlankingFieldFocusLost(e2);
            }
        });
        this.geneListFlankingField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.geneListFlankingFieldActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.geneListFlankingField);
        this.geneListFlankingField.setBounds(235, 415, 255, this.geneListFlankingField.getPreferredSize().height);
        this.zoomToFeatureExplanation2.setFont(new Font("Lucida Grande", 2, 12));
        this.zoomToFeatureExplanation2.setText("<html><i>Added before and after feature locus when zooming to a feature.  Also used when defining panel extents in gene/loci list views.<b> A negative number is interpreted as a percentage.</b>");
        this.zoomToFeatureExplanation2.setVerticalAlignment(1);
        this.jPanel10.add(this.zoomToFeatureExplanation2);
        this.zoomToFeatureExplanation2.setBounds(45, 450, 637, 50);
        this.label5.setText("<html><i>Resolution in base-pairs per pixel at which sequence track becomes visible. ");
        this.label5.setFont(new Font("Lucida Grande", 0, 12));
        this.jPanel10.add(this.label5);
        this.label5.setBounds(new Rectangle(new Point(50, 375), this.label5.getPreferredSize()));
        this.label6.setText("Sequence resolution threshold (bp/pixel):");
        this.jPanel10.add(this.label6);
        this.label6.setBounds(new Rectangle(new Point(15, 345), this.label6.getPreferredSize()));
        this.seqResolutionThreshold.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.seqResolutionThresholdFocusLost(e2);
            }
        });
        this.seqResolutionThreshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.seqResolutionThresholdActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.seqResolutionThreshold);
        this.seqResolutionThreshold.setBounds(315, 340, 105, this.seqResolutionThreshold.getPreferredSize().height);
        this.label10.setText("Default font: ");
        this.label10.setLabelFor(this.defaultFontField);
        this.jPanel10.add(this.label10);
        this.label10.setBounds(new Rectangle(new Point(15, 585), this.label10.getPreferredSize()));
        this.defaultFontField.setEditable(false);
        this.jPanel10.add(this.defaultFontField);
        this.defaultFontField.setBounds(105, 580, 238, this.defaultFontField.getPreferredSize().height);
        this.fontChangeButton.setText("Change...");
        this.fontChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.fontChangeButtonActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.fontChangeButton);
        this.fontChangeButton.setBounds(360, 580, 97, this.fontChangeButton.getPreferredSize().height);
        this.showRegionBoundariesCB.setText("Show region boundaries");
        this.showRegionBoundariesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showRegionBoundariesCBActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.showRegionBoundariesCB);
        this.showRegionBoundariesCB.setBounds(10, 220, 275, 23);
        this.label7.setText("Background color click to change): ");
        this.jPanel10.add(this.label7);
        this.label7.setBounds(15, 535, 235, this.label7.getPreferredSize().height);
        this.backgroundColorPanel.setPreferredSize(new Dimension(20, 20));
        this.backgroundColorPanel.setBorder(new BevelBorder(0));
        this.backgroundColorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                PreferencesEditor.this.backgroundColorPanelMouseClicked(e2);
            }
        });
        this.backgroundColorPanel.setLayout(null);
        this.jPanel10.add(this.backgroundColorPanel);
        this.backgroundColorPanel.setBounds(255, 530, 30, 29);
        this.resetBackgroundButton.setText("Reset to default");
        this.resetBackgroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.resetBackgroundButtonActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.resetBackgroundButton);
        this.resetBackgroundButton.setBounds(315, 530, 150, this.resetBackgroundButton.getPreferredSize().height);
        this.showMissingDataCB.setText("Distinguish missing data");
        this.showMissingDataCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showMissingDataCBActionPerformed(e2);
            }
        });
        this.jPanel10.add(this.showMissingDataCB);
        this.showMissingDataCB.setBounds(10, 10, 248, 23);
        this.label32.setText("<html><i>Distinguish regions with zero values from regions with no data on plots (e.g. bar charts).  Regions with no data are indicated with a gray background.</b>");
        this.jPanel10.add(this.label32);
        this.label32.setBounds(45, 35, 700, 47);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.jPanel10.getComponentCount(); ++i2) {
            bounds = this.jPanel10.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.jPanel10.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel10.setMinimumSize(preferredSize);
        this.jPanel10.setPreferredSize(preferredSize);
        this.generalPanel.add((Component)this.jPanel10, "Center");
        this.tabbedPane.addTab("General", this.generalPanel);
        this.tracksPanel.setLayout(null);
        this.jPanel6.setLayout(null);
        this.jLabel5.setText("Default Track Height, Charts (Pixels)");
        this.jPanel6.add(this.jLabel5);
        this.jLabel5.setBounds(new Rectangle(new Point(10, 12), this.jLabel5.getPreferredSize()));
        this.defaultChartTrackHeightField.setText("40");
        this.defaultChartTrackHeightField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.defaultChartTrackHeightFieldActionPerformed(e2);
            }
        });
        this.defaultChartTrackHeightField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.defaultChartTrackHeightFieldFocusLost(e2);
            }
        });
        this.jPanel6.add(this.defaultChartTrackHeightField);
        this.defaultChartTrackHeightField.setBounds(271, 6, 57, this.defaultChartTrackHeightField.getPreferredSize().height);
        this.trackNameAttributeLabel.setText("Track Name Attribute");
        this.jPanel6.add(this.trackNameAttributeLabel);
        this.trackNameAttributeLabel.setBounds(new Rectangle(new Point(10, 120), this.trackNameAttributeLabel.getPreferredSize()));
        this.trackNameAttributeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.trackNameAttributeFieldActionPerformed(e2);
            }
        });
        this.trackNameAttributeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.trackNameAttributeFieldFocusLost(e2);
            }
        });
        this.jPanel6.add(this.trackNameAttributeField);
        this.trackNameAttributeField.setBounds(150, 115, 216, this.trackNameAttributeField.getPreferredSize().height);
        this.missingDataExplanation2.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation2.setText("<html>Name of an attribute to be used to label  tracks.  If provided tracks will be labeled with the corresponding attribute values from the sample information file");
        this.missingDataExplanation2.setVerticalAlignment(1);
        this.jPanel6.add(this.missingDataExplanation2);
        this.missingDataExplanation2.setBounds(40, 170, 578, 54);
        this.jLabel8.setText("Default Track Height, Other (Pixels)");
        this.jPanel6.add(this.jLabel8);
        this.jLabel8.setBounds(new Rectangle(new Point(10, 45), this.jLabel8.getPreferredSize()));
        this.defaultTrackHeightField.setText("15");
        this.defaultTrackHeightField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.defaultTrackHeightFieldActionPerformed(e2);
            }
        });
        this.defaultTrackHeightField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.defaultTrackHeightFieldFocusLost(e2);
            }
        });
        this.jPanel6.add(this.defaultTrackHeightField);
        this.defaultTrackHeightField.setBounds(271, 39, 57, this.defaultTrackHeightField.getPreferredSize().height);
        this.missingDataExplanation4.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation4.setText("<html>Default height of chart tracks (barcharts, scatterplots, etc)");
        this.jPanel6.add(this.missingDataExplanation4);
        this.missingDataExplanation4.setBounds(350, 5, 354, 25);
        this.missingDataExplanation5.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation5.setText("<html>Default height of all other tracks");
        this.jPanel6.add(this.missingDataExplanation5);
        this.missingDataExplanation5.setBounds(350, 41, 1141, 25);
        this.missingDataExplanation3.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation3.setText("<html><i> If selected feature tracks are expanded by default.");
        this.jPanel6.add(this.missingDataExplanation3);
        this.missingDataExplanation3.setBounds(new Rectangle(new Point(876, 318), this.missingDataExplanation3.getPreferredSize()));
        this.expandCB.setText("Expand Feature Tracks");
        this.expandCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.expandCBActionPerformed(e2);
            }
        });
        this.jPanel6.add(this.expandCB);
        this.expandCB.setBounds(new Rectangle(new Point(6, 272), this.expandCB.getPreferredSize()));
        this.normalizeCoverageCB.setText("Normalize Coverage Data");
        this.normalizeCoverageCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.normalizeCoverageCBActionPerformed(e2);
            }
        });
        this.normalizeCoverageCB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.normalizeCoverageCBFocusLost(e2);
            }
        });
        this.jPanel6.add(this.normalizeCoverageCB);
        this.normalizeCoverageCB.setBounds(new Rectangle(new Point(6, 372), this.normalizeCoverageCB.getPreferredSize()));
        this.missingDataExplanation8.setFont(new Font("Lucida Grande", 2, 12));
        this.missingDataExplanation8.setText("<html><i> Applies to coverage tracks computed with igvtools (.tdf files).  If selected coverage values are scaled by (1,000,000 / totalCount),  where totalCount is the total number of features or alignments.");
        this.missingDataExplanation8.setVerticalAlignment(1);
        this.jPanel6.add(this.missingDataExplanation8);
        this.missingDataExplanation8.setBounds(50, 413, 608, 52);
        this.expandIconCB.setText("Show Expand Icon");
        this.expandIconCB.setToolTipText("If checked displays an expand/collapse icon on feature tracks.");
        this.expandIconCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.expandIconCBActionPerformed(e2);
            }
        });
        this.jPanel6.add(this.expandIconCB);
        this.expandIconCB.setBounds(new Rectangle(new Point(6, 318), this.expandIconCB.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.jPanel6.getComponentCount(); ++i3) {
            bounds = this.jPanel6.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel6.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel6.setMinimumSize(preferredSize);
        this.jPanel6.setPreferredSize(preferredSize);
        this.tracksPanel.add(this.jPanel6);
        this.jPanel6.setBounds(40, 20, 725, 480);
        preferredSize = new Dimension();
        for (int i4 = 0; i4 < this.tracksPanel.getComponentCount(); ++i4) {
            bounds = this.tracksPanel.getComponent(i4).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.tracksPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.tracksPanel.setMinimumSize(preferredSize);
        this.tracksPanel.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Tracks", this.tracksPanel);
        this.overlaysPanel.setLayout(null);
        this.jPanel5.setLayout(null);
        this.jLabel3.setText("Linking attribute column:");
        this.jPanel5.add(this.jLabel3);
        this.jLabel3.setBounds(new Rectangle(new Point(65, 86), this.jLabel3.getPreferredSize()));
        this.overlayAttributeTextField.setText("LINKING_ID");
        this.overlayAttributeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.overlayAttributeTextFieldActionPerformed(e2);
            }
        });
        this.overlayAttributeTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.overlayAttributeTextFieldFocusLost(e2);
            }
        });
        this.jPanel5.add(this.overlayAttributeTextField);
        this.overlayAttributeTextField.setBounds(240, 80, 228, this.overlayAttributeTextField.getPreferredSize().height);
        this.overlayTrackCB.setSelected(true);
        this.overlayTrackCB.setText("Overlay mutation tracks");
        this.overlayTrackCB.setActionCommand("overlayTracksCB");
        this.overlayTrackCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.overlayTrackCBActionPerformed(e2);
            }
        });
        this.jPanel5.add(this.overlayTrackCB);
        this.overlayTrackCB.setBounds(new Rectangle(new Point(6, 51), this.overlayTrackCB.getPreferredSize()));
        this.jLabel2.setFont(new Font("Lucida Grande", 2, 12));
        this.jPanel5.add(this.jLabel2);
        this.jLabel2.setBounds(new Rectangle(new Point(6, 6), this.jLabel2.getPreferredSize()));
        this.jLabel4.setFont(new Font("Lucida Grande", 2, 12));
        this.jPanel5.add(this.jLabel4);
        this.jLabel4.setBounds(new Rectangle(new Point(6, 12), this.jLabel4.getPreferredSize()));
        this.colorCodeMutationsCB.setText("Color code mutations");
        this.colorCodeMutationsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.colorMutationsCBActionPerformed(e2);
            }
        });
        this.jPanel5.add(this.colorCodeMutationsCB);
        this.colorCodeMutationsCB.setBounds(new Rectangle(new Point(0, 295), this.colorCodeMutationsCB.getPreferredSize()));
        this.chooseMutationColorsButton.setText("Choose colors");
        this.chooseMutationColorsButton.setFont(UIManager.getFont("Button.font"));
        this.chooseMutationColorsButton.setVerticalTextPosition(3);
        this.chooseMutationColorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.chooseMutationColorsButtonActionPerformed(e2);
            }
        });
        this.jPanel5.add(this.chooseMutationColorsButton);
        this.chooseMutationColorsButton.setBounds(new Rectangle(new Point(185, 292), this.chooseMutationColorsButton.getPreferredSize()));
        this.label11.setText("<html><i>Name of a sample attribute column to link mutation and data tracks");
        this.label11.setVerticalAlignment(1);
        this.jPanel5.add(this.label11);
        this.label11.setBounds(110, 115, 360, 50);
        this.showOrphanedMutationsCB.setText("Show orphaned mutation tracks");
        this.showOrphanedMutationsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showOrphanedMutationsCBActionPerformed(e2);
            }
        });
        this.jPanel5.add(this.showOrphanedMutationsCB);
        this.showOrphanedMutationsCB.setBounds(new Rectangle(new Point(70, 180), this.showOrphanedMutationsCB.getPreferredSize()));
        this.label12.setText("<html><i>Select to show mutation tracks with no corresponding data track.");
        this.label12.setVerticalAlignment(1);
        this.jPanel5.add(this.label12);
        this.label12.setBounds(110, 210, 360, 55);
        preferredSize = new Dimension();
        for (int i5 = 0; i5 < this.jPanel5.getComponentCount(); ++i5) {
            bounds = this.jPanel5.getComponent(i5).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel5.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel5.setMinimumSize(preferredSize);
        this.jPanel5.setPreferredSize(preferredSize);
        this.overlaysPanel.add(this.jPanel5);
        this.jPanel5.setBounds(28, 55, 673, 394);
        preferredSize = new Dimension();
        for (int i6 = 0; i6 < this.overlaysPanel.getComponentCount(); ++i6) {
            bounds = this.overlaysPanel.getComponent(i6).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.overlaysPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.overlaysPanel.setMinimumSize(preferredSize);
        this.overlaysPanel.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Mutations", this.overlaysPanel);
        this.chartPanel.setLayout(null);
        this.jPanel4.setBorder(LineBorder.createBlackLineBorder());
        this.jPanel4.setLayout(null);
        this.topBorderCB.setText("Draw Top Border");
        this.topBorderCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.topBorderCBActionPerformed(e2);
                PreferencesEditor.this.topBorderCBActionPerformed(e2);
            }
        });
        this.jPanel4.add(this.topBorderCB);
        this.topBorderCB.setBounds(new Rectangle(new Point(30, 36), this.topBorderCB.getPreferredSize()));
        this.label1.setFont(this.label1.getFont());
        this.label1.setText("<html><b>Default settings for barcharts and scatterplots:");
        this.jPanel4.add(this.label1);
        this.label1.setBounds(10, 10, 380, 25);
        this.chartDrawTrackNameCB.setText("Draw Track Label");
        this.chartDrawTrackNameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.chartDrawTrackNameCBActionPerformed(e2);
            }
        });
        this.jPanel4.add(this.chartDrawTrackNameCB);
        this.chartDrawTrackNameCB.setBounds(new Rectangle(new Point(30, 126), this.chartDrawTrackNameCB.getPreferredSize()));
        this.bottomBorderCB.setText("Draw Bottom Border");
        this.bottomBorderCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.bottomBorderCBActionPerformed(e2);
            }
        });
        this.jPanel4.add(this.bottomBorderCB);
        this.bottomBorderCB.setBounds(new Rectangle(new Point(30, 66), this.bottomBorderCB.getPreferredSize()));
        this.jLabel7.setText("<html><i>Dynamically rescale to the range of the data in view.");
        this.jPanel4.add(this.jLabel7);
        this.jLabel7.setBounds(220, 170, 371, 50);
        this.colorBordersCB.setText("Color Borders");
        this.colorBordersCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.colorBordersCBActionPerformed(e2);
            }
        });
        this.jPanel4.add(this.colorBordersCB);
        this.colorBordersCB.setBounds(new Rectangle(new Point(30, 96), this.colorBordersCB.getPreferredSize()));
        this.labelYAxisCB.setText("Label Y Axis");
        this.labelYAxisCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.labelYAxisCBActionPerformed(e2);
            }
        });
        this.jPanel4.add(this.labelYAxisCB);
        this.labelYAxisCB.setBounds(new Rectangle(new Point(30, 156), this.labelYAxisCB.getPreferredSize()));
        this.autoscaleCB.setText("Continuous Autoscale");
        this.autoscaleCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.autoscaleCBActionPerformed(e2);
            }
        });
        this.jPanel4.add(this.autoscaleCB);
        this.autoscaleCB.setBounds(new Rectangle(new Point(30, 186), this.autoscaleCB.getPreferredSize()));
        this.jLabel9.setText("<html><i>Draw a label centered over the track. ");
        this.jPanel4.add(this.jLabel9);
        this.jLabel9.setBounds(220, 159, 355, this.jLabel9.getPreferredSize().height);
        this.showDatarangeCB.setText("Show Data Range");
        this.showDatarangeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showDatarangeCBActionPerformed(e2);
            }
        });
        this.showDatarangeCB.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.showDatarangeCBFocusLost(e2);
            }
        });
        this.jPanel4.add(this.showDatarangeCB);
        this.showDatarangeCB.setBounds(30, 216, this.showDatarangeCB.getPreferredSize().width, 26);
        preferredSize = new Dimension();
        for (int i7 = 0; i7 < this.jPanel4.getComponentCount(); ++i7) {
            bounds = this.jPanel4.getComponent(i7).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel4.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel4.setMinimumSize(preferredSize);
        this.jPanel4.setPreferredSize(preferredSize);
        this.chartPanel.add(this.jPanel4);
        this.jPanel4.setBounds(20, 20, 650, 290);
        this.panel1.setBorder(LineBorder.createBlackLineBorder());
        this.panel1.setLayout(null);
        this.label13.setText("<html><b>Default settings for heatmaps:");
        this.panel1.add(this.label13);
        this.label13.setBounds(10, 5, 250, 30);
        this.showAllHeatmapFeauresCB.setText("Show all features");
        this.showAllHeatmapFeauresCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showAllHeatmapFeauresCBActionPerformed(e2);
            }
        });
        this.panel1.add(this.showAllHeatmapFeauresCB);
        this.showAllHeatmapFeauresCB.setBounds(new Rectangle(new Point(20, 45), this.showAllHeatmapFeauresCB.getPreferredSize()));
        this.label14.setText("<html><i>Paint all features/segments with a minimum width of 1 pixel.   If not checked features/segments with screen widths less than 1 pixel are not drawn.");
        this.panel1.add(this.label14);
        this.label14.setBounds(200, 35, 425, 60);
        this.chartPanel.add(this.panel1);
        this.panel1.setBounds(20, 340, 650, 135);
        preferredSize = new Dimension();
        for (int i8 = 0; i8 < this.chartPanel.getComponentCount(); ++i8) {
            bounds = this.chartPanel.getComponent(i8).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.chartPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.chartPanel.setMinimumSize(preferredSize);
        this.chartPanel.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Charts", this.chartPanel);
        this.alignmentPanel.setLayout(null);
        this.jPanel11.setBorder(new TitledBorder(""));
        this.jPanel11.setLayout(null);
        this.jLabel11.setText("Visibility range threshold (kb):");
        this.jPanel11.add(this.jLabel11);
        this.jLabel11.setBounds(new Rectangle(new Point(10, 12), this.jLabel11.getPreferredSize()));
        this.samMaxWindowSizeField.setText("jTextField1");
        this.samMaxWindowSizeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samMaxWindowSizeFieldActionPerformed(e2);
            }
        });
        this.samMaxWindowSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.samMaxWindowSizeFieldFocusLost(e2);
            }
        });
        this.jPanel11.add(this.samMaxWindowSizeField);
        this.samMaxWindowSizeField.setBounds(new Rectangle(new Point(220, 6), this.samMaxWindowSizeField.getPreferredSize()));
        this.jLabel12.setText("<html><i>Nominal window size at which alignments become visible");
        this.jPanel11.add(this.jLabel12);
        this.jLabel12.setBounds(new Rectangle(new Point(320, 12), this.jLabel12.getPreferredSize()));
        this.jLabel14.setText("<html><i>Nominal window size at which alignments become visible");
        this.jPanel11.add(this.jLabel14);
        this.jLabel14.setBounds(0, 108, 363, 16);
        this.jLabel16.setText("<html><i>Nominal window size at which alignments become visible");
        this.jPanel11.add(this.jLabel16);
        this.jLabel16.setBounds(0, 129, 363, 16);
        preferredSize = new Dimension();
        for (int i9 = 0; i9 < this.jPanel11.getComponentCount(); ++i9) {
            bounds = this.jPanel11.getComponent(i9).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel11.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel11.setMinimumSize(preferredSize);
        this.jPanel11.setPreferredSize(preferredSize);
        this.alignmentPanel.add(this.jPanel11);
        this.jPanel11.setBounds(10, 5, 755, 45);
        this.panel4.setBorder(new TitledBorder(""));
        this.panel4.setLayout(null);
        this.downsampleReadsCB.setText("Downsample reads");
        this.downsampleReadsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.downsampleReadsCBActionPerformed(e2);
            }
        });
        this.panel4.add(this.downsampleReadsCB);
        this.downsampleReadsCB.setBounds(new Rectangle(new Point(5, 13), this.downsampleReadsCB.getPreferredSize()));
        this.label23.setText("Max read count:");
        this.panel4.add(this.label23);
        this.label23.setBounds(new Rectangle(new Point(195, 16), this.label23.getPreferredSize()));
        this.samDownsampleCountField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samDownsampleCountFieldActionPerformed(e2);
            }
        });
        this.samDownsampleCountField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.samDownsampleCountFieldFocusLost(e2);
            }
        });
        this.panel4.add(this.samDownsampleCountField);
        this.samDownsampleCountField.setBounds(300, 10, 80, 28);
        this.jLabel13.setText("per window size (bases):");
        this.panel4.add(this.jLabel13);
        this.jLabel13.setBounds(new Rectangle(new Point(420, 16), this.jLabel13.getPreferredSize()));
        this.samSamplingWindowField.setText("jTextField1");
        this.samSamplingWindowField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samSamplingWindowFieldActionPerformed(e2);
            }
        });
        this.samSamplingWindowField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.samSamplingWindowFieldFocusLost(e2);
            }
        });
        this.panel4.add(this.samSamplingWindowField);
        this.samSamplingWindowField.setBounds(580, 10, 80, 28);
        preferredSize = new Dimension();
        for (int i10 = 0; i10 < this.panel4.getComponentCount(); ++i10) {
            bounds = this.panel4.getComponent(i10).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel4.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel4.setMinimumSize(preferredSize);
        this.panel4.setPreferredSize(preferredSize);
        this.alignmentPanel.add(this.panel4);
        this.panel4.setBounds(10, 62, 755, 48);
        this.jPanel12.setBorder(new TitledBorder("Filter and shading options"));
        this.jPanel12.setLayout(null);
        this.snpThresholdField.setText("0");
        this.snpThresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.snpThresholdFieldActionPerformed(e2);
            }
        });
        this.snpThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.snpThresholdFieldFocusLost(e2);
            }
        });
        this.jPanel12.add(this.snpThresholdField);
        this.snpThresholdField.setBounds(240, 20, 80, this.snpThresholdField.getPreferredSize().height);
        this.jLabel26.setText("Coverage allele-freq threshold");
        this.jPanel12.add(this.jLabel26);
        this.jLabel26.setBounds(32, 25, 200, this.jLabel26.getPreferredSize().height);
        this.samMinBaseQualityField.setText("0");
        this.samMinBaseQualityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samMinBaseQualityFieldActionPerformed(e2);
            }
        });
        this.samMinBaseQualityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.samMinBaseQualityFieldFocusLost(e2);
            }
        });
        this.jPanel12.add(this.samMinBaseQualityField);
        this.samMinBaseQualityField.setBounds(265, 160, 55, this.samMinBaseQualityField.getPreferredSize().height);
        this.samShadeMismatchedBaseCB.setText("Shade mismatched bases by quality:");
        this.samShadeMismatchedBaseCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samShadeMismatchedBaseCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.samShadeMismatchedBaseCB);
        this.samShadeMismatchedBaseCB.setBounds(5, 160, 264, this.samShadeMismatchedBaseCB.getPreferredSize().height);
        this.samMaxBaseQualityField.setText("0");
        this.samMaxBaseQualityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samMaxBaseQualityFieldActionPerformed(e2);
            }
        });
        this.samMaxBaseQualityField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.samMaxBaseQualityFieldFocusLost(e2);
            }
        });
        this.jPanel12.add(this.samMaxBaseQualityField);
        this.samMaxBaseQualityField.setBounds(370, 160, 55, this.samMaxBaseQualityField.getPreferredSize().height);
        this.showCovTrackCB.setText("Show coverage track");
        this.showCovTrackCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showCovTrackCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.showCovTrackCB);
        this.showCovTrackCB.setBounds(360, 78, 270, this.showCovTrackCB.getPreferredSize().height);
        this.samFilterDuplicatesCB.setText("Filter duplicate reads");
        this.samFilterDuplicatesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samShowDuplicatesCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.samFilterDuplicatesCB);
        this.samFilterDuplicatesCB.setBounds(5, 50, 290, this.samFilterDuplicatesCB.getPreferredSize().height);
        this.filterCB.setText("Filter alignments by read group");
        this.filterCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.filterCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.filterCB);
        this.filterCB.setBounds(5, 215, 244, this.filterCB.getPreferredSize().height);
        this.filterURL.setText("URL or path to filter file");
        this.filterURL.setEnabled(false);
        this.filterURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.filterURLActionPerformed(e2);
            }
        });
        this.filterURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.filterURLFocusLost(e2);
            }
        });
        this.jPanel12.add(this.filterURL);
        this.filterURL.setBounds(265, 216, 440, this.filterURL.getPreferredSize().height);
        this.samFlagUnmappedPairCB.setText("Flag unmapped pairs");
        this.samFlagUnmappedPairCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samFlagUnmappedPairCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.samFlagUnmappedPairCB);
        this.samFlagUnmappedPairCB.setBounds(5, 134, 310, this.samFlagUnmappedPairCB.getPreferredSize().height);
        this.filterFailedReadsCB.setText("Filter vendor failed reads");
        this.filterFailedReadsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.filterVendorFailedReadsCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.filterFailedReadsCB);
        this.filterFailedReadsCB.setBounds(new Rectangle(new Point(5, 78), this.filterFailedReadsCB.getPreferredSize()));
        this.label2.setText("to");
        this.jPanel12.add(this.label2);
        this.label2.setBounds(330, 166, 25, this.label2.getPreferredSize().height);
        this.showSoftClippedCB.setText("Show soft-clipped bases");
        this.showSoftClippedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showSoftClippedCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.showSoftClippedCB);
        this.showSoftClippedCB.setBounds(new Rectangle(new Point(360, 106), this.showSoftClippedCB.getPreferredSize()));
        this.showCenterLineCB.setText("Show center line");
        this.showCenterLineCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showCenterLineCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.showCenterLineCB);
        this.showCenterLineCB.setBounds(360, 50, 199, this.showCenterLineCB.getPreferredSize().height);
        this.zeroQualityAlignmentCB.setText("Flag zero-quality alignments");
        this.zeroQualityAlignmentCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.zeroQualityAlignmentCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.zeroQualityAlignmentCB);
        this.zeroQualityAlignmentCB.setBounds(new Rectangle(new Point(360, 134), this.zeroQualityAlignmentCB.getPreferredSize()));
        this.jLabel15.setText("Mapping quality threshold:");
        this.jPanel12.add(this.jLabel15);
        this.jLabel15.setBounds(new Rectangle(new Point(367, 25), this.jLabel15.getPreferredSize()));
        this.mappingQualityThresholdField.setText("0");
        this.mappingQualityThresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.mappingQualityThresholdFieldActionPerformed(e2);
            }
        });
        this.mappingQualityThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.mappingQualityThresholdFieldFocusLost(e2);
            }
        });
        this.jPanel12.add(this.mappingQualityThresholdField);
        this.mappingQualityThresholdField.setBounds(550, 20, 80, this.mappingQualityThresholdField.getPreferredSize().height);
        this.filterSecondaryAlignmentsCB.setText("Filter secondary alignments");
        this.filterSecondaryAlignmentsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.filterSecondaryAlignmentsCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.filterSecondaryAlignmentsCB);
        this.filterSecondaryAlignmentsCB.setBounds(new Rectangle(new Point(5, 106), this.filterSecondaryAlignmentsCB.getPreferredSize()));
        this.samFlagInsertionsCB.setText("Flag insertions larger than: ");
        this.samFlagInsertionsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samFlagInsertionsCBActionPerformed(e2);
            }
        });
        this.jPanel12.add(this.samFlagInsertionsCB);
        this.samFlagInsertionsCB.setBounds(new Rectangle(new Point(5, 188), this.samFlagInsertionsCB.getPreferredSize()));
        this.filterURL2.setText("URL or path to filter file");
        this.filterURL2.setEnabled(false);
        this.filterURL2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.filterURLActionPerformed(e2);
            }
        });
        this.filterURL2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.filterURLFocusLost(e2);
            }
        });
        this.jPanel12.add(this.filterURL2);
        this.filterURL2.setBounds(0, 248, 440, 28);
        this.samFlagInsertionsThresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.samFlagInsertionsThresholdFieldActionPerformed(e2);
            }
        });
        this.samFlagInsertionsThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.samFlagInsertionsThresholdFieldFocusLost(e2);
            }
        });
        this.jPanel12.add(this.samFlagInsertionsThresholdField);
        this.samFlagInsertionsThresholdField.setBounds(265, 188, 165, this.samFlagInsertionsThresholdField.getPreferredSize().height);
        this.label31.setText("bases");
        this.jPanel12.add(this.label31);
        this.label31.setBounds(450, 195, 60, this.label31.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i11 = 0; i11 < this.jPanel12.getComponentCount(); ++i11) {
            bounds = this.jPanel12.getComponent(i11).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel12.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel12.setMinimumSize(preferredSize);
        this.jPanel12.setPreferredSize(preferredSize);
        this.alignmentPanel.add(this.jPanel12);
        this.jPanel12.setBounds(10, 120, 755, 250);
        this.panel2.setBorder(new TitledBorder("Insert Size Options"));
        this.panel2.setLayout(null);
        this.isizeComputeCB.setText("Compute");
        this.isizeComputeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.isizeComputeCBActionPerformed(e2);
                PreferencesEditor.this.isizeComputeCBActionPerformed(e2);
                PreferencesEditor.this.isizeComputeCBActionPerformed(e2);
            }
        });
        this.panel2.add(this.isizeComputeCB);
        this.isizeComputeCB.setBounds(new Rectangle(new Point(360, 76), this.isizeComputeCB.getPreferredSize()));
        this.jLabel17.setText("Maximum (bp):");
        this.panel2.add(this.jLabel17);
        this.jLabel17.setBounds(100, 110, 110, this.jLabel17.getPreferredSize().height);
        this.insertSizeMinThresholdField.setText("0");
        this.insertSizeMinThresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldActionPerformed(e2);
            }
        });
        this.insertSizeMinThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldFocusLost(e2);
            }
        });
        this.panel2.add(this.insertSizeMinThresholdField);
        this.insertSizeMinThresholdField.setBounds(220, 75, 80, 28);
        this.jLabel20.setText("Minimum (bp):");
        this.panel2.add(this.jLabel20);
        this.jLabel20.setBounds(100, 80, 110, 16);
        this.insertSizeThresholdField.setText("0");
        this.insertSizeThresholdField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeThresholdFieldActionPerformed(e2);
            }
        });
        this.insertSizeThresholdField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e2);
            }
        });
        this.panel2.add(this.insertSizeThresholdField);
        this.insertSizeThresholdField.setBounds(220, 105, 80, this.insertSizeThresholdField.getPreferredSize().height);
        this.jLabel30.setText("Minimum (percentile):");
        this.panel2.add(this.jLabel30);
        this.jLabel30.setBounds(460, 80, 155, 16);
        this.jLabel18.setText("Maximum (percentile):");
        this.panel2.add(this.jLabel18);
        this.jLabel18.setBounds(460, 110, 155, 16);
        this.insertSizeMinPercentileField.setText("0");
        this.insertSizeMinPercentileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMinPercentileFieldActionPerformed(e2);
            }
        });
        this.insertSizeMinPercentileField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e2);
                PreferencesEditor.this.insertSizeMinThresholdFieldFocusLost(e2);
                PreferencesEditor.this.insertSizeMinPercentileFieldFocusLost(e2);
            }
        });
        this.panel2.add(this.insertSizeMinPercentileField);
        this.insertSizeMinPercentileField.setBounds(625, 75, 80, 28);
        this.insertSizeMaxPercentileField.setText("0");
        this.insertSizeMaxPercentileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeThresholdFieldActionPerformed(e2);
                PreferencesEditor.this.insertSizeMaxPercentileFieldActionPerformed(e2);
            }
        });
        this.insertSizeMaxPercentileField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.insertSizeThresholdFieldFocusLost(e2);
                PreferencesEditor.this.insertSizeMaxPercentileFieldFocusLost(e2);
            }
        });
        this.panel2.add(this.insertSizeMaxPercentileField);
        this.insertSizeMaxPercentileField.setBounds(625, 105, 80, 28);
        this.label8.setText("<html><i>These options control the color coding of paired alignments by inferred insert size.   Base pair values set default values.  If \"compute\" is selected  values are computed from the actual size distribution of each library.");
        this.panel2.add(this.label8);
        this.label8.setBounds(5, 15, 735, 55);
        this.label9.setText("Defaults ");
        this.panel2.add(this.label9);
        this.label9.setBounds(new Rectangle(new Point(15, 80), this.label9.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i12 = 0; i12 < this.panel2.getComponentCount(); ++i12) {
            bounds = this.panel2.getComponent(i12).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel2.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel2.setMinimumSize(preferredSize);
        this.panel2.setPreferredSize(preferredSize);
        this.alignmentPanel.add(this.panel2);
        this.panel2.setBounds(10, 470, 755, 145);
        this.panel3.setBorder(new TitledBorder("Splice Junction Track Options"));
        this.panel3.setLayout(null);
        this.showJunctionTrackCB.setText("Show junction track");
        this.showJunctionTrackCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showJunctionTrackCBActionPerformed(e2);
            }
        });
        this.panel3.add(this.showJunctionTrackCB);
        this.showJunctionTrackCB.setBounds(new Rectangle(new Point(5, 25), this.showJunctionTrackCB.getPreferredSize()));
        this.showJunctionFlankingRegionsCB.setText("Show flanking regions");
        this.showJunctionFlankingRegionsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showJunctionFlankingRegionsCBActionPerformed(e2);
            }
        });
        this.panel3.add(this.showJunctionFlankingRegionsCB);
        this.showJunctionFlankingRegionsCB.setBounds(new Rectangle(new Point(5, 50), this.showJunctionFlankingRegionsCB.getPreferredSize()));
        this.junctionFlankingTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.junctionFlankingTextFieldActionPerformed(e2);
            }
        });
        this.junctionFlankingTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.junctionFlankingTextFieldFocusLost(e2);
            }
        });
        this.panel3.add(this.junctionFlankingTextField);
        this.junctionFlankingTextField.setBounds(325, 25, 80, this.junctionFlankingTextField.getPreferredSize().height);
        this.label15.setText("Min flanking width:");
        this.panel3.add(this.label15);
        this.label15.setBounds(185, 30, 125, this.label15.getPreferredSize().height);
        this.label16.setText("Min junction coverage:");
        this.panel3.add(this.label16);
        this.label16.setBounds(new Rectangle(new Point(460, 30), this.label16.getPreferredSize()));
        this.junctionCoverageTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.junctionCoverageTextFieldActionPerformed(e2);
            }
        });
        this.junctionCoverageTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.junctionCoverageTextFieldFocusLost(e2);
            }
        });
        this.panel3.add(this.junctionCoverageTextField);
        this.junctionCoverageTextField.setBounds(615, 25, 80, 28);
        preferredSize = new Dimension();
        for (int i13 = 0; i13 < this.panel3.getComponentCount(); ++i13) {
            bounds = this.panel3.getComponent(i13).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel3.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel3.setMinimumSize(preferredSize);
        this.panel3.setPreferredSize(preferredSize);
        this.alignmentPanel.add(this.panel3);
        this.panel3.setBounds(10, 380, 755, 85);
        preferredSize = new Dimension();
        for (int i14 = 0; i14 < this.alignmentPanel.getComponentCount(); ++i14) {
            bounds = this.alignmentPanel.getComponent(i14).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.alignmentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.alignmentPanel.setMinimumSize(preferredSize);
        this.alignmentPanel.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Alignments", this.alignmentPanel);
        this.expressionPane.setLayout(null);
        this.jPanel8.setLayout(null);
        this.expMapToGeneCB.setText("Map probes to genes");
        this.expMapToGeneCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.expMapToGeneCBActionPerformed(e2);
                PreferencesEditor.this.expMapToGeneCBActionPerformed(e2);
            }
        });
        this.jPanel8.add(this.expMapToGeneCB);
        this.expMapToGeneCB.setBounds(new Rectangle(new Point(45, 129), this.expMapToGeneCB.getPreferredSize()));
        this.jLabel24.setText("Expression probe mapping options: ");
        this.jPanel8.add(this.jLabel24);
        this.jLabel24.setBounds(new Rectangle(new Point(20, 20), this.jLabel24.getPreferredSize()));
        this.expMapToLociCB.setText("<html>Map probes to target loci");
        this.expMapToLociCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.expMapToLociCBActionPerformed(e2);
            }
        });
        this.jPanel8.add(this.expMapToLociCB);
        this.expMapToLociCB.setBounds(new Rectangle(new Point(45, 92), this.expMapToLociCB.getPreferredSize()));
        this.jLabel21.setText("<html><i>Note: Changes will not affect currently loaded datasets.");
        this.jPanel8.add(this.jLabel21);
        this.jLabel21.setBounds(44, 44, 497, 44);
        this.probeMappingFileTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.probeMappingFileTextFieldFocusLost(e2);
            }
        });
        this.probeMappingFileTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.probeMappingFileTextFieldActionPerformed(e2);
            }
        });
        this.jPanel8.add(this.probeMappingFileTextField);
        this.probeMappingFileTextField.setBounds(45, 322, 581, this.probeMappingFileTextField.getPreferredSize().height);
        this.label22.setText("<html><i>File path or URL to BED file containing genomic locations of probes.");
        this.jPanel8.add(this.label22);
        this.label22.setBounds(new Rectangle(new Point(45, 288), this.label22.getPreferredSize()));
        this.probeMappingBrowseButton.setText("Browse");
        this.probeMappingBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.probeMappingBrowseButtonActionPerformed(e2);
            }
        });
        this.jPanel8.add(this.probeMappingBrowseButton);
        this.probeMappingBrowseButton.setBounds(new Rectangle(new Point(637, 322), this.probeMappingBrowseButton.getPreferredSize()));
        this.useProbeMappingCB.setText("Use probe mapping file");
        this.useProbeMappingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.useProbeMappingCBActionPerformed(e2);
            }
        });
        this.jPanel8.add(this.useProbeMappingCB);
        this.useProbeMappingCB.setBounds(new Rectangle(new Point(20, 247), this.useProbeMappingCB.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i15 = 0; i15 < this.jPanel8.getComponentCount(); ++i15) {
            bounds = this.jPanel8.getComponent(i15).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel8.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel8.setMinimumSize(preferredSize);
        this.jPanel8.setPreferredSize(preferredSize);
        this.expressionPane.add(this.jPanel8);
        this.jPanel8.setBounds(10, 30, 755, 470);
        preferredSize = new Dimension();
        for (int i16 = 0; i16 < this.expressionPane.getComponentCount(); ++i16) {
            bounds = this.expressionPane.getComponent(i16).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.expressionPane.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.expressionPane.setMinimumSize(preferredSize);
        this.expressionPane.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Probes", this.expressionPane);
        this.proxyPanel.setLayout(new BoxLayout(this.proxyPanel, 0));
        this.jPanel15.setLayout(null);
        this.jPanel16.setLayout(null);
        this.proxyUsernameField.setText("jTextField1");
        this.proxyUsernameField.setEnabled(false);
        this.proxyUsernameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.proxyUsernameFieldActionPerformed(e2);
            }
        });
        this.proxyUsernameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.proxyUsernameFieldFocusLost(e2);
            }
        });
        this.jPanel16.add(this.proxyUsernameField);
        this.proxyUsernameField.setBounds(127, 45, 261, this.proxyUsernameField.getPreferredSize().height);
        this.jLabel28.setText("Username:");
        this.jPanel16.add(this.jLabel28);
        this.jLabel28.setBounds(new Rectangle(new Point(28, 51), this.jLabel28.getPreferredSize()));
        this.authenticateProxyCB.setText("Authentication required");
        this.authenticateProxyCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.authenticateProxyCBActionPerformed(e2);
            }
        });
        this.jPanel16.add(this.authenticateProxyCB);
        this.authenticateProxyCB.setBounds(new Rectangle(new Point(17, 17), this.authenticateProxyCB.getPreferredSize()));
        this.jLabel29.setText("Password:");
        this.jPanel16.add(this.jLabel29);
        this.jLabel29.setBounds(new Rectangle(new Point(28, 87), this.jLabel29.getPreferredSize()));
        this.proxyPasswordField.setText("jPasswordField1");
        this.proxyPasswordField.setEnabled(false);
        this.proxyPasswordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.proxyPasswordFieldFocusLost(e2);
            }
        });
        this.jPanel16.add(this.proxyPasswordField);
        this.proxyPasswordField.setBounds(127, 81, 261, this.proxyPasswordField.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i17 = 0; i17 < this.jPanel16.getComponentCount(); ++i17) {
            bounds = this.jPanel16.getComponent(i17).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel16.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel16.setMinimumSize(preferredSize);
        this.jPanel16.setPreferredSize(preferredSize);
        this.jPanel15.add(this.jPanel16);
        this.jPanel16.setBounds(20, 315, 741, this.jPanel16.getPreferredSize().height);
        this.jPanel17.setLayout(null);
        this.proxyHostField.setText("jTextField1");
        this.proxyHostField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.proxyHostFieldActionPerformed(e2);
            }
        });
        this.proxyHostField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.proxyHostFieldFocusLost(e2);
            }
        });
        this.jPanel17.add(this.proxyHostField);
        this.proxyHostField.setBounds(115, 70, 485, this.proxyHostField.getPreferredSize().height);
        this.proxyPortField.setText("jTextField1");
        this.proxyPortField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.proxyPortFieldActionPerformed(e2);
            }
        });
        this.proxyPortField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.proxyPortFieldFocusLost(e2);
            }
        });
        this.jPanel17.add(this.proxyPortField);
        this.proxyPortField.setBounds(115, 106, 108, this.proxyPortField.getPreferredSize().height);
        this.jLabel27.setText("Proxy port:");
        this.jPanel17.add(this.jLabel27);
        this.jLabel27.setBounds(20, 108, 95, 25);
        this.jLabel23.setText("Proxy host:");
        this.jPanel17.add(this.jLabel23);
        this.jLabel23.setBounds(20, 72, 95, 25);
        this.useProxyCB.setText("Use proxy");
        this.useProxyCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.useProxyCBActionPerformed(e2);
            }
        });
        this.jPanel17.add(this.useProxyCB);
        this.useProxyCB.setBounds(new Rectangle(new Point(9, 29), this.useProxyCB.getPreferredSize()));
        this.proxyTypeCB.setModel(new DefaultComboBoxModel<String>(new String[]{"HTTP", "SOCKS", "DIRECT"}));
        this.proxyTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.proxyTypeCBActionPerformed(e2);
            }
        });
        this.jPanel17.add(this.proxyTypeCB);
        this.proxyTypeCB.setBounds(new Rectangle(new Point(115, 145), this.proxyTypeCB.getPreferredSize()));
        this.label27.setText("Proxy type:");
        this.jPanel17.add(this.label27);
        this.label27.setBounds(20, 145, 95, 25);
        preferredSize = new Dimension();
        for (int i18 = 0; i18 < this.jPanel17.getComponentCount(); ++i18) {
            bounds = this.jPanel17.getComponent(i18).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel17.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel17.setMinimumSize(preferredSize);
        this.jPanel17.setPreferredSize(preferredSize);
        this.jPanel15.add(this.jPanel17);
        this.jPanel17.setBounds(20, 91, this.jPanel17.getPreferredSize().width, 199);
        this.label3.setText("<html>Note:  do not use these settings unless you receive error or warning messages about server connections.  On most systems the correct settings will be automatically copied from your web browser.");
        this.jPanel15.add(this.label3);
        this.label3.setBounds(22, 20, 630, 63);
        this.clearProxySettingsButton.setText("Clear All");
        this.clearProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.clearProxySettingsButtonActionPerformed(e2);
            }
        });
        this.jPanel15.add(this.clearProxySettingsButton);
        this.clearProxySettingsButton.setBounds(new Rectangle(new Point(35, 475), this.clearProxySettingsButton.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i19 = 0; i19 < this.jPanel15.getComponentCount(); ++i19) {
            bounds = this.jPanel15.getComponent(i19).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.jPanel15.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel15.setMinimumSize(preferredSize);
        this.jPanel15.setPreferredSize(preferredSize);
        this.proxyPanel.add(this.jPanel15);
        this.tabbedPane.addTab("Proxy", this.proxyPanel);
        this.dbPanel.setLayout(null);
        this.label17.setText("Host:");
        this.dbPanel.add(this.label17);
        this.label17.setBounds(new Rectangle(new Point(45, 76), this.label17.getPreferredSize()));
        this.label18.setText("Port (Optional)");
        this.dbPanel.add(this.label18);
        this.label18.setBounds(new Rectangle(new Point(45, 205), this.label18.getPreferredSize()));
        this.label19.setText("Name:");
        this.dbPanel.add(this.label19);
        this.label19.setBounds(new Rectangle(new Point(45, 115), this.label19.getPreferredSize()));
        this.dbHostField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.dbHostFieldActionPerformed(e2);
            }
        });
        this.dbHostField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.dbHostFieldFocusLost(e2);
            }
        });
        this.dbPanel.add(this.dbHostField);
        this.dbHostField.setBounds(110, 70, 430, this.dbHostField.getPreferredSize().height);
        this.dbPortField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.dbPortFieldActionPerformed(e2);
            }
        });
        this.dbPortField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.dbPortFieldFocusLost(e2);
            }
        });
        this.dbPanel.add(this.dbPortField);
        this.dbPortField.setBounds(155, 200, 130, 28);
        this.dbNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.dbNameFieldActionPerformed(e2);
            }
        });
        this.dbNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.dbNameFieldFocusLost(e2);
            }
        });
        this.dbPanel.add(this.dbNameField);
        this.dbNameField.setBounds(110, 110, 430, 28);
        this.label20.setText("<html><b>Database configuration  <i>(experimental, subject to change)");
        this.label20.setFont(new Font("Lucida Grande", 0, 14));
        this.dbPanel.add(this.label20);
        this.label20.setBounds(new Rectangle(new Point(50, 20), this.label20.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i20 = 0; i20 < this.dbPanel.getComponentCount(); ++i20) {
            bounds = this.dbPanel.getComponent(i20).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.dbPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.dbPanel.setMinimumSize(preferredSize);
        this.dbPanel.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Database", this.dbPanel);
        this.advancedPanel.setBorder(new EmptyBorder(1, 10, 1, 10));
        this.advancedPanel.setLayout(null);
        this.clearGenomeCacheButton.setText("Clear  Genome Cache");
        this.clearGenomeCacheButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.clearGenomeCacheButtonActionPerformed(e2);
            }
        });
        this.advancedPanel.add(this.clearGenomeCacheButton);
        this.clearGenomeCacheButton.setBounds(new Rectangle(new Point(390, 95), this.clearGenomeCacheButton.getPreferredSize()));
        this.enablePortCB.setText("Enable port");
        this.enablePortCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.enablePortCBActionPerformed(e2);
            }
        });
        this.advancedPanel.add(this.enablePortCB);
        this.enablePortCB.setBounds(new Rectangle(new Point(35, 30), this.enablePortCB.getPreferredSize()));
        this.portField.setText("60151");
        this.portField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.portFieldActionPerformed(e2);
            }
        });
        this.portField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.portFieldFocusLost(e2);
            }
        });
        this.advancedPanel.add(this.portField);
        this.portField.setBounds(175, 27, 126, this.portField.getPreferredSize().height);
        this.jLabel22.setFont(new Font("Lucida Grande", 2, 13));
        this.jLabel22.setText("Enable port to send commands and http requests to IGV. ");
        this.advancedPanel.add(this.jLabel22);
        this.jLabel22.setBounds(new Rectangle(new Point(315, 33), this.jLabel22.getPreferredSize()));
        this.genomeUpdateCB.setText("<html>Automatically check for updated genomes.    &nbsp;&nbsp;&nbsp;   <i>Most users should leave this checked.");
        this.genomeUpdateCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.genomeUpdateCBActionPerformed(e2);
            }
        });
        this.advancedPanel.add(this.genomeUpdateCB);
        this.genomeUpdateCB.setBounds(new Rectangle(new Point(35, 205), this.genomeUpdateCB.getPreferredSize()));
        this.jLabel6.setText("Data Registry URL");
        this.advancedPanel.add(this.jLabel6);
        this.jLabel6.setBounds(new Rectangle(new Point(70, 170), this.jLabel6.getPreferredSize()));
        this.dataServerURLTextField.setEnabled(false);
        this.dataServerURLTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.dataServerURLTextFieldActionPerformed(e2);
            }
        });
        this.dataServerURLTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.dataServerURLTextFieldFocusLost(e2);
            }
        });
        this.advancedPanel.add(this.dataServerURLTextField);
        this.dataServerURLTextField.setBounds(225, 165, 494, this.dataServerURLTextField.getPreferredSize().height);
        this.jLabel1.setText("Genome Server URL");
        this.advancedPanel.add(this.jLabel1);
        this.jLabel1.setBounds(new Rectangle(new Point(70, 135), this.jLabel1.getPreferredSize()));
        this.genomeServerURLTextField.setText("jTextField1");
        this.genomeServerURLTextField.setEnabled(false);
        this.genomeServerURLTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.genomeServerURLTextFieldActionPerformed(e2);
            }
        });
        this.genomeServerURLTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.genomeServerURLTextFieldFocusLost(e2);
            }
        });
        this.advancedPanel.add(this.genomeServerURLTextField);
        this.genomeServerURLTextField.setBounds(225, 130, 494, this.genomeServerURLTextField.getPreferredSize().height);
        this.editServerPropertiesCB.setText("Edit server properties");
        this.editServerPropertiesCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.editServerPropertiesCBActionPerformed(e2);
            }
        });
        this.advancedPanel.add(this.editServerPropertiesCB);
        this.editServerPropertiesCB.setBounds(new Rectangle(new Point(35, 95), this.editServerPropertiesCB.getPreferredSize()));
        this.jButton1.setText("Reset to Defaults");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.jButton1ActionPerformed(e2);
            }
        });
        this.advancedPanel.add(this.jButton1);
        this.jButton1.setBounds(new Rectangle(new Point(225, 95), this.jButton1.getPreferredSize()));
        this.igvDirectoryButton.setText("Move...");
        this.igvDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.igvDirectoryButtonActionPerformed(e2);
            }
        });
        this.advancedPanel.add(this.igvDirectoryButton);
        this.igvDirectoryButton.setBounds(610, 495, 100, this.igvDirectoryButton.getPreferredSize().height);
        this.igvDirectoryField.setBorder(new BevelBorder(1));
        this.advancedPanel.add(this.igvDirectoryField);
        this.igvDirectoryField.setBounds(55, 495, 550, 25);
        this.label21.setText("IGV Directory: ");
        this.advancedPanel.add(this.label21);
        this.label21.setBounds(45, 460, 105, this.label21.getPreferredSize().height);
        this.tooltipOptionsPanel.setLayout(null);
        this.label24.setText("Tooltip initial delay (ms)");
        this.tooltipOptionsPanel.add(this.label24);
        this.label24.setBounds(0, 0, 185, this.label24.getPreferredSize().height);
        this.label25.setText("Tooltip reshow delay (ms)");
        this.tooltipOptionsPanel.add(this.label25);
        this.label25.setBounds(0, 32, 185, 23);
        this.label26.setText("Tooltip dismiss delay (ms)");
        this.tooltipOptionsPanel.add(this.label26);
        this.label26.setBounds(0, 70, 185, 16);
        this.toolTipInitialDelayField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.toolTipInitialDelayFieldActionPerformed(e2);
            }
        });
        this.toolTipInitialDelayField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.toolTipInitialDelayFieldFocusLost(e2);
            }
        });
        this.tooltipOptionsPanel.add(this.toolTipInitialDelayField);
        this.toolTipInitialDelayField.setBounds(220, -6, 455, this.toolTipInitialDelayField.getPreferredSize().height);
        this.tooltipReshowDelayField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.tooltipReshowDelayFieldActionPerformed(e2);
            }
        });
        this.tooltipReshowDelayField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.tooltipReshowDelayFieldFocusLost(e2);
            }
        });
        this.tooltipOptionsPanel.add(this.tooltipReshowDelayField);
        this.tooltipReshowDelayField.setBounds(220, 29, 455, 28);
        this.tooltipDismissDelayField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.tooltipDismissDelayFieldActionPerformed(e2);
            }
        });
        this.tooltipDismissDelayField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.tooltipDismissDelayFieldFocusLost(e2);
            }
        });
        this.tooltipOptionsPanel.add(this.tooltipDismissDelayField);
        this.tooltipDismissDelayField.setBounds(220, 64, 455, 28);
        preferredSize = new Dimension();
        for (int i21 = 0; i21 < this.tooltipOptionsPanel.getComponentCount(); ++i21) {
            bounds = this.tooltipOptionsPanel.getComponent(i21).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.tooltipOptionsPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.tooltipOptionsPanel.setMinimumSize(preferredSize);
        this.tooltipOptionsPanel.setPreferredSize(preferredSize);
        this.advancedPanel.add(this.tooltipOptionsPanel);
        this.tooltipOptionsPanel.setBounds(new Rectangle(new Point(45, 320), this.tooltipOptionsPanel.getPreferredSize()));
        this.antialiasingCB.setText("Enable antialiasing");
        this.antialiasingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.antialiasingCBActionPerformed(e2);
            }
        });
        this.advancedPanel.add(this.antialiasingCB);
        this.antialiasingCB.setBounds(new Rectangle(new Point(35, 250), this.antialiasingCB.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i22 = 0; i22 < this.advancedPanel.getComponentCount(); ++i22) {
            bounds = this.advancedPanel.getComponent(i22).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.advancedPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.advancedPanel.setMinimumSize(preferredSize);
        this.advancedPanel.setPreferredSize(preferredSize);
        this.tabbedPane.addTab("Advanced", this.advancedPanel);
        this.ionTorrentPanel.setLayout(new BoxLayout(this.ionTorrentPanel, 1));
        this.panel6.setBorder(new TitledBorder("Flow signal distribution chart options"));
        this.panel6.setLayout(null);
        this.hideFirstHP.setText("skip flow signals for homo polymers at start or end of read (including HP of size 1)");
        this.hideFirstHP.setToolTipText("discards flow signals from HP at beginning or end of reads (including HP of size 1), in order to not skew the results due to short reads");
        this.hideFirstHP.setSelected(true);
        this.hideFirstHP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.showJunctionTrackCBActionPerformed(e2);
                PreferencesEditor.this.hideFirstHPActionPerformed(e2);
            }
        });
        this.panel6.add(this.hideFirstHP);
        this.hideFirstHP.setBounds(new Rectangle(new Point(5, 25), this.hideFirstHP.getPreferredSize()));
        this.binSizeText.setToolTipText("The size of the bins by which the data in the chart is grouped. Small bin size means small granularity, large bin size means smoother chart");
        this.binSizeText.setText("15");
        this.binSizeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.junctionFlankingTextFieldActionPerformed(e2);
                PreferencesEditor.this.binSizeTextActionPerformed(e2);
                PreferencesEditor.this.binSizeTextActionPerformed(e2);
            }
        });
        this.binSizeText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                PreferencesEditor.this.junctionFlankingTextFieldFocusLost(e2);
                PreferencesEditor.this.binSizeTextFocusLost(e2);
            }
        });
        this.panel6.add(this.binSizeText);
        this.binSizeText.setBounds(135, 55, 95, 25);
        this.label28.setText("Bin size in chart:");
        this.panel6.add(this.label28);
        this.label28.setBounds(10, 55, 125, this.label28.getPreferredSize().height);
        this.label29.setText("Default chart type:");
        this.panel6.add(this.label29);
        this.label29.setBounds(new Rectangle(new Point(10, 90), this.label29.getPreferredSize()));
        this.radioLine.setText("line chart");
        this.radioLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.radioButton1ActionPerformed(e2);
                PreferencesEditor.this.radioLineActionPerformed(e2);
            }
        });
        this.panel6.add(this.radioLine);
        this.radioLine.setBounds(new Rectangle(new Point(135, 90), this.radioLine.getPreferredSize()));
        this.radioArea.setText("area chart");
        this.radioArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.radioAreaActionPerformed(e2);
            }
        });
        this.panel6.add(this.radioArea);
        this.radioArea.setBounds(new Rectangle(new Point(135, 115), this.radioArea.getPreferredSize()));
        this.radioBar.setText("bar chart");
        this.radioBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.radioBarActionPerformed(e2);
            }
        });
        this.panel6.add(this.radioBar);
        this.radioBar.setBounds(new Rectangle(new Point(135, 140), this.radioBar.getPreferredSize()));
        this.radioStacked.setText("(stacked bar chart)");
        this.radioStacked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.radioStackedActionPerformed(e2);
            }
        });
        this.panel6.add(this.radioStacked);
        this.radioStacked.setBounds(new Rectangle(new Point(135, 165), this.radioStacked.getPreferredSize()));
        preferredSize = new Dimension();
        for (int i23 = 0; i23 < this.panel6.getComponentCount(); ++i23) {
            bounds = this.panel6.getComponent(i23).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel6.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel6.setMinimumSize(preferredSize);
        this.panel6.setPreferredSize(preferredSize);
        this.ionTorrentPanel.add(this.panel6);
        this.panel7.setBorder(new TitledBorder("Server settings"));
        this.panel7.setLayout(null);
        this.label30.setText("Default Ion Torrent Server:");
        this.panel7.add(this.label30);
        this.label30.setBounds(new Rectangle(new Point(15, 25), this.label30.getPreferredSize()));
        this.textServer.setText("ioneast.ite");
        this.textServer.setToolTipText("Used to launch other applications (such as Torrent Scout Light)");
        this.textServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.textServerActionPerformed(e2);
            }
        });
        this.panel7.add(this.textServer);
        this.textServer.setBounds(220, 20, 475, this.textServer.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i24 = 0; i24 < this.panel7.getComponentCount(); ++i24) {
            bounds = this.panel7.getComponent(i24).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.panel7.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel7.setMinimumSize(preferredSize);
        this.panel7.setPreferredSize(preferredSize);
        this.ionTorrentPanel.add(this.panel7);
        this.tabbedPane.addTab("IonTorrent", this.ionTorrentPanel);
        contentPane.add((Component)this.tabbedPane, "Center");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.okButtonActionPerformed(e2);
            }
        });
        this.okCancelButtonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PreferencesEditor.this.cancelButtonActionPerformed(e2);
            }
        });
        this.okCancelButtonPanel.add(this.cancelButton);
        contentPane.add((Component)this.okCancelButtonPanel, "South");
        this.setSize(830, 720);
        this.setLocationRelativeTo(this.getOwner());
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.expMapToGeneCB);
        buttonGroup1.add(this.expMapToLociCB);
        buttonGroup1.add(this.radioLine);
        buttonGroup1.add(this.radioArea);
        buttonGroup1.add(this.radioBar);
        buttonGroup1.add(this.radioStacked);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.inputValidated) {
            this.checkForProbeChanges();
            lastSelectedIndex = this.tabbedPane.getSelectedIndex();
            this.prefMgr.putAll(this.updatedPreferenceMap);
            if (this.updatedPreferenceMap.containsKey("PORT_ENABLED") || this.updatedPreferenceMap.containsKey("PORT_NUMBER")) {
                CommandListener.halt();
                if (this.enablePortCB.isSelected()) {
                    int port = Integer.parseInt(this.updatedPreferenceMap.get("PORT_NUMBER"));
                    CommandListener.start(port);
                }
            }
            this.checkForSAMChanges();
            if (this.updateOverlays) {
                IGV.getInstance().resetOverlayTracks();
            }
            if (this.proxySettingsChanged) {
                HttpUtils.getInstance().updateProxySettings();
            }
            if (this.newIGVDirectory != null) {
                this.moveIGVDirectory();
            }
            if (this.tooltipSettingsChanged) {
                Main.updateTooltipSettings();
            }
            this.updatedPreferenceMap.clear();
            IGV.getInstance().doRefresh();
            this.setVisible(false);
        } else {
            this.resetValidation();
        }
    }

    private void moveIGVDirectory() {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                PreferencesEditor.this.setCursor(Cursor.getPredefinedCursor(3));
                return DirectoryManager.moveIGVDirectory(PreferencesEditor.this.newIGVDirectory);
            }

            @Override
            protected void done() {
                PreferencesEditor.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.execute();
        try {
            Boolean success = (Boolean)worker.get(30L, TimeUnit.SECONDS);
            if (success == Boolean.TRUE) {
                MessageUtils.showMessage("<html>The IGV directory has been successfully moved to: " + this.newIGVDirectory.getAbsolutePath() + "<br>Some files might need to be manually removed from the previous directory." + "<br/><b><i>It is recommended that you restart IGV.");
            }
        }
        catch (Exception ex) {
            MessageUtils.showMessage("<html>Unexpected error occurred while moving IGV directory:  " + this.newIGVDirectory.getAbsolutePath() + " " + ex.getMessage() + "<br/><b><i>It is recommended that you restart IGV.");
        }
    }

    private void fontChangeButtonActionPerformed(ActionEvent e2) {
        Font font;
        Font defaultFont = FontManager.getDefaultFont();
        FontChooser chooser = new FontChooser((Dialog)this, defaultFont);
        chooser.setModal(true);
        chooser.setVisible(true);
        if (!chooser.isCanceled() && (font = chooser.getSelectedFont()) != null) {
            this.prefMgr.put("DEFAULT_FONT_FAMILY", font.getFamily());
            this.prefMgr.put("DEFAULT_FONT_SIZE", String.valueOf(font.getSize()));
            int attrs = 0;
            if (font.isBold()) {
                attrs = 1;
            }
            if (font.isItalic()) {
                attrs |= 2;
            }
            this.prefMgr.put("DEFAULT_FONT_ATTRIBUTE", String.valueOf(attrs));
            FontManager.updateDefaultFont();
            this.updateFontField();
            IGV.getInstance().repaint();
        }
    }

    private void expMapToLociCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("PROBE_MAPPING_KEY", String.valueOf(this.expMapToGeneCB.isSelected()));
    }

    private void clearGenomeCacheButtonActionPerformed(ActionEvent evt) {
        GenomeManager.getInstance().clearGenomeCache();
        JOptionPane.showMessageDialog(this, "<html>Cached genomes have been removed.");
    }

    private void editServerPropertiesCBActionPerformed(ActionEvent evt) {
        boolean edit = this.editServerPropertiesCB.isSelected();
        this.dataServerURLTextField.setEnabled(edit);
        this.genomeServerURLTextField.setEnabled(edit);
    }

    private void dataServerURLTextFieldFocusLost(FocusEvent evt) {
        String attributeName = this.dataServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("MASTER_RESOURCE_FILE_KEY", attributeName);
    }

    private void igvDirectoryButtonActionPerformed(ActionEvent e2) {
        File igvDirectory = DirectoryManager.getIgvDirectory();
        File newDirectory = FileDialogUtils.chooseDirectory("Select IGV directory", DirectoryManager.getUserDirectory());
        if (newDirectory != null && !newDirectory.equals(igvDirectory.getParentFile())) {
            this.newIGVDirectory = new File(newDirectory, "igv");
            this.igvDirectoryField.setText(this.newIGVDirectory.getAbsolutePath());
        }
    }

    private void dataServerURLTextFieldActionPerformed(ActionEvent evt) {
        String attributeName = this.dataServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("MASTER_RESOURCE_FILE_KEY", attributeName);
    }

    private void genomeServerURLTextFieldFocusLost(FocusEvent evt) {
        String attributeName = this.genomeServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("IGV.genome.sequence.dir", attributeName);
    }

    private void genomeServerURLTextFieldActionPerformed(ActionEvent evt) {
        String attributeName = this.genomeServerURLTextField.getText().trim();
        this.updatedPreferenceMap.put("IGV.genome.sequence.dir", attributeName);
    }

    private void expandIconCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SHOW_EXPAND_ICON", String.valueOf(this.expandIconCB.isSelected()));
    }

    private void normalizeCoverageCBFocusLost(FocusEvent e2) {
    }

    private void showJunctionTrackCBActionPerformed(ActionEvent evt) {
        boolean junctionTrackEnabled = this.showJunctionTrackCB.isSelected();
        this.updatedPreferenceMap.put("SAM.SHOW_JUNCTION_TRACK", String.valueOf(junctionTrackEnabled));
        this.junctionFlankingTextField.setEnabled(junctionTrackEnabled);
        this.junctionCoverageTextField.setEnabled(junctionTrackEnabled);
        this.showJunctionFlankingRegionsCB.setEnabled(junctionTrackEnabled);
    }

    private void showJunctionFlankingRegionsCBActionPerformed(ActionEvent evt) {
        boolean junctionFlankingRegionsEnabled = this.showJunctionFlankingRegionsCB.isSelected();
        this.updatedPreferenceMap.put("SAM.SHOW_JUNCTION_FLANKINGREGIONS", String.valueOf(junctionFlankingRegionsEnabled));
    }

    private void junctionFlankingTextFieldFocusLost(FocusEvent e2) {
        this.junctionFlankingTextFieldActionPerformed(null);
    }

    private void junctionFlankingTextFieldActionPerformed(ActionEvent e2) {
        boolean valid = false;
        String flankingWidth = this.junctionFlankingTextField.getText().trim();
        try {
            int val = Integer.parseInt(flankingWidth);
            if (val >= 0) {
                valid = true;
                this.updatedPreferenceMap.put("SAM.JUNCTION_MIN_FLANKING_WIDTH", flankingWidth);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid && e2 != null) {
            this.junctionFlankingTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_FLANKING_WIDTH"));
            MessageUtils.showMessage("Flanking width must be a positive integer.");
        }
    }

    private void junctionCoverageTextFieldActionPerformed(ActionEvent e2) {
        this.junctionCoverageTextFieldFocusLost(null);
    }

    private void junctionCoverageTextFieldFocusLost(FocusEvent e2) {
        boolean valid = false;
        String minCoverage = this.junctionCoverageTextField.getText().trim();
        try {
            int val = Integer.parseInt(minCoverage);
            if (val >= 0) {
                valid = true;
                this.updatedPreferenceMap.put("SAM.JUNCTION_MIN_COVERAGE", minCoverage);
            }
        }
        catch (NumberFormatException numberFormatException) {
            valid = false;
        }
        if (!valid && e2 != null) {
            this.junctionCoverageTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_COVERAGE"));
            MessageUtils.showMessage("Minimum junction coverage must be a positive integer.");
        }
    }

    private void insertSizeThresholdFieldFocusLost(FocusEvent evt) {
        this.insertSizeThresholdFieldActionPerformed(null);
    }

    private void insertSizeThresholdFieldActionPerformed(ActionEvent evt) {
        String insertThreshold = this.insertSizeThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            this.updatedPreferenceMap.put("SAM.INSERT_SIZE_THRESHOLD", insertThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void insertSizeMinThresholdFieldFocusLost(FocusEvent e2) {
        this.insertSizeMinThresholdFieldActionPerformed(null);
    }

    private void insertSizeMinThresholdFieldActionPerformed(ActionEvent e2) {
        String insertThreshold = this.insertSizeMinThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            this.updatedPreferenceMap.put("SAM.MIN_INSERT_SIZE_THRESHOLD", insertThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void mappingQualityThresholdFieldFocusLost(FocusEvent evt) {
        this.mappingQualityThresholdFieldActionPerformed(null);
    }

    private void mappingQualityThresholdFieldActionPerformed(ActionEvent evt) {
        String qualityThreshold = this.mappingQualityThresholdField.getText().trim();
        try {
            Integer.parseInt(qualityThreshold);
            this.updatedPreferenceMap.put("SAM.QUALITY_THRESHOLD", qualityThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }

    private void samFlagInsertionsCBActionPerformed(ActionEvent e2) {
        boolean flagInsertions = this.samFlagInsertionsCB.isSelected();
        this.updatedPreferenceMap.put("SAM.FLAG_LARGE_INSERTIONS", String.valueOf(flagInsertions));
        this.samFlagInsertionsThresholdField.setEnabled(flagInsertions);
    }

    private void samFlagInsertionsThresholdFieldActionPerformed(ActionEvent e2) {
        String insertionThreshold = this.samFlagInsertionsThresholdField.getText().trim();
        try {
            int tmp = Integer.parseInt(insertionThreshold);
            if (tmp <= 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Insertion threshold must be a positive integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.LARGE_INSERTIONS_THRESOLD", insertionThreshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Insertion threshold must be a positive integer.");
        }
    }

    private void samFlagInsertionsThresholdFieldFocusLost(FocusEvent e2) {
        this.samFlagInsertionsThresholdFieldActionPerformed(null);
    }

    private void downsampleReadsCBActionPerformed(ActionEvent e2) {
        boolean downsample = this.downsampleReadsCB.isSelected();
        this.updatedPreferenceMap.put("SAM.DOWNSAMPLE_READS", String.valueOf(downsample));
        this.samSamplingWindowField.setEnabled(downsample);
        this.samDownsampleCountField.setEnabled(downsample);
    }

    private void samSamplingWindowFieldFocusLost(FocusEvent e2) {
        this.samSamplingWindowFieldActionPerformed(null);
    }

    private void samSamplingWindowFieldActionPerformed(ActionEvent e2) {
        String samplingWindowString = this.samSamplingWindowField.getText().trim();
        try {
            int samplingWindow = Integer.parseInt(samplingWindowString);
            if (samplingWindow <= 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Down-sampling window must be a positive integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.SAMPLING_WINDOW", samplingWindowString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Down-sampling window  must be a positive integer.");
        }
    }

    private void samDownsampleCountFieldFocusLost(FocusEvent evt) {
        this.samDownsampleCountFieldActionPerformed(null);
    }

    private void samDownsampleCountFieldActionPerformed(ActionEvent evt) {
        String maxLevelString = this.samDownsampleCountField.getText().trim();
        try {
            int maxLevel = Integer.parseInt(maxLevelString);
            if (maxLevel <= 0) {
                this.inputValidated = false;
                MessageUtils.showMessage("Down-sampling read count must be a positive integer.");
            } else {
                this.updatedPreferenceMap.put("SAM.MAX_LEVELS", maxLevelString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Down-sampling read count must be a positive integer.");
        }
    }

    private void samShadeMismatchedBaseCBActionPerformed(ActionEvent evt) {
        if (this.samShadeMismatchedBaseCB.isSelected()) {
            this.updatedPreferenceMap.put("SAM.SHADE_BASE_QUALITY", AlignmentTrack.ShadeBasesOption.QUALITY.toString());
            this.samMinBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
            this.samMaxBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
        } else {
            PreferenceManager prefMgr = PreferenceManager.getInstance();
            if (AlignmentTrack.ShadeBasesOption.QUALITY == CollUtils.valueOf(AlignmentTrack.ShadeBasesOption.class, prefMgr.get("SAM.SHADE_BASE_QUALITY"), AlignmentTrack.ShadeBasesOption.QUALITY)) {
                this.updatedPreferenceMap.put("SAM.SHADE_BASE_QUALITY", AlignmentTrack.ShadeBasesOption.NONE.toString());
                this.samMinBaseQualityField.setEnabled(false);
                this.samMaxBaseQualityField.setEnabled(false);
            }
        }
    }

    private void showCenterLineCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SAM.SHOW_CENTER_LINE", String.valueOf(this.showCenterLineCB.isSelected()));
    }

    private void zeroQualityAlignmentCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SAM.FLAG_ZERO_QUALITY", String.valueOf(this.zeroQualityAlignmentCB.isSelected()));
    }

    private void genomeUpdateCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("AUTO_UPDATE_GENOMES", String.valueOf(this.genomeUpdateCB.isSelected()));
    }

    private void samFlagUnmappedPairCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.FLAG_UNMAPPED_PAIR", String.valueOf(this.samFlagUnmappedPairCB.isSelected()));
    }

    private void samShowDuplicatesCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.SHOW_DUPLICATES", String.valueOf(!this.samFilterDuplicatesCB.isSelected()));
    }

    private void showSoftClippedCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SAM.SHOW_SOFT_CLIPPED", String.valueOf(this.showSoftClippedCB.isSelected()));
    }

    private void isizeComputeCBActionPerformed(ActionEvent e2) {
        boolean selected = this.isizeComputeCB.isSelected();
        this.updatedPreferenceMap.put("SAM.COMPUTE_ISIZES", String.valueOf(selected));
        this.insertSizeThresholdField.setEnabled(!selected);
        this.insertSizeMinThresholdField.setEnabled(!selected);
        this.insertSizeMinPercentileField.setEnabled(selected);
        this.insertSizeMaxPercentileField.setEnabled(selected);
    }

    public void selectTab(String tabname) {
        if (tabname == null) {
            return;
        }
        for (int i2 = 0; i2 < this.tabbedPane.getTabCount(); ++i2) {
            if (!this.tabbedPane.getTitleAt(i2).equalsIgnoreCase(tabname)) continue;
            this.tabbedPane.setSelectedIndex(i2);
            return;
        }
    }

    private void insertSizeMinPercentileFieldFocusLost(FocusEvent e2) {
        this.insertSizeMinPercentileFieldActionPerformed(null);
    }

    private void insertSizeMinPercentileFieldActionPerformed(ActionEvent e2) {
        String valueString = this.insertSizeMinPercentileField.getText().trim();
        try {
            Double.parseDouble(valueString);
            this.updatedPreferenceMap.put("SAM.MIN_ISIZE_MIN_PERCENTILE", valueString);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Minimum insert size percentile must be a number.");
        }
    }

    private void insertSizeMaxPercentileFieldFocusLost(FocusEvent e2) {
        this.insertSizeMaxPercentileFieldActionPerformed(null);
    }

    private void insertSizeMaxPercentileFieldActionPerformed(ActionEvent e2) {
        String valueString = this.insertSizeMaxPercentileField.getText().trim();
        try {
            Double.parseDouble(valueString);
            this.updatedPreferenceMap.put("SAM.ISIZE_MAX_PERCENTILE", valueString);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Maximum insert size percentile must be a number.");
        }
    }

    private void samMaxWindowSizeFieldFocusLost(FocusEvent evt) {
        this.samMaxWindowSizeFieldActionPerformed(null);
    }

    private void samMaxWindowSizeFieldActionPerformed(ActionEvent evt) {
        String maxSAMWindowSize = String.valueOf(this.samMaxWindowSizeField.getText());
        try {
            Float.parseFloat(maxSAMWindowSize);
            this.updatedPreferenceMap.put("SAM.MAX_VISIBLE_RANGE", maxSAMWindowSize);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number.");
        }
    }

    private void seqResolutionThresholdActionPerformed(ActionEvent e2) {
        this.samMaxWindowSizeFieldFocusLost(null);
    }

    private void seqResolutionThresholdFocusLost(FocusEvent e2) {
        String seqResolutionSize = String.valueOf(this.seqResolutionThreshold.getText());
        try {
            float value = Float.parseFloat(seqResolutionSize.replace(",", ""));
            if (value < 1.0f || value > 10000.0f) {
                MessageUtils.showMessage("Visibility range must be a number between 1 and 10000.");
            } else {
                this.updatedPreferenceMap.put("MAX_SEQUENCE_RESOLUTION", seqResolutionSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number between 1 and 10000.");
        }
    }

    private void chartDrawTrackNameCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_TRACK_NAME", String.valueOf(this.chartDrawTrackNameCB.isSelected()));
    }

    private void autoscaleCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.AUTOSCALE", String.valueOf(this.autoscaleCB.isSelected()));
    }

    private void colorBordersCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.COLOR_BORDERS", String.valueOf(this.colorBordersCB.isSelected()));
    }

    private void bottomBorderCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_BOTTOM_BORDER", String.valueOf(this.bottomBorderCB.isSelected()));
    }

    private void topBorderCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_TOP_BORDER", String.valueOf(this.topBorderCB.isSelected()));
    }

    private void showAllHeatmapFeauresCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("CHART.SHOW_ALL_HEATMAP", String.valueOf(this.showAllHeatmapFeauresCB.isSelected()));
    }

    private void chooseMutationColorsButtonActionPerformed(ActionEvent e2) {
        PaletteColorTable ct = PreferenceManager.getInstance().getMutationColorScheme();
        ColorMapEditor editor = new ColorMapEditor(IGV.getMainFrame(), ct.getColorMap());
        editor.setVisible(true);
        Map<String, Color> changedColors = editor.getChangedColors();
        if (!changedColors.isEmpty()) {
            for (Map.Entry<String, Color> entry : changedColors.entrySet()) {
                ct.getColorMap().put(entry.getKey(), entry.getValue());
            }
            String mapString = ct.getMapAsString();
            PreferenceManager.getInstance().put("MUTATION_COLOR_TABLE", mapString);
        }
    }

    private void colorMutationsCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("COVER_OVERLAY_KEY", String.valueOf(this.colorCodeMutationsCB.isSelected()));
    }

    private void showOrphanedMutationsCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SHOW_ORPHANED_MUTATIONS", String.valueOf(this.showOrphanedMutationsCB.isSelected()));
    }

    private void overlayTrackCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("OVERLAY_TRACKS_KEY", String.valueOf(this.overlayTrackCB.isSelected()));
        this.overlayAttributeTextField.setEnabled(this.overlayTrackCB.isSelected());
        this.showOrphanedMutationsCB.setEnabled(this.overlayTrackCB.isSelected());
        this.updateOverlays = true;
    }

    private void overlayAttributeTextFieldFocusLost(FocusEvent evt) {
        String attributeName = String.valueOf(this.overlayAttributeTextField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        this.updatedPreferenceMap.put("OVERLAY_ATTRIBUTE_KEY", attributeName);
        this.updateOverlays = true;
    }

    private void overlayAttributeTextFieldActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("OVERLAY_ATTRIBUTE_KEY", String.valueOf(this.overlayAttributeTextField.getText()));
        this.updateOverlays = true;
    }

    private void defaultTrackHeightFieldFocusLost(FocusEvent evt) {
        String defaultTrackHeight = String.valueOf(this.defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            this.updatedPreferenceMap.put("IGV.track.height", defaultTrackHeight);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }

    private void defaultTrackHeightFieldActionPerformed(ActionEvent evt) {
        String defaultTrackHeight = String.valueOf(this.defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            this.updatedPreferenceMap.put("IGV.track.height", defaultTrackHeight);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }

    private void trackNameAttributeFieldFocusLost(FocusEvent evt) {
        String attributeName = String.valueOf(this.trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        this.updatedPreferenceMap.put("TRACK_ATTRIBUTE_NAME_KEY", attributeName);
    }

    private void trackNameAttributeFieldActionPerformed(ActionEvent evt) {
        String attributeName = String.valueOf(this.trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        this.updatedPreferenceMap.put("TRACK_ATTRIBUTE_NAME_KEY", attributeName);
    }

    private void defaultChartTrackHeightFieldFocusLost(FocusEvent evt) {
        this.defaultChartTrackHeightFieldActionPerformed(null);
    }

    private void defaultChartTrackHeightFieldActionPerformed(ActionEvent evt) {
        String defaultTrackHeight = String.valueOf(this.defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            this.updatedPreferenceMap.put("IGV.chart.track.height", defaultTrackHeight);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }

    private void geneListFlankingFieldFocusLost(FocusEvent e2) {
        this.geneListFlankingFieldActionPerformed(null);
    }

    private void geneListFlankingFieldActionPerformed(ActionEvent e2) {
        String flankingRegion = String.valueOf(this.geneListFlankingField.getText());
        try {
            Integer.parseInt(flankingRegion);
            this.updatedPreferenceMap.put("FLAKING_REGIONS", flankingRegion);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Flanking region must be an integer number.");
        }
    }

    private void showAttributesDisplayCheckBoxActionPerformed(ActionEvent evt) {
        boolean state = ((JCheckBox)evt.getSource()).isSelected();
        this.updatedPreferenceMap.put("IGV.track.show.attribute.views", String.valueOf(state));
        IGV.getInstance().doShowAttributeDisplay(state);
    }

    private void combinePanelsCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("IGV.single.track.pane", String.valueOf(this.combinePanelsCB.isSelected()));
    }

    private void showDefaultTrackAttributesCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SHOW_DEFAULT_TRACK_ATTRIBUTES", String.valueOf(this.showDefaultTrackAttributesCB.isSelected()));
    }

    private void showRegionBoundariesCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SHOW_REGION_BARS", String.valueOf(this.showRegionBoundariesCB.isSelected()));
    }

    private void filterVendorFailedReadsCBActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("SAM.FILTER_FAILED_READS", String.valueOf(this.filterFailedReadsCB.isSelected()));
    }

    private void samMinBaseQualityFieldActionPerformed(ActionEvent evt) {
        String baseQuality = this.samMinBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            this.updatedPreferenceMap.put("SAM.BASE_QUALITY_MIN", baseQuality);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }
    }

    private void samMinBaseQualityFieldFocusLost(FocusEvent evt) {
        this.samMinBaseQualityFieldActionPerformed(null);
    }

    private void samMaxBaseQualityFieldActionPerformed(ActionEvent evt) {
        String baseQuality = this.samMaxBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            this.updatedPreferenceMap.put("SAM.BASE_QUALITY_MAX", baseQuality);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }
    }

    private void samMaxBaseQualityFieldFocusLost(FocusEvent evt) {
        this.samMaxBaseQualityFieldActionPerformed(null);
    }

    private void expMapToGeneCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("PROBE_MAPPING_KEY", String.valueOf(this.expMapToGeneCB.isSelected()));
    }

    private void labelYAxisCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.DRAW_AXIS", String.valueOf(this.labelYAxisCB.isSelected()));
    }

    private void showCovTrackCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.SHOW_COV_TRACK", String.valueOf(this.showCovTrackCB.isSelected()));
    }

    private void filterCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.FILTER_ALIGNMENTS", String.valueOf(this.filterCB.isSelected()));
        this.filterURL.setEnabled(this.filterCB.isSelected());
    }

    private void filterURLActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SAM.FILTER_URL", String.valueOf(this.filterURL.getText()));
    }

    private void filterURLFocusLost(FocusEvent evt) {
        this.filterURLActionPerformed(null);
    }

    private void portFieldActionPerformed(ActionEvent evt) {
        String portString = this.portField.getText().trim();
        try {
            Integer.parseInt(portString);
            this.updatedPreferenceMap.put("PORT_NUMBER", portString);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Port must be an integer.");
        }
    }

    private void portFieldFocusLost(FocusEvent evt) {
        this.portFieldActionPerformed(null);
    }

    private void enablePortCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("PORT_ENABLED", String.valueOf(this.enablePortCB.isSelected()));
        this.portField.setEnabled(this.enablePortCB.isSelected());
    }

    private void expandCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("EXPAND_FEATURE_TRACKS", String.valueOf(this.expandCB.isSelected()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        this.genomeServerURLTextField.setEnabled(true);
        this.genomeServerURLTextField.setText("http://igv.broadinstitute.org/genomes/genomes.txt");
        this.updatedPreferenceMap.put("IGV.genome.sequence.dir", null);
        this.dataServerURLTextField.setEnabled(true);
        this.dataServerURLTextField.setText("http://www.broadinstitute.org/igvdata/$$_dataServerRegistry.txt");
        this.updatedPreferenceMap.put("MASTER_RESOURCE_FILE_KEY", null);
    }

    private void searchZoomCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("SEARCH_ZOOM", String.valueOf(this.searchZoomCB.isSelected()));
    }

    private void showDatarangeCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("CHART.SHOW_DATA_RANGE", String.valueOf(this.showDatarangeCB.isSelected()));
    }

    private void showDatarangeCBFocusLost(FocusEvent evt) {
        this.showDatarangeCBActionPerformed(null);
    }

    private void snpThresholdFieldActionPerformed(ActionEvent evt) {
        String snpThreshold = this.snpThresholdField.getText().trim();
        try {
            Double.parseDouble(snpThreshold);
            this.updatedPreferenceMap.put("SAM.ALLELE_THRESHOLD", snpThreshold);
        }
        catch (NumberFormatException numberFormatException) {
            this.inputValidated = false;
            MessageUtils.showMessage("Allele frequency threshold must be a number.");
        }
    }

    private void snpThresholdFieldFocusLost(FocusEvent evt) {
        this.snpThresholdFieldActionPerformed(null);
    }

    private void normalizeCoverageCBActionPerformed(ActionEvent evt) {
        this.updatedPreferenceMap.put("NORMALIZE_COVERAGE", String.valueOf(this.normalizeCoverageCB.isSelected()));
        this.portField.setEnabled(this.enablePortCB.isSelected());
    }

    private void clearProxySettingsButtonActionPerformed(ActionEvent e2) {
        if (MessageUtils.confirm("This will immediately clear all proxy settings.  Are you sure?")) {
            this.proxyHostField.setText("");
            this.proxyPortField.setText("");
            this.proxyUsernameField.setText("");
            this.proxyPasswordField.setText("");
            this.proxyTypeCB.setSelectedIndex(0);
            this.useProxyCB.setSelected(false);
            PreferenceManager.getInstance().clearProxySettings();
        }
    }

    private void useProxyCBActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        boolean useProxy = this.useProxyCB.isSelected();
        boolean authenticateProxy = this.authenticateProxyCB.isSelected();
        this.portField.setEnabled(this.enablePortCB.isSelected());
        this.updateProxyState(useProxy, authenticateProxy);
        this.updatedPreferenceMap.put("PROXY.USE", String.valueOf(useProxy));
    }

    private void authenticateProxyCBActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        boolean useProxy = this.useProxyCB.isSelected();
        boolean authenticateProxy = this.authenticateProxyCB.isSelected();
        this.portField.setEnabled(this.enablePortCB.isSelected());
        this.updateProxyState(useProxy, authenticateProxy);
        this.updatedPreferenceMap.put("PROXY.AUTHENTICATE", String.valueOf(authenticateProxy));
        this.proxyUsernameField.setEnabled(authenticateProxy);
        this.proxyPasswordField.setEnabled(authenticateProxy);
    }

    private void proxyHostFieldFocusLost(FocusEvent evt) {
        this.proxyHostFieldActionPerformed(null);
    }

    private void proxyHostFieldActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        this.updatedPreferenceMap.put("PROXY.HOST", this.proxyHostField.getText());
    }

    private void proxyPortFieldFocusLost(FocusEvent evt) {
        this.proxyPortFieldActionPerformed(null);
    }

    private void proxyPortFieldActionPerformed(ActionEvent evt) {
        try {
            Integer.parseInt(this.proxyPortField.getText());
            this.proxySettingsChanged = true;
            this.updatedPreferenceMap.put("PROXY.PORT", this.proxyPortField.getText());
        }
        catch (NumberFormatException e2) {
            MessageUtils.showMessage("Proxy port must be an integer.");
        }
    }

    private void proxyTypeCBActionPerformed(ActionEvent e2) {
        this.proxySettingsChanged = true;
        String proxyTypeString = this.proxyTypeCB.getSelectedItem().toString();
        this.updatedPreferenceMap.put("PROXY.TYPE", proxyTypeString);
    }

    private void proxyUsernameFieldFocusLost(FocusEvent evt) {
        this.proxyUsernameFieldActionPerformed(null);
    }

    private void proxyUsernameFieldActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        String user = this.proxyUsernameField.getText();
        this.updatedPreferenceMap.put("PROXY.USERNAME", user);
    }

    private void proxyPasswordFieldFocusLost(FocusEvent evt) {
        this.proxyPasswordFieldActionPerformed(null);
    }

    private void proxyPasswordFieldActionPerformed(ActionEvent evt) {
        this.proxySettingsChanged = true;
        String pw = new String(this.proxyPasswordField.getPassword());
        String pwEncoded = Utilities.base64Encode(pw);
        this.updatedPreferenceMap.put("PROXY.PW", pwEncoded);
    }

    private void updateProxyState(boolean useProxy, boolean authenticateProxy) {
        this.proxyHostField.setEnabled(useProxy);
        this.proxyPortField.setEnabled(useProxy);
        this.proxyUsernameField.setEnabled(useProxy && authenticateProxy);
        this.proxyPasswordField.setEnabled(useProxy && authenticateProxy);
    }

    private void resetValidation() {
        this.inputValidated = true;
    }

    private void dbHostFieldFocusLost(FocusEvent e2) {
        this.dbHostFieldActionPerformed(null);
    }

    private void dbHostFieldActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("DB_HOST", this.dbHostField.getText());
    }

    private void dbNameFieldFocusLost(FocusEvent e2) {
        this.dbNameFieldActionPerformed(null);
    }

    private void dbNameFieldActionPerformed(ActionEvent e2) {
        this.updatedPreferenceMap.put("DB_NAME", this.dbNameField.getText());
    }

    private void dbPortFieldActionPerformed(ActionEvent e2) {
        this.dbPortFieldFocusLost(null);
    }

    private void dbPortFieldFocusLost(FocusEvent e2) {
        String portText = this.dbPortField.getText().trim();
        if (portText.length() == 0) {
            this.updatedPreferenceMap.put("DB_PORT", "-1");
        } else {
            try {
                Integer.parseInt(portText);
                this.updatedPreferenceMap.put("DB_PORT", portText);
            }
            catch (NumberFormatException e1) {
                this.updatedPreferenceMap.put("DB_PORT", "-1");
            }
        }
    }

    private void probeMappingBrowseButtonActionPerformed(ActionEvent e2) {
        File f2 = FileDialogUtils.chooseFile("Probe mapping file (BED format)");
        if (f2 != null) {
            this.probeMappingFileTextField.setText(f2.getAbsolutePath());
            this.updatedPreferenceMap.put("PROBE_MAPPING_FILE", f2.getAbsolutePath());
        }
    }

    private void useProbeMappingCBActionPerformed(ActionEvent e2) {
        boolean isSelected = this.useProbeMappingCB.isSelected();
        this.updatedPreferenceMap.put("USE_PROBE_MAPPING_FILE", String.valueOf(isSelected));
        this.updateProbeMappingOptions(isSelected);
    }

    private void updateProbeMappingOptions(boolean isSelected) {
        this.probeMappingFileTextField.setEnabled(isSelected);
        this.probeMappingBrowseButton.setEnabled(isSelected);
        this.expMapToGeneCB.setEnabled(!isSelected);
        this.expMapToLociCB.setEnabled(!isSelected);
    }

    private void probeMappingFileTextFieldFocusLost(FocusEvent e2) {
        this.probeMappingFileTextFieldActionPerformed(null);
    }

    private void probeMappingFileTextFieldActionPerformed(ActionEvent e2) {
        String name = this.probeMappingFileTextField.getText();
        if (name != null) {
            name = name.trim();
            this.updatedPreferenceMap.put("PROBE_MAPPING_FILE", name);
        }
    }

    private void toolTipInitialDelayFieldFocusLost(FocusEvent e2) {
        this.toolTipInitialDelayFieldActionPerformed(null);
    }

    private void toolTipInitialDelayFieldActionPerformed(ActionEvent e2) {
        String ttText = this.toolTipInitialDelayField.getText();
        try {
            Integer.parseInt(ttText);
            this.updatedPreferenceMap.put("TOOLTIP.INITIAL_DELAY", ttText);
            this.tooltipSettingsChanged = true;
        }
        catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip initial delay must be a number.");
        }
    }

    private void tooltipReshowDelayFieldFocusLost(FocusEvent e2) {
        this.tooltipReshowDelayFieldActionPerformed(null);
    }

    private void tooltipReshowDelayFieldActionPerformed(ActionEvent e2) {
        String ttText = this.tooltipReshowDelayField.getText();
        try {
            Integer.parseInt(ttText);
            this.updatedPreferenceMap.put("TOOLTIP.RESHOW_DELAY", ttText);
            this.tooltipSettingsChanged = true;
        }
        catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip reshow delay must be a number.");
        }
    }

    private void tooltipDismissDelayFieldFocusLost(FocusEvent e2) {
        this.tooltipDismissDelayFieldActionPerformed(null);
    }

    private void tooltipDismissDelayFieldActionPerformed(ActionEvent e2) {
        String ttText = this.tooltipDismissDelayField.getText();
        try {
            Integer.parseInt(ttText);
            this.updatedPreferenceMap.put("TOOLTIP.DISMISS_DELAY", ttText);
            this.tooltipSettingsChanged = true;
        }
        catch (NumberFormatException e1) {
            MessageUtils.showMessage("Tooltip dismiss delay must be a number.");
        }
    }

    private void initValues() {
        File igvDirectory;
        String server;
        this.combinePanelsCB.setSelected(this.prefMgr.getAsBoolean("IGV.single.track.pane"));
        this.showRegionBoundariesCB.setSelected(this.prefMgr.getAsBoolean("SHOW_REGION_BARS"));
        this.defaultChartTrackHeightField.setText(this.prefMgr.get("IGV.chart.track.height"));
        this.defaultTrackHeightField.setText(this.prefMgr.get("IGV.track.height"));
        this.showOrphanedMutationsCB.setSelected(this.prefMgr.getAsBoolean("SHOW_ORPHANED_MUTATIONS"));
        this.overlayAttributeTextField.setText(this.prefMgr.get("OVERLAY_ATTRIBUTE_KEY"));
        this.overlayTrackCB.setSelected(this.prefMgr.getAsBoolean("OVERLAY_TRACKS_KEY"));
        this.showMissingDataCB.setSelected(this.prefMgr.getAsBoolean("IGV.track.show.missing.data"));
        this.showDefaultTrackAttributesCB.setSelected(this.prefMgr.getAsBoolean("SHOW_DEFAULT_TRACK_ATTRIBUTES"));
        this.colorCodeMutationsCB.setSelected(this.prefMgr.getAsBoolean("COVER_OVERLAY_KEY"));
        this.overlayAttributeTextField.setEnabled(this.overlayTrackCB.isSelected());
        this.showOrphanedMutationsCB.setEnabled(this.overlayTrackCB.isSelected());
        this.seqResolutionThreshold.setText(this.prefMgr.get("MAX_SEQUENCE_RESOLUTION"));
        this.geneListFlankingField.setText(this.prefMgr.get("FLAKING_REGIONS"));
        this.enablePortCB.setSelected(this.prefMgr.getAsBoolean("PORT_ENABLED"));
        this.portField.setText(String.valueOf(this.prefMgr.getAsInt("PORT_NUMBER")));
        this.portField.setEnabled(this.enablePortCB.isSelected());
        this.expandCB.setSelected(this.prefMgr.getAsBoolean("EXPAND_FEATURE_TRACKS"));
        this.searchZoomCB.setSelected(this.prefMgr.getAsBoolean("SEARCH_ZOOM"));
        this.showAttributesDisplayCheckBox.setSelected(this.prefMgr.getAsBoolean("IGV.track.show.attribute.views"));
        this.trackNameAttributeField.setText(this.prefMgr.get("TRACK_ATTRIBUTE_NAME_KEY"));
        this.genomeServerURLTextField.setText(this.prefMgr.getGenomeListURL());
        this.dataServerURLTextField.setText(this.prefMgr.getDataServerURL());
        this.topBorderCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_TOP_BORDER"));
        this.bottomBorderCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_BOTTOM_BORDER"));
        this.colorBordersCB.setSelected(this.prefMgr.getAsBoolean("CHART.COLOR_BORDERS"));
        this.chartDrawTrackNameCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_TRACK_NAME"));
        this.autoscaleCB.setSelected(this.prefMgr.getAsBoolean("CHART.AUTOSCALE"));
        this.showDatarangeCB.setSelected(this.prefMgr.getAsBoolean("CHART.SHOW_DATA_RANGE"));
        this.labelYAxisCB.setSelected(this.prefMgr.getAsBoolean("CHART.DRAW_AXIS"));
        this.showAllHeatmapFeauresCB.setSelected(this.prefMgr.getAsBoolean("CHART.SHOW_ALL_HEATMAP"));
        this.binSizeText.setText(this.prefMgr.get("IONTORRENT.FLOWDIST_BINSIZE"));
        boolean hideHp = this.prefMgr.getAsBoolean("IONTORRENT.FLOWDIST_HIDE_FIRST_HP");
        this.hideFirstHP.setSelected(hideHp);
        String type = PreferenceManager.getInstance().get("IONTORRENT.FLOWDIST_CHARTTYPE");
        if (type == null) {
            type = "LINE";
        }
        if (type != null) {
            if ((type = type.trim().toUpperCase()).equals("LINE")) {
                this.radioLine.setSelected(true);
            } else if (type.equals("AREA")) {
                this.radioArea.setSelected(true);
            } else if (type.equals("BAR")) {
                this.radioBar.setSelected(true);
            } else if (type.equals("STACKED")) {
                this.radioStacked.setSelected(true);
            }
        }
        if ((server = PreferenceManager.getInstance().get("IONTORRENT.SERVER")) != null) {
            this.textServer.setText(server);
        }
        this.samMaxWindowSizeField.setText(this.prefMgr.get("SAM.MAX_VISIBLE_RANGE"));
        this.samSamplingWindowField.setText(this.prefMgr.get("SAM.SAMPLING_WINDOW"));
        this.samDownsampleCountField.setText(this.prefMgr.get("SAM.MAX_LEVELS"));
        boolean downsample = this.prefMgr.getAsBoolean("SAM.DOWNSAMPLE_READS");
        this.downsampleReadsCB.setSelected(downsample);
        this.samSamplingWindowField.setEnabled(downsample);
        this.samDownsampleCountField.setEnabled(downsample);
        this.mappingQualityThresholdField.setText(this.prefMgr.get("SAM.QUALITY_THRESHOLD"));
        this.insertSizeThresholdField.setText(this.prefMgr.get("SAM.INSERT_SIZE_THRESHOLD"));
        this.insertSizeMinThresholdField.setText(this.prefMgr.get("SAM.MIN_INSERT_SIZE_THRESHOLD"));
        this.insertSizeMinPercentileField.setText(this.prefMgr.get("SAM.MIN_ISIZE_MIN_PERCENTILE"));
        this.insertSizeMaxPercentileField.setText(this.prefMgr.get("SAM.ISIZE_MAX_PERCENTILE"));
        boolean isizeComputeSelected = this.prefMgr.getAsBoolean("SAM.COMPUTE_ISIZES");
        this.isizeComputeCB.setSelected(isizeComputeSelected);
        this.insertSizeThresholdField.setEnabled(!isizeComputeSelected);
        this.insertSizeMinThresholdField.setEnabled(!isizeComputeSelected);
        this.insertSizeMinPercentileField.setEnabled(isizeComputeSelected);
        this.insertSizeMaxPercentileField.setEnabled(isizeComputeSelected);
        this.snpThresholdField.setText(String.valueOf(this.prefMgr.getAsFloat("SAM.ALLELE_THRESHOLD")));
        this.samFilterDuplicatesCB.setSelected(!this.prefMgr.getAsBoolean("SAM.SHOW_DUPLICATES"));
        this.filterFailedReadsCB.setSelected(this.prefMgr.getAsBoolean("SAM.FILTER_FAILED_READS"));
        this.filterSecondaryAlignmentsCB.setSelected(this.prefMgr.getAsBoolean("SAM.FILTER_SECONDARY_ALIGNMENTS"));
        this.showSoftClippedCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_SOFT_CLIPPED"));
        this.samFlagUnmappedPairCB.setSelected(this.prefMgr.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR"));
        this.showCenterLineCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_CENTER_LINE"));
        this.samShadeMismatchedBaseCB.setSelected(AlignmentTrack.ShadeBasesOption.QUALITY == CollUtils.valueOf(AlignmentTrack.ShadeBasesOption.class, this.prefMgr.get("SAM.SHADE_BASE_QUALITY"), AlignmentTrack.ShadeBasesOption.QUALITY));
        this.samMinBaseQualityField.setText(String.valueOf(this.prefMgr.getAsInt("SAM.BASE_QUALITY_MIN")));
        this.samMaxBaseQualityField.setText(String.valueOf(this.prefMgr.getAsInt("SAM.BASE_QUALITY_MAX")));
        this.samMinBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
        this.samMaxBaseQualityField.setEnabled(this.samShadeMismatchedBaseCB.isSelected());
        this.showCovTrackCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_COV_TRACK"));
        this.zeroQualityAlignmentCB.setSelected(this.prefMgr.getAsBoolean("SAM.FLAG_ZERO_QUALITY"));
        this.filterCB.setSelected(this.prefMgr.getAsBoolean("SAM.FILTER_ALIGNMENTS"));
        if (this.prefMgr.get("SAM.FILTER_URL") != null) {
            this.filterURL.setText(this.prefMgr.get("SAM.FILTER_URL"));
        }
        boolean junctionTrackEnabled = this.prefMgr.getAsBoolean("SAM.SHOW_JUNCTION_TRACK");
        this.showJunctionTrackCB.setSelected(junctionTrackEnabled);
        this.showJunctionFlankingRegionsCB.setSelected(this.prefMgr.getAsBoolean("SAM.SHOW_JUNCTION_FLANKINGREGIONS"));
        this.showJunctionFlankingRegionsCB.setEnabled(junctionTrackEnabled);
        this.junctionFlankingTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_FLANKING_WIDTH"));
        this.junctionCoverageTextField.setText(this.prefMgr.get("SAM.JUNCTION_MIN_COVERAGE"));
        this.junctionFlankingTextField.setEnabled(junctionTrackEnabled);
        this.junctionCoverageTextField.setEnabled(junctionTrackEnabled);
        this.genomeUpdateCB.setSelected(this.prefMgr.getAsBoolean("AUTO_UPDATE_GENOMES"));
        this.antialiasingCB.setSelected(this.prefMgr.getAsBoolean("ENABLE_ANTIALIASING"));
        boolean mapProbesToGenes = PreferenceManager.getInstance().getAsBoolean("PROBE_MAPPING_KEY");
        this.expMapToGeneCB.setSelected(mapProbesToGenes);
        this.expMapToLociCB.setSelected(!mapProbesToGenes);
        this.probeMappingFileTextField.setText(this.prefMgr.get("PROBE_MAPPING_FILE"));
        boolean useProbeMapping = this.prefMgr.getAsBoolean("USE_PROBE_MAPPING_FILE");
        this.useProbeMappingCB.setSelected(useProbeMapping);
        this.updateProbeMappingOptions(useProbeMapping);
        this.normalizeCoverageCB.setSelected(this.prefMgr.getAsBoolean("NORMALIZE_COVERAGE"));
        this.expandIconCB.setSelected(this.prefMgr.getAsBoolean("SHOW_EXPAND_ICON"));
        boolean useProxy = this.prefMgr.getAsBoolean("PROXY.USE");
        this.useProxyCB.setSelected(useProxy);
        boolean authenticateProxy = this.prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        this.authenticateProxyCB.setSelected(authenticateProxy);
        this.proxyHostField.setText(this.prefMgr.get("PROXY.HOST", ""));
        this.proxyPortField.setText(this.prefMgr.get("PROXY.PORT", ""));
        this.proxyUsernameField.setText(this.prefMgr.get("PROXY.USERNAME", ""));
        String pwCoded = this.prefMgr.get("PROXY.PW", "");
        this.proxyPasswordField.setText(Utilities.base64Decode(pwCoded));
        String proxyTypeString = this.prefMgr.get("PROXY.TYPE", null);
        if (proxyTypeString != null) {
            this.proxyTypeCB.setSelectedItem(proxyTypeString);
        }
        this.backgroundColorPanel.setBackground(PreferenceManager.getInstance().getAsColor("BACKGROUND_COLOR"));
        this.dbHostField.setText(this.prefMgr.get("DB_HOST"));
        this.dbNameField.setText(this.prefMgr.get("DB_NAME"));
        String portText = this.prefMgr.get("DB_PORT");
        if (!portText.equals("-1")) {
            this.dbPortField.setText(portText);
        }
        if ((igvDirectory = DirectoryManager.getIgvDirectory()) != null) {
            this.igvDirectoryField.setText(igvDirectory.getAbsolutePath());
        }
        this.tooltipDismissDelayField.setText(this.prefMgr.get("TOOLTIP.DISMISS_DELAY"));
        this.tooltipReshowDelayField.setText(this.prefMgr.get("TOOLTIP.RESHOW_DELAY"));
        this.toolTipInitialDelayField.setText(this.prefMgr.get("TOOLTIP.INITIAL_DELAY"));
        this.updateFontField();
        this.updateProxyState(useProxy, authenticateProxy);
    }

    private void updateFontField() {
        Font font = FontManager.getDefaultFont();
        StringBuffer buf = new StringBuffer();
        buf.append(font.getFamily());
        if (font.isBold()) {
            buf.append(" bold");
        }
        if (font.isItalic()) {
            buf.append(" italic");
        }
        buf.append(" " + font.getSize());
        this.defaultFontField.setText(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForSAMChanges() {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            boolean reloadSAM = false;
            for (String key : SAM_PREFERENCE_KEYS) {
                if (!this.updatedPreferenceMap.containsKey(key)) continue;
                reloadSAM = true;
                break;
            }
            boolean updateSpliceJunctions = false;
            for (String key : SPLICE_JUNCTION_KEYS) {
                if (!this.updatedPreferenceMap.containsKey(key)) continue;
                updateSpliceJunctions = true;
                break;
            }
            IGV igv = IGV.getInstance();
            if (updateSpliceJunctions) {
                igv.notifyAlignmentTrackEvent(this, AlignmentTrackEvent.Type.SPLICE_JUNCTION);
            }
            if (reloadSAM) {
                if (this.updatedPreferenceMap.containsKey("SAM.MAX_VISIBLE_RANGE")) {
                    igv.notifyAlignmentTrackEvent(this, AlignmentTrackEvent.Type.VISIBILITY_WINDOW);
                }
                igv.notifyAlignmentTrackEvent(this, AlignmentTrackEvent.Type.RELOAD);
            }
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    private void checkForProbeChanges() {
        if (this.updatedPreferenceMap.containsKey("PROBE_MAPPING_KEY")) {
            ProbeToLocusMap.getInstance().clearProbeMappings();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreferencesEditor dialog = new PreferencesEditor((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e2) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public String getOverlayText() {
        return overlayText;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

