/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.CachingFeatureReader;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.IGVFeatureReader;
import org.broad.igv.feature.tribble.TribbleIndexNotFoundException;
import org.broad.igv.feature.tribble.TribbleReaderWrapper;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IndexCreatorDialog;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.collections.CollUtils;
import org.broad.igv.variant.VariantTrack;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.index.Index;

public abstract class TribbleFeatureSource
implements FeatureSource {
    IGVFeatureReader reader;
    DataSource coverageSource;
    boolean isVCF;
    Genome genome;
    Map<String, String> chrNameMap = new HashMap<String, String>();
    private int featureWindowSize;
    Object header;
    Class featureClass;

    public static TribbleFeatureSource getFeatureSource(ResourceLocator locator, Genome genome) throws IOException, TribbleIndexNotFoundException {
        return TribbleFeatureSource.getFeatureSource(locator, genome, true);
    }

    public static TribbleFeatureSource getFeatureSource(ResourceLocator locator, Genome genome, boolean useCache) throws IOException, TribbleIndexNotFoundException {
        AbstractFeatureReader basicReader;
        boolean indexRequired;
        FeatureCodec codec = CodecFactory.getCodec(locator, genome);
        String idxPath = ResourceLocator.indexFile(locator);
        boolean indexExists = false;
        try {
            indexExists = new File(idxPath).canRead();
        }
        catch (Exception e2) {
            // empty catch block
        }
        int tenMB = 10000000;
        int oneGB = 1000000000;
        long size = FileUtils.getLength(locator.getPath());
        boolean bl = indexRequired = VariantTrack.isVCF(locator.getTypeString()) && size > 10000000L || size > 1000000000L;
        if (!Globals.isHeadless() && locator.isLocal() && !locator.getPath().endsWith(".gz") && !indexExists && size > 10000000L) {
            TribbleFeatureSource.createIndex(locator, indexRequired);
        }
        if ((basicReader = AbstractFeatureReader.getFeatureReader(locator.getPath(), idxPath, codec, indexRequired)).hasIndex()) {
            return new IndexedFeatureSource(basicReader, codec, locator, genome, useCache);
        }
        return new NonIndexedFeatureSource(basicReader, codec, locator, genome);
    }

    private static Index createIndex(ResourceLocator locator, boolean indexRequired) {
        File baseFile = new File(locator.getPath());
        File newIdxFile = new File(locator.getPath() + ".idx");
        String messageText = "An index file for " + baseFile.getAbsolutePath() + " could not " + "be located. An index is " + (indexRequired ? "required" : "recommended") + " to view files of this size.   Click \"Go\" to create one now.";
        IndexCreatorDialog dialog = IndexCreatorDialog.createShowDialog(IGV.getMainFrame(), baseFile, newIdxFile, messageText);
        return (Index)dialog.getIndex();
    }

    private TribbleFeatureSource(ResourceLocator locator, AbstractFeatureReader reader, FeatureCodec codec, Genome genome, boolean useCache) throws IOException {
        this.genome = genome;
        this.isVCF = codec.getClass() == VCFWrapperCodec.class;
        this.featureClass = codec.getFeatureType();
        this.header = reader.getHeader();
        this.featureWindowSize = this.estimateFeatureWindowSize(reader);
        this.reader = useCache ? new CachingFeatureReader(reader, 5, this.featureWindowSize) : new TribbleReaderWrapper(reader);
        this.initCoverageSource(locator.getPath() + ".tdf");
    }

    protected abstract int estimateFeatureWindowSize(FeatureReader var1);

    protected abstract Collection<String> getSequenceNames();

    public abstract boolean isIndexed();

    public Class getFeatureClass() {
        return this.featureClass;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
        if (this.reader instanceof CachingFeatureReader) {
            ((CachingFeatureReader)this.reader).setBinSize(size);
        }
    }

    public Object getHeader() {
        return this.header;
    }

    private void initCoverageSource(String covPath) {
        if (ParsingUtils.pathExists(covPath)) {
            TDFReader reader = TDFReader.getReader(covPath);
            this.coverageSource = new TDFDataSource(reader, 0, "", this.genome);
        }
    }

    static class NonIndexedFeatureSource
    extends TribbleFeatureSource {
        Map<String, List<Feature>> featureMap = new HashMap<String, List<Feature>>(25);
        CoverageDataSource coverageData;

        private NonIndexedFeatureSource(AbstractFeatureReader basicReader, FeatureCodec codec, ResourceLocator locator, Genome genome) throws IOException {
            super(locator, basicReader, codec, genome, false);
            Iterator<Feature> iter = this.reader.iterator();
            while (iter.hasNext()) {
                Feature f2 = iter.next();
                if (f2 == null) continue;
                String seqName = f2.getChr();
                String igvChr = genome == null ? seqName : genome.getChromosomeAlias(seqName);
                List<Feature> featureList = this.featureMap.get(igvChr);
                if (featureList == null) {
                    featureList = new ArrayList<Feature>();
                    this.featureMap.put(igvChr, featureList);
                }
                featureList.add(f2);
                if (!(f2 instanceof NamedFeature)) continue;
                FeatureDB.addFeature((NamedFeature)f2, genome);
            }
            for (List<Feature> featureList : this.featureMap.values()) {
                FeatureUtils.sortFeatureList(featureList);
            }
            if (genome != null) {
                this.coverageData = new CoverageDataSource(genome);
                this.coverageData.computeGenomeCoverage();
                this.sampleGenomeFeatures();
            }
        }

        @Override
        public boolean isIndexed() {
            return false;
        }

        @Override
        public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
            return this.coverageData == null ? Collections.emptyList() : this.coverageData.getSummaryScoresForRange(chr, start, end, zoom);
        }

        public Iterator getFeatures(String chr, int start, int end) throws IOException {
            List<Feature> features = this.featureMap.get(chr);
            if (features == null) {
                return Collections.emptyList().iterator();
            }
            List<Feature> filteredFeatures = CollUtils.filter(features, FeatureUtils.getOverlapPredicate(chr, start, end));
            return filteredFeatures.iterator();
        }

        @Override
        protected Collection<String> getSequenceNames() {
            return this.featureMap.keySet();
        }

        @Override
        protected int estimateFeatureWindowSize(FeatureReader reader) {
            return 0;
        }

        protected void sampleGenomeFeatures() {
            ArrayList<BasicFeature> chrAllFeatures = new ArrayList<BasicFeature>(1000);
            int sampleLength = (int)((double)this.genome.getNominalLength() / 700000.0);
            int lastFeaturePosition = -1;
            for (String chr : this.genome.getLongChromosomeNames()) {
                List<Feature> features = this.featureMap.get(chr);
                if (features == null) continue;
                long offset = this.genome.getCumulativeOffset(chr);
                for (Feature feature : features) {
                    if (!(feature instanceof IGVFeature)) continue;
                    IGVFeature f2 = (IGVFeature)feature;
                    int genStart = (int)((offset + (long)f2.getStart()) / 1000L);
                    int genEnd = (int)((offset + (long)f2.getEnd()) / 1000L);
                    if (genEnd <= lastFeaturePosition + sampleLength) continue;
                    BasicFeature f22 = new BasicFeature("All", genStart, genEnd);
                    if (f2 instanceof BasicFeature) {
                        BasicFeature bf = (BasicFeature)f2;
                        f22.setThickEnd((int)((offset + (long)bf.getThickEnd()) / 1000L));
                        f22.setThickStart((int)((offset + (long)bf.getThickStart()) / 1000L));
                        f22.setName(f2.getName());
                    }
                    chrAllFeatures.add(f22);
                    lastFeaturePosition = genEnd;
                }
            }
            this.featureMap.put("All", chrAllFeatures);
        }

        class CoverageDataSource
        extends AbstractDataSource {
            int windowSize;
            double dataMin;
            double dataMax;
            Map<String, DataTile> dataCache;

            CoverageDataSource(Genome genome) {
                super(genome);
                this.windowSize = 1000;
                this.dataMin = 0.0;
                this.dataMax = 0.0;
                this.dataCache = new HashMap<String, DataTile>();
            }

            @Override
            protected DataTile getRawData(String chr, int startLocation, int endLocation) {
                DataTile coverageData = this.dataCache.get(chr);
                if (coverageData == null) {
                    coverageData = this.computeCoverage(chr, startLocation, endLocation);
                    this.dataCache.put(chr, coverageData);
                }
                return coverageData;
            }

            @Override
            protected List<LocusScore> getPrecomputedSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
                return null;
            }

            @Override
            public int getLongestFeature(String chr) {
                return this.windowSize;
            }

            @Override
            public double getDataMax() {
                return this.dataMax;
            }

            @Override
            public double getDataMin() {
                return this.dataMin;
            }

            @Override
            public TrackType getTrackType() {
                return TrackType.OTHER;
            }

            private DataTile computeCoverage(String chr, int start, int end) {
                int nBins = (end - start) / this.windowSize + 1;
                int[] starts = new int[nBins];
                int[] ends = new int[nBins];
                for (int i2 = 0; i2 < nBins; ++i2) {
                    starts[i2] = start + i2 * this.windowSize;
                    ends[i2] = starts[i2] + this.windowSize;
                }
                float[] values = new float[nBins];
                List<Feature> features = NonIndexedFeatureSource.this.featureMap.get(chr);
                if (features != null) {
                    for (Feature f2 : features) {
                        int startBin = f2.getStart() / this.windowSize;
                        int endBin = f2.getEnd() / this.windowSize;
                        for (int i3 = startBin; i3 < endBin; ++i3) {
                            values[i3] = values[i3] + 1.0f;
                            this.dataMax = Math.max(this.dataMax, (double)values[i3]);
                        }
                    }
                }
                return new DataTile(starts, ends, values, null);
            }

            protected void computeGenomeCoverage() {
                int nBins = 1000;
                int[] starts = new int[nBins];
                int[] ends = new int[nBins];
                float[] values = new float[nBins];
                Arrays.fill(values, 0.0f);
                double step = (double)this.genome.getNominalLength() / 1000.0 / (double)nBins;
                for (int i2 = 0; i2 < nBins; ++i2) {
                    starts[i2] = (int)((double)i2 * step);
                    ends[i2] = (int)((double)(i2 + 1) * step);
                }
                for (String chr : this.genome.getLongChromosomeNames()) {
                    List<Feature> features = NonIndexedFeatureSource.this.featureMap.get(chr);
                    if (features == null) continue;
                    long offset = this.genome.getCumulativeOffset(chr);
                    for (Feature f2 : features) {
                        int genStart = (int)((offset + (long)f2.getStart()) / 1000L);
                        int genEnd = (int)((offset + (long)f2.getEnd()) / 1000L);
                        int binStart = Math.min(values.length - 1, (int)((double)genStart / step));
                        int binEnd = Math.min(values.length - 1, (int)((double)genEnd / step));
                        for (int i3 = binStart; i3 <= binEnd; ++i3) {
                            values[i3] = values[i3] + 1.0f;
                            this.dataMax = Math.max(this.dataMax, (double)values[i3]);
                        }
                    }
                }
                this.dataCache.put("All", new DataTile(starts, ends, values, null));
            }

            public String getValueString(String chr, double position, ReferenceFrame frame) {
                int zoom = Math.max(0, frame.getZoom());
                List<LocusScore> scores = this.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
                double bpPerPixel = frame.getScale();
                int minWidth = (int)(2.0 * bpPerPixel);
                if (scores == null) {
                    return "";
                }
                LocusScore score = FeatureUtils.getFeatureAt(position, minWidth, scores);
                return score == null ? "" : "Mean count: " + score.getScore();
            }
        }
    }

    static class IndexedFeatureSource
    extends TribbleFeatureSource {
        private IndexedFeatureSource(AbstractFeatureReader basicReader, FeatureCodec codec, ResourceLocator locator, Genome genome, boolean useCache) throws IOException {
            super(locator, basicReader, codec, genome, useCache);
            List<String> seqNames;
            if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
                for (String seqName : seqNames) {
                    String igvChr = genome.getChromosomeAlias(seqName);
                    if (igvChr == null || igvChr.equals(seqName)) continue;
                    this.chrNameMap.put(igvChr, seqName);
                }
            }
        }

        @Override
        public boolean isIndexed() {
            return true;
        }

        public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
            String seqName = (String)this.chrNameMap.get(chr);
            if (seqName == null) {
                seqName = chr;
            }
            return this.reader.query(seqName, start, end);
        }

        @Override
        public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
            return this.coverageSource == null ? null : this.coverageSource.getSummaryScoresForRange(chr, start, end, zoom);
        }

        @Override
        protected Collection<String> getSequenceNames() {
            return this.reader.getSequenceNames();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int estimateFeatureWindowSize(FeatureReader reader) {
            if (this.isVCF) {
                return 10000;
            }
            CloseableTribbleIterator iter = null;
            try {
                double mem = RuntimeUtils.getAvailableMemory();
                iter = reader.iterator();
                if (iter.hasNext()) {
                    Feature firstFeature;
                    int nSamples = 1000;
                    Feature lastFeature = firstFeature = (Feature)iter.next();
                    String chr = firstFeature.getChr();
                    int n2 = 1;
                    long len = 0L;
                    while (iter.hasNext() && n2 < nSamples) {
                        Feature f2 = (Feature)iter.next();
                        if (f2 == null) continue;
                        ++n2;
                        if (f2.getChr().equals(chr)) {
                            lastFeature = f2;
                            continue;
                        }
                        len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1);
                        firstFeature = f2;
                        lastFeature = f2;
                        chr = f2.getChr();
                    }
                    double dMem = mem - (double)RuntimeUtils.getAvailableMemory();
                    double bytesPerFeature = Math.max(100.0, dMem / (double)n2);
                    double featuresPerBase = (double)n2 / (double)(len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1));
                    double targetBinMemory = 2.0E7;
                    int maxBinSize = Integer.MAX_VALUE;
                    int bs = Math.min(maxBinSize, (int)(targetBinMemory / (bytesPerFeature * featuresPerBase)));
                    int n3 = Math.max(1000000, bs);
                    return n3;
                }
                int n4 = Integer.MAX_VALUE;
                return n4;
            }
            catch (IOException e2) {
                int n5 = 1000000;
                return n5;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
    }
}

