/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.broad.igv.tools.sort.Parser;
import org.broad.igv.tools.sort.Sorter;
import org.broad.tribble.readers.AsciiLineReader;

public class CNSorter
extends Sorter {
    private static Logger log = Logger.getLogger(Sorter.class);

    public CNSorter(File inputFile, File outputFile) {
        super(inputFile, outputFile);
    }

    @Override
    String writeHeader(AsciiLineReader reader, PrintWriter writer) throws IOException {
        String nextLine = reader.readLine();
        while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
            writer.println(nextLine);
            nextLine = reader.readLine();
        }
        writer.println(nextLine);
        if (!nextLine.startsWith("SNP")) {
            log.warn("Expected header line not found");
        }
        return null;
    }

    @Override
    Parser getParser() throws IOException {
        String fn;
        String tmp = this.inputFile.getName();
        String string = fn = tmp.endsWith(".txt") ? tmp.substring(0, tmp.length() - 4) : tmp;
        if (fn.endsWith(".cn") || fn.endsWith(".xcn") || fn.endsWith(".snp")) {
            return new Parser(1, 2);
        }
        if (fn.endsWith(".igv")) {
            return this.getIGVParser();
        }
        throw new RuntimeException("Unrecognized copy number extension: " + fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Parser getIGVParser() throws IOException {
        int chrColumn = 0;
        int startColumn = 1;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(this.inputFile));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null && nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#columns")) continue;
                String[] tokens = nextLine.split("\\s+");
                if (tokens.length <= 1) break;
                for (int i2 = 1; i2 < tokens.length; ++i2) {
                    int c2;
                    String[] kv = tokens[i2].split("=");
                    if (kv.length != 2) continue;
                    if (kv[0].toLowerCase().equals("chr")) {
                        c2 = Integer.parseInt(kv[1]);
                        if (c2 < 1) {
                            throw new RuntimeException("Error parsing column line: " + nextLine + ". Column numbers must be > 0");
                        }
                        chrColumn = c2 - 1;
                        continue;
                    }
                    if (!kv[0].toLowerCase().equals("start")) continue;
                    c2 = Integer.parseInt(kv[1]);
                    if (c2 < 1) {
                        throw new RuntimeException("Error parsing column line: " + nextLine + ". Column numbers must be > 0");
                    }
                    startColumn = c2 - 1;
                }
            }
            Parser parser = new Parser(chrColumn, startColumn);
            return parser;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

