/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.parsers;

import java.io.IOException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.parsers.AbstractParser;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.tools.parsers.UnsortedException;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.readers.AsciiLineReader;

public class CNParser
extends AbstractParser {
    private static Logger log = Logger.getLogger(CNParser.class);
    private static int PROBE_COL = 0;
    int skipColumns;
    private String chr;
    String lastChr = "";
    int lastPosition = 0;
    private double minValue;
    private double maxValue;
    ResourceLocator resourceLocator;
    Set<String> unsortedChromosomes;
    private int chrColumn;
    private int startColumn;
    private int endColumn;
    private int probeColumn;
    private int firstDataColumn;
    private boolean hasEndLocations;
    private FileType type;
    Genome genome;
    private boolean hasCalls;

    public CNParser(String file, DataConsumer dataConsumer, Genome genome) {
        this(new ResourceLocator(file), dataConsumer, genome);
    }

    public CNParser(ResourceLocator locator, DataConsumer dataConsumer, Genome genome) {
        super(dataConsumer);
        this.resourceLocator = locator;
        this.genome = genome;
        String tmp = locator.getPath().toLowerCase();
        tmp = tmp.endsWith(".txt") ? tmp.substring(0, tmp.length() - 4) : tmp;
        boolean bl = this.hasCalls = tmp.endsWith(".xcn") || tmp.endsWith(".snp");
        if (tmp.endsWith(".igv")) {
            this.chrColumn = 0;
            this.startColumn = 1;
            this.endColumn = 2;
            this.probeColumn = 3;
            this.firstDataColumn = 4;
            this.hasEndLocations = true;
            this.hasCalls = false;
            this.type = FileType.IGV;
            this.setTrackType(TrackType.OTHER);
        } else {
            this.probeColumn = 0;
            this.chrColumn = 1;
            this.startColumn = 2;
            this.endColumn = -1;
            this.firstDataColumn = 3;
            this.hasEndLocations = false;
            boolean bl2 = this.hasCalls = tmp.endsWith(".xcn") || tmp.endsWith(".snp");
            this.type = tmp.endsWith(".cn") ? FileType.CN : (tmp.endsWith(".xcn") ? FileType.XCN : FileType.SNP);
        }
        this.skipColumns = this.hasCalls ? 2 : 1;
    }

    public void parseHeader(String[] tokens) {
        int nDataColumns = (tokens.length - this.firstDataColumn) / this.skipColumns;
        String[] headings = new String[nDataColumns];
        for (int i2 = this.firstDataColumn; i2 < tokens.length; i2 += this.skipColumns) {
            int idx = (i2 - this.firstDataColumn) / this.skipColumns;
            headings[idx] = tokens[i2];
        }
        this.setHeadings(headings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        AsciiLineReader reader = null;
        try {
            this.lastPosition = 0;
            reader = ParsingUtils.openAsciiReader(this.resourceLocator);
            String nextLine = null;
            if (this.isCopyNumberFileExt(this.resourceLocator.getPath())) {
                this.setTrackType(TrackType.COPY_NUMBER);
            } else if (this.isLOHFileExt(this.resourceLocator.getPath())) {
                this.setTrackType(TrackType.LOH);
            }
            nextLine = reader.readLine();
            while (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                if (nextLine.length() > 0) {
                    this.parseComment(nextLine);
                }
                nextLine = reader.readLine();
            }
            this.parseHeader(nextLine.trim().split("\t"));
            this.setTrackParameters();
            float[] dataArray = new float[this.getHeadings().length];
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                String[] tokens = Globals.singleTabMultiSpacePattern.split(nextLine);
                int nTokens = tokens.length;
                if (nTokens == 0) continue;
                try {
                    String string = this.chr = this.genome == null ? tokens[this.chrColumn] : this.genome.getChromosomeAlias(tokens[this.chrColumn]);
                    if (!this.chr.equals(this.lastChr)) {
                        this.newChromosome();
                    }
                    this.lastChr = this.chr;
                    int startPosition = ParsingUtils.parseInt(tokens[this.startColumn].trim());
                    if (startPosition < this.lastPosition) {
                        throw new UnsortedException("Error: unsorted file.  .cn files must be sorted by genomic position.");
                    }
                    this.lastPosition = startPosition;
                    int endPosition = this.hasEndLocations ? ParsingUtils.parseInt(tokens[this.endColumn].trim()) : startPosition + 1;
                    for (int i2 = this.firstDataColumn; i2 < nTokens; i2 += this.skipColumns) {
                        int idx = (i2 - this.firstDataColumn) / this.skipColumns;
                        try {
                            dataArray[idx] = Float.parseFloat(tokens[i2].trim());
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            dataArray[idx] = Float.NaN;
                        }
                    }
                    String probe = tokens[this.probeColumn];
                    this.getDataConsumer().addData(this.chr, startPosition, endPosition, dataArray, probe);
                }
                catch (NumberFormatException e2) {
                    log.error("Error parsing number in: " + nextLine + "\n" + e2.getMessage(), e2);
                }
            }
            this.parsingComplete();
        }
        catch (Exception e3) {
            log.error(e3.getMessage(), e3);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void newChromosome() {
        this.lastPosition = -1;
    }

    private void parsingComplete() {
        this.getDataConsumer().parsingComplete();
    }

    private boolean isCopyNumberFileExt(String filename) {
        String tmp = filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") ? filename.substring(0, filename.length() - 4) : filename;
        return tmp.endsWith(".cn") || tmp.endsWith(".xcn") || tmp.endsWith(".snp");
    }

    private boolean isLOHFileExt(String filename) {
        String tmp = filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") ? filename.substring(0, filename.length() - 4) : filename;
        return tmp.endsWith(".loh");
    }

    static enum FileType {
        IGV,
        XCN,
        SNP,
        CN;

    }
}

