/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tdf.TDFBedTile;
import org.broad.igv.tdf.TDFDataset;
import org.broad.igv.tdf.TDFFixedTile;
import org.broad.igv.tdf.TDFGroup;
import org.broad.igv.tdf.TDFTile;
import org.broad.igv.tdf.TDFVaryTile;
import org.broad.igv.tdf.TDFWriter;
import org.broad.igv.tools.CommandLineStatusMonitor;
import org.broad.igv.tools.ListAccumulator;
import org.broad.igv.tools.PreprocessingException;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.tools.parsers.CNParser;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.tools.parsers.ToolsWiggleParser;
import org.broad.igv.tools.parsers.UnsortedException;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class Preprocessor
implements DataConsumer {
    private static Logger log = Logger.getLogger(Preprocessor.class);
    boolean compressed = true;
    private boolean skipZeroes = false;
    private int nZoom = 7;
    int maxExtFactor = 0;
    Zoom[] zoomLevels;
    int nTracks;
    Genome genome;
    Collection<WindowFunction> windowFunctions;
    private String currentChr = "";
    int currentChrLength;
    private int sizeEstimate;
    int nPtsProcessed = 0;
    StatusMonitor statusMonitor;
    double percentComplete = 0.0;
    int lastStartPosition = 0;
    HashSet<String> skippedChromosomes = new HashSet();
    TDFWriter writer;
    Raw rawData;
    Zoom genomeZoom;
    File outputFile;
    ListAccumulator allDataStats;
    List<String> chromosomes = new ArrayList<String>();
    Set<String> visitedChromosomes = new HashSet<String>();
    Map<String, String> attributes = new HashMap<String, String>();
    List<WindowFunction> allDataFunctions = Arrays.asList(WindowFunction.mean, WindowFunction.median, WindowFunction.min, WindowFunction.max, WindowFunction.percentile2, WindowFunction.percentile10, WindowFunction.percentile90, WindowFunction.percentile98);

    public Preprocessor(File outputFile, Genome genome, Collection<WindowFunction> windowFunctions, int sizeEstimate, StatusMonitor monitor) {
        this.outputFile = outputFile;
        this.genome = genome;
        this.windowFunctions = windowFunctions;
        this.sizeEstimate = sizeEstimate;
        this.genome = genome;
        this.statusMonitor = monitor;
        this.allDataStats = new ListAccumulator(this.allDataFunctions);
        if (this.statusMonitor == null) {
            PrintStream monStream = this.outputFile == null ? System.err : System.out;
            this.statusMonitor = new CommandLineStatusMonitor(monStream);
        }
    }

    @Override
    public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames) {
        this.setTrackParameters(trackType, trackLine, trackNames, true);
    }

    @Override
    public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames, boolean computeWholeGenome) {
        if (trackLine != null) {
            log.info(trackLine);
        }
        if (this.outputFile != null && this.writer == null) {
            this.writer = new TDFWriter(this.outputFile, this.genome.getId(), trackType, trackLine, trackNames, this.windowFunctions, this.compressed);
            this.nTracks = trackNames.length;
            if (computeWholeGenome) {
                int genomeLength = (int)(this.genome.getNominalLength() / 1000L);
                this.genomeZoom = new Zoom("All", 0, genomeLength);
            }
            TDFGroup rootGroup = this.writer.getRootGroup();
            rootGroup.setAttribute("genome", this.genome.getId());
            rootGroup.setAttribute("maxZoom", String.valueOf(this.nZoom));
        }
    }

    @Override
    public void addData(String chr, int start, int end, float[] data, String name) {
        if (this.writer == null) {
            return;
        }
        if (this.skipZeroes) {
            boolean allZeroes = true;
            for (int i2 = 0; i2 < data.length; ++i2) {
                if (data[i2] == 0.0f) continue;
                allZeroes = false;
                break;
            }
            if (allZeroes) {
                return;
            }
        }
        if (this.statusMonitor != null && this.statusMonitor.isInterrupted()) {
            throw new PreprocessingException("Preprocessing Halted.");
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        if (this.currentChr != null && chr.equals(this.currentChr)) {
            if (start < this.lastStartPosition - this.maxExtFactor) {
                String msg = "Error: Data is not sorted @ " + chr + " " + start + "  (last position = " + this.lastStartPosition + "   max ext factor = " + this.maxExtFactor + ")";
                UnsortedException e2 = new UnsortedException(msg);
                log.error(msg, e2);
                throw e2;
            }
        } else {
            this.newChromosome(chr);
        }
        if (this.skippedChromosomes.contains(chr)) {
            return;
        }
        int chrLength = this.genome.getChromosome(chr).getLength();
        if (start > chrLength) {
            log.warn("Ignoring data from non-existent locus.  Probe = " + name + "  Locus = " + chr + ":" + start + "-" + end + ". " + chr + " length = " + chrLength);
            return;
        }
        this.rawData.addData(start, end, data, name);
        for (Zoom zl : this.zoomLevels) {
            zl.addData(start, end, data);
        }
        long offset = this.genome.getCumulativeOffset(chr);
        int gStart = (int)((offset + (long)start) / 1000L);
        int gEnd = Math.max(gStart + 1, (int)((offset + (long)end) / 1000L));
        if (!(this.genomeZoom == null || chr.equals("chrM") || chr.equals("M") || chr.equals("MT"))) {
            this.genomeZoom.addData(gStart, gEnd, data);
            for (int i3 = 0; i3 < data.length; ++i3) {
                this.allDataStats.add(gEnd - gStart, data[i3]);
            }
        }
        this.lastStartPosition = start;
    }

    public void newChromosome(String chr) {
        if (this.visitedChromosomes.contains(chr)) {
            String msg = "Error: Data is not ordered by start position. Chromosome " + chr + " appears in multiple blocks";
            PreprocessingException e2 = new PreprocessingException(msg);
            log.error(msg, e2);
            throw e2;
        }
        this.visitedChromosomes.add(chr);
        Chromosome c2 = this.genome.getChromosome(chr);
        if (c2 == null) {
            log.warn("Chromosome: " + chr + " not found in .genome file.  Skipping.");
            this.skippedChromosomes.add(chr);
        } else {
            this.chromosomes.add(chr);
            log.info("Processing chromosome " + chr);
            if (this.zoomLevels != null) {
                for (Zoom zl : this.zoomLevels) {
                    zl.close();
                }
            }
            if (this.rawData != null) {
                this.rawData.close();
            }
            this.currentChr = chr;
            this.currentChrLength = c2.getLength();
            this.zoomLevels = new Zoom[this.getNZoom() + 1];
            for (int z = 0; z <= this.getNZoom(); ++z) {
                this.zoomLevels[z] = new Zoom(chr, z, this.currentChrLength);
            }
            this.rawData = new Raw(chr, this.currentChrLength, 100000);
        }
        this.lastStartPosition = 0;
    }

    @Override
    public void parsingComplete() {
    }

    public void finish() {
        if (this.writer == null) {
            return;
        }
        StringBuffer chrString = new StringBuffer();
        Iterator<String> iter = this.genome.getAllChromosomeNames().iterator();
        while (iter.hasNext()) {
            String chromoName = iter.next();
            if (!this.chromosomes.contains(chromoName)) continue;
            chrString.append(chromoName);
            if (!iter.hasNext()) continue;
            chrString.append(",");
        }
        this.writer.getRootGroup().setAttribute("chromosomes", chrString.toString());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.writer.getRootGroup().setAttribute(entry.getKey(), entry.getValue());
        }
        if (this.zoomLevels != null) {
            for (Zoom zl : this.zoomLevels) {
                zl.close();
            }
        }
        if (this.genomeZoom != null) {
            this.genomeZoom.close();
        }
        if (this.rawData == null) {
            log.warn("No features were found that matched chromosomes in genome: " + this.genome.getId());
        } else {
            this.rawData.close();
            this.allDataStats.finish();
            TDFGroup group = this.writer.getGroup("/");
            group.setAttribute("userPercentileAutoscaling", "true");
            for (WindowFunction wf : this.allDataFunctions) {
                group.setAttribute(wf.getValue(), String.valueOf(this.allDataStats.getValue(wf)));
            }
            this.writer.closeFile();
        }
        if (this.statusMonitor != null) {
            this.statusMonitor.setPercentComplete(100.0);
        }
    }

    @Override
    public void setType(String type) {
    }

    @Override
    public void setSortTolerance(int tolerance) {
        this.maxExtFactor = tolerance;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void setSizeEstimate(int sizeEstimate) {
        this.sizeEstimate = sizeEstimate;
    }

    public void setSkipZeroes(boolean skipZeroes) {
        this.skipZeroes = skipZeroes;
    }

    public int getNZoom() {
        return this.nZoom;
    }

    public void setNZoom(int nZoom) {
        this.nZoom = nZoom;
    }

    public static boolean isAlignmentFile(String ext) {
        return ext.equalsIgnoreCase(".bam") || ext.equalsIgnoreCase(".sam") || ext.equalsIgnoreCase(".aligned") || ext.equalsIgnoreCase(".sorted.txt") || ext.equalsIgnoreCase(".bedz") || ext.equalsIgnoreCase(".bed");
    }

    public void preprocess(File iFile, int maxZoomValue, String typeString) throws IOException {
        this.setNZoom(maxZoomValue);
        String tmp = (typeString == null ? iFile.getAbsolutePath() : typeString).toLowerCase();
        if (tmp.endsWith(".txt")) {
            tmp = tmp.substring(0, tmp.length() - 4);
        }
        if (tmp.endsWith(".gz")) {
            tmp = tmp.substring(0, tmp.length() - 3);
        }
        if (tmp.endsWith("wig") || tmp.endsWith("bedgraph") || tmp.endsWith("cpg") || tmp.endsWith("map")) {
            ToolsWiggleParser wg = new ToolsWiggleParser(iFile.getAbsolutePath(), this, this.genome);
            wg.parse();
        } else if (tmp.endsWith("cn") || tmp.endsWith("xcn") || tmp.endsWith("igv") || tmp.endsWith("snp")) {
            CNParser cnParser = new CNParser(iFile.getAbsolutePath(), (DataConsumer)this, this.genome);
            cnParser.parse();
        } else {
            String msg = "Error: cannot convert files of type '" + tmp + "' to TDF format.";
            msg = msg + "\nTry specifying the file type with the --fileType parameter.";
            throw new RuntimeException(msg);
        }
    }

    public static String getExtension(String filename) {
        int idx;
        if (filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        if (filename.toLowerCase().endsWith(".sorted.txt")) {
            return ".sorted.txt";
        }
        if (filename.toLowerCase().endsWith(".txt")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        if ((idx = filename.lastIndexOf(46)) < 0) {
            return "";
        }
        return filename.substring(idx).toLowerCase();
    }

    class Tile {
        int totalCount = 0;
        int zoomLevel;
        int tileNumber;
        int tileStart;
        int lastFinishedBin = 0;
        double binWidth;
        int nBins;
        int nonEmptyBins;
        ListAccumulator[][] accumulators;
        Map<WindowFunction, TDFDataset> datasets;

        Tile(Map<WindowFunction, TDFDataset> datasets, int zoomLevel, int tileNumber, int nBins, int tileWidth) {
            this.datasets = datasets;
            this.zoomLevel = zoomLevel;
            this.tileNumber = tileNumber;
            this.tileStart = tileNumber * tileWidth;
            this.nBins = nBins;
            this.binWidth = (double)tileWidth / (double)nBins;
            this.accumulators = new ListAccumulator[Preprocessor.this.nTracks][nBins];
        }

        void addData(int start, int end, float[] data) {
            ++this.totalCount;
            int startBin = Math.max(0, (int)((double)(start - this.tileStart) / this.binWidth));
            int endBin = Math.min(this.nBins - 1, (int)((double)(end - this.tileStart) / this.binWidth));
            int tmp = (int)((double)(start - this.tileStart - Preprocessor.this.maxExtFactor) / this.binWidth);
            for (int t2 = 0; t2 < Preprocessor.this.nTracks; ++t2) {
                int b2;
                for (b2 = this.lastFinishedBin; b2 < tmp; ++b2) {
                    if (this.accumulators[t2][b2] == null) continue;
                    this.accumulators[t2][b2].finish();
                }
                this.lastFinishedBin = Math.max(0, tmp - 1);
                for (b2 = startBin; b2 <= endBin; ++b2) {
                    if (this.accumulators[t2][b2] == null) {
                        this.accumulators[t2][b2] = new ListAccumulator(this.datasets.keySet());
                    }
                    this.accumulators[t2][b2].add(end - start, data[t2]);
                }
            }
        }

        void close() {
            this.nonEmptyBins = 0;
            for (int t2 = 0; t2 < Preprocessor.this.nTracks; ++t2) {
                for (int i2 = 0; i2 < this.nBins; ++i2) {
                    if (this.accumulators[t2][i2] == null) continue;
                    this.accumulators[t2][i2].finish();
                    if (t2 != 0) continue;
                    ++this.nonEmptyBins;
                }
            }
            TDFTile tile = null;
            for (WindowFunction wf : this.datasets.keySet()) {
                if ((double)this.nonEmptyBins < 0.5 * (double)this.nBins) {
                    int[] starts = new int[this.nonEmptyBins];
                    float[][] data = new float[Preprocessor.this.nTracks][this.nonEmptyBins];
                    int n2 = 0;
                    for (int i3 = 0; i3 < this.nBins; ++i3) {
                        for (int t3 = 0; t3 < Preprocessor.this.nTracks; ++t3) {
                            ListAccumulator acc = this.accumulators[t3][i3];
                            if (acc == null) continue;
                            data[t3][n2] = acc.getValue(wf);
                            if (t3 != Preprocessor.this.nTracks - 1) continue;
                            starts[n2] = (int)((double)this.tileStart + (double)i3 * this.binWidth);
                            ++n2;
                        }
                    }
                    tile = new TDFVaryTile(this.tileStart, this.binWidth, starts, data);
                } else {
                    float[][] data = new float[Preprocessor.this.nTracks][this.nBins];
                    for (int t4 = 0; t4 < Preprocessor.this.nTracks; ++t4) {
                        for (int i4 = 0; i4 < this.nBins; ++i4) {
                            data[t4][i4] = this.accumulators[t4][i4] == null ? Float.NaN : this.accumulators[t4][i4].getValue(wf);
                        }
                    }
                    tile = new TDFFixedTile(this.tileStart, this.tileStart, this.binWidth, data);
                }
                String dsName = this.datasets.get(wf).getName();
                try {
                    Preprocessor.this.writer.writeTile(dsName, this.tileNumber, tile);
                }
                catch (IOException exc) {
                    log.error("Error writing tile: " + dsName + " [" + this.tileNumber + "]", exc);
                    throw new PreprocessingException(exc.getMessage());
                }
            }
        }
    }

    class Zoom {
        int level;
        int tileWidth;
        LinkedHashMap<Integer, Tile> activeTiles = new LinkedHashMap();
        Map<WindowFunction, TDFDataset> datasets = new HashMap<WindowFunction, TDFDataset>();

        Zoom(String chr, int level, int chrLength) {
            int nTiles = (int)Math.pow(2.0, level);
            this.tileWidth = chrLength / nTiles + 1;
            this.level = level;
            for (WindowFunction wf : Preprocessor.this.windowFunctions) {
                String dsName = "/" + chr + "/z" + level + "/" + wf.toString();
                this.datasets.put(wf, Preprocessor.this.writer.createDataset(dsName, TDFDataset.DataType.FLOAT, this.tileWidth, nTiles));
            }
        }

        public void addData(int start, int end, float[] data) {
            Tile t2;
            Integer tileNumber;
            int startTile = start / this.tileWidth;
            int endTile = end / this.tileWidth;
            int tmp = (start - Preprocessor.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                t2 = this.activeTiles.get(tileNumber);
                t2.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int i2 = startTile; i2 <= endTile; ++i2) {
                t2 = this.activeTiles.get(i2);
                if (t2 == null) {
                    t2 = new Tile(this.datasets, this.level, i2, 700, this.tileWidth);
                    this.activeTiles.put(i2, t2);
                }
                t2.addData(start, end, data);
            }
        }

        public void close() {
            for (Tile t2 : this.activeTiles.values()) {
                t2.close();
            }
        }
    }

    class Raw {
        String chr;
        String dsName;
        TDFDataset dataset;
        int tileWidth;
        Map<Integer, RawTile> activeTiles = new HashMap<Integer, RawTile>();

        Raw(String chr, int chrLength, int tileWidth) {
            this.tileWidth = tileWidth;
            int nTiles = chrLength / tileWidth + 1;
            this.dsName = "/" + chr + "/raw";
            this.dataset = Preprocessor.this.writer.createDataset(this.dsName, TDFDataset.DataType.FLOAT, tileWidth, nTiles);
        }

        public void addData(int start, int end, float[] data, String name) {
            int p2;
            Integer tileNumber;
            int startTileNumber = start / this.tileWidth;
            int endTileNumber = end / this.tileWidth;
            int tmp = (start - Preprocessor.this.maxExtFactor) / this.tileWidth;
            while (!this.activeTiles.isEmpty() && (tileNumber = this.activeTiles.keySet().iterator().next()) < tmp) {
                RawTile t2 = this.activeTiles.get(tileNumber);
                t2.close();
                this.activeTiles.remove(tileNumber);
            }
            for (int t3 = startTileNumber; t3 <= endTileNumber; ++t3) {
                RawTile tile = this.activeTiles.get(t3);
                if (tile == null) {
                    tile = new RawTile(this.dsName, t3, t3 * this.tileWidth, (t3 + 1) * this.tileWidth);
                    this.activeTiles.put(t3, tile);
                }
                tile.addData(start, end, data, name);
            }
            if (Preprocessor.this.statusMonitor != null && Preprocessor.this.sizeEstimate > 0 && (double)(p2 = (int)(100.0 * (double)Preprocessor.this.nPtsProcessed / (1.5 * (double)Preprocessor.this.sizeEstimate))) > Preprocessor.this.percentComplete) {
                Preprocessor.this.percentComplete = p2;
                Preprocessor.this.statusMonitor.setPercentComplete(Preprocessor.this.percentComplete);
            }
            ++Preprocessor.this.nPtsProcessed;
        }

        void close() {
            for (RawTile t2 : this.activeTiles.values()) {
                t2.close();
            }
            this.activeTiles = null;
        }
    }

    class RawTile {
        String dsName;
        int tileNumber;
        int tileStart;
        int tileEnd;
        IntArrayList startArray;
        IntArrayList endArray;
        ArrayList<String> nameList;
        FloatArrayList[] dataArray;

        RawTile(String dsName, int tileNumber, int start, int end) {
            this.dsName = dsName;
            this.tileNumber = tileNumber;
            this.tileStart = start;
            this.tileEnd = end;
            this.startArray = new IntArrayList();
            this.endArray = new IntArrayList();
            this.dataArray = new FloatArrayList[Preprocessor.this.nTracks];
            for (int i2 = 0; i2 < Preprocessor.this.nTracks; ++i2) {
                this.dataArray[i2] = new FloatArrayList();
            }
        }

        void addData(int start, int end, float[] data, String name) {
            if (start > this.tileEnd) {
                log.warn("Warning: start position > tile end");
            }
            if (end < this.tileStart) {
                log.warn("Warning: end position > tile end");
            }
            if (name != null && this.nameList == null) {
                this.nameList = new ArrayList();
            }
            int dataStart = Math.max(this.tileStart, start);
            int dataEnd = Math.min(this.tileEnd, end);
            this.startArray.add(dataStart);
            this.endArray.add(dataEnd);
            for (int i2 = 0; i2 < data.length; ++i2) {
                this.dataArray[i2].add(data[i2]);
            }
            if (name != null) {
                this.nameList.add(name);
            }
        }

        void close() {
            try {
                if (this.startArray.size() > 0) {
                    int[] s2 = this.startArray.toArray();
                    int[] e2 = this.endArray.toArray();
                    float[][] d2 = new float[this.dataArray.length][this.dataArray[0].size()];
                    for (int i2 = 0; i2 < this.dataArray.length; ++i2) {
                        d2[i2] = this.dataArray[i2].toArray();
                    }
                    String[] n2 = this.nameList == null ? null : this.nameList.toArray(new String[0]);
                    TDFBedTile tile = new TDFBedTile(this.tileStart, s2, e2, d2, n2);
                    Preprocessor.this.writer.writeTile(this.dsName, this.tileNumber, tile);
                    this.startArray.clear();
                    this.endArray.clear();
                    for (int i3 = 0; i3 < this.dataArray.length; ++i3) {
                        this.dataArray[i3].clear();
                    }
                }
            }
            catch (IOException ex) {
                log.error(ex.getMessage(), ex);
            }
        }
    }
}

