/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.sam.EmptyAlignmentIterator;
import org.broad.igv.sam.SamAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.sam.reader.IndexNotFoundException;
import org.broad.igv.sam.reader.SAMQueryIterator;
import org.broad.igv.sam.reader.SamUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class SAMReader
implements AlignmentReader<SamAlignment> {
    static Logger log = Logger.getLogger(SAMReader.class);
    String samFile;
    FeatureIndex featureIndex;
    SAMFileHeader header;
    List<String> sequenceNames;

    public SAMReader(String samFile) throws IOException {
        this(samFile, true);
    }

    public SAMReader(String samFile, boolean requireIndex) throws IOException {
        this.samFile = samFile;
        this.loadHeader();
        if (requireIndex) {
            this.featureIndex = SamUtils.getIndexFor(samFile);
            if (this.featureIndex == null) {
                throw new IndexNotFoundException(samFile);
            }
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.header;
    }

    @Override
    public Set<String> getPlatforms() {
        return AlignmentReaderFactory.getPlatforms(this.getFileHeader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeader() {
        InputStream is = null;
        SAMFileReader reader = null;
        try {
            is = ParsingUtils.openInputStreamGZ(new ResourceLocator(this.samFile));
            BufferedInputStream bis = new BufferedInputStream(is);
            SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            reader = new SAMFileReader(bis);
            this.header = reader.getFileHeader();
        }
        catch (IOException e2) {
            log.error("Error loading header", e2);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public CloseableIterator<SamAlignment> query(String sequence, int start, int end, boolean contained) {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        if (this.featureIndex == null) {
            throw new UnsupportedOperationException("SAM files must be indexed to support query methods");
        }
        if (!this.featureIndex.containsChromosome(sequence)) {
            return EmptyAlignmentIterator.getInstance();
        }
        int startAdjustment = contained ? 0 : this.featureIndex.getLongestFeature(sequence);
        int startTileNumber = Math.max(0, start - startAdjustment) / this.featureIndex.getTileWidth();
        FeatureIndex.TileDef seekPos = this.featureIndex.getTileDef(sequence, startTileNumber);
        if (seekPos != null) {
            SAMFileReader reader = this.getSAMFileReader(this.samFile, seekPos.getStartPosition());
            SAMRecordIterator iter = reader.iterator();
            return new SAMQueryIterator(sequence, start, end, contained, iter);
        }
        return EmptyAlignmentIterator.getInstance();
    }

    @Override
    public boolean hasIndex() {
        if (this.featureIndex == null) {
            this.getIndex();
        }
        return this.featureIndex != null;
    }

    @Override
    public void close() throws IOException {
    }

    private FeatureIndex getIndex() {
        if (this.featureIndex == null) {
            this.featureIndex = SamUtils.getIndexFor(this.samFile);
        }
        return this.featureIndex;
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            FeatureIndex idx = this.getIndex();
            if (idx == null) {
                return null;
            }
            this.sequenceNames = new ArrayList<String>(idx.getIndexedChromosomes());
        }
        return this.sequenceNames;
    }

    @Override
    public CloseableIterator<SamAlignment> iterator() {
        SAMFileReader reader = this.getSAMFileReader(this.samFile, -1L);
        SAMRecordIterator iter = reader.iterator();
        return new SAMQueryIterator(iter);
    }

    private SAMFileReader getSAMFileReader(String samFile, long startPosition) {
        try {
            SeekableStream stream = IGVSeekableStreamFactory.getInstance().getStreamFor(samFile);
            if (startPosition >= 0L) {
                stream.seek(startPosition);
            }
            SAMFileReader reader = new SAMFileReader(stream);
            reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            return reader;
        }
        catch (IOException ex) {
            log.error("Error opening sam file", ex);
            throw new RuntimeException("Error opening: " + samFile, ex);
        }
    }
}

