/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Range;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.Row;

public class PackedAlignments
extends LinkedHashMap<String, List<Row>> {
    private AlignmentTrack.RenderOptions renderOptions;
    private List<? extends Range> ranges;

    PackedAlignments(List<? extends Range> ranges, Map<String, List<Row>> packedAlignments, AlignmentTrack.RenderOptions renderOptions) {
        super(packedAlignments);
        this.renderOptions = renderOptions;
        this.ranges = ranges;
    }

    public int getNLevels() {
        int intervalNLevels = 0;
        for (List rows : this.values()) {
            intervalNLevels += rows.size();
        }
        return intervalNLevels;
    }

    public boolean contains(String chr, int start, int end) {
        for (Range range : this.ranges) {
            if (!range.contains(chr, start, end)) continue;
            return true;
        }
        return false;
    }

    public List<? extends Range> getRanges() {
        return this.ranges;
    }
}

