/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.broad.igv.Globals;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.util.ResourceLocator;

public class EWigTrack
extends AbstractTrack {
    char[] nucleotides = new char[]{'A', 'C', 'G', 'T'};
    public static Color grey1 = new Color(230, 230, 230);
    Map<Character, TDFDataSource> baseSources;
    TDFDataSource scoreSource;

    public EWigTrack(ResourceLocator locator, Genome genome) {
        super(locator);
        TDFReader reader = TDFReader.getReader(locator.getPath());
        this.scoreSource = new TDFDataSource(reader, 4, "Pi", genome);
        this.setDataRange(new DataRange(0.0f, 0.0f, 10.0f));
        this.baseSources = new HashMap<Character, TDFDataSource>();
        for (int i2 = 0; i2 < 4; ++i2) {
            TDFDataSource src = new TDFDataSource(reader, i2, Character.toString(this.nucleotides[i2]), genome);
            this.baseSources.put(Character.valueOf(this.nucleotides[i2]), src);
        }
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        this.paint(context, rect);
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    private void paint(RenderContext context, Rectangle rect) {
        List<LocusScore> scores = this.scoreSource.getSummaryScoresForRange(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom());
        HashMap<Character, List<LocusScore>> nScores = new HashMap<Character, List<LocusScore>>();
        char[] arr$ = this.nucleotides;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c2 = Character.valueOf(arr$[i$]);
            nScores.put(c2, this.baseSources.get(c2).getSummaryScoresForRange(context.getChr(), (int)context.getOrigin(), (int)context.getEndLocation(), context.getZoom()));
        }
        for (int idx = 0; idx < scores.size(); ++idx) {
            LocusScore score = scores.get(idx);
            int startPosition = score.getStart();
            int endPosition = score.getEnd();
            int pX = (int)(rect.getX() + ((double)startPosition - context.getOrigin()) / context.getScale());
            int dX = Math.max(1, (int)(rect.getX() + ((double)endPosition - context.getOrigin()) / context.getScale()) - pX);
            if (dX > 4) {
                dX -= 2;
                ++pX;
            }
            if (pX + dX < 0) continue;
            if ((double)pX > context.getVisibleRect().getMaxX()) break;
            float totalCount = score.getScore();
            int pY = (int)rect.getMaxY() - 1;
            float dataMax = this.getDataRange().getMaximum();
            double height = (double)totalCount * rect.getHeight() / (double)dataMax;
            height = Math.min(height, (double)(rect.height - 1));
            for (char c3 : this.nucleotides) {
                try {
                    LocusScore ns = (LocusScore)((List)nScores.get(Character.valueOf(c3))).get(idx);
                    float count = ns.getScore() * totalCount;
                    Graphics2D tGraphics = context.getGraphic2DForColor(Globals.nucleotideColors.get(Character.valueOf(c3)));
                    int h2 = (int)Math.round((double)count * height / (double)totalCount);
                    h2 = Math.min(pY - rect.y, h2);
                    int baseY = pY - h2;
                    if (h2 > 0) {
                        tGraphics.fillRect(pX, baseY, dX, h2);
                    }
                    pY = baseY;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        context.getGraphic2DForColor(Color.gray).drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
    }

    public JPopupMenu getPopupMenu(MouseEvent evt) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        popupMenu.add(TrackMenuUtils.getTrackRenameItem(tmp));
        popupMenu.add(TrackMenuUtils.getChangeTrackHeightItem(tmp));
        popupMenu.add(TrackMenuUtils.getDataRangeItem(tmp));
        return popupMenu;
    }
}

