/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SpliceJunctionHelper;

public class AlignmentInterval
extends Locus {
    private static Logger log = Logger.getLogger(AlignmentInterval.class);
    Genome genome;
    private AlignmentCounts counts;
    private List<Alignment> alignments;
    private SpliceJunctionHelper spliceJunctionHelper;
    private List<DownsampledInterval> downsampledIntervals;
    private AlignmentTrack.RenderOptions renderOptions;

    AlignmentInterval(AlignmentInterval interval) {
        this(interval.getChr(), interval.getStart(), interval.getEnd(), interval.getAlignments(), interval.getCounts(), new SpliceJunctionHelper(interval.getSpliceJunctionHelper()), interval.getDownsampledIntervals(), interval.renderOptions);
    }

    public AlignmentInterval(String chr, int start, int end, List<Alignment> alignments, AlignmentCounts counts, SpliceJunctionHelper spliceJunctionHelper, List<DownsampledInterval> downsampledIntervals, AlignmentTrack.RenderOptions renderOptions) {
        super(chr, start, end);
        this.alignments = alignments;
        this.genome = GenomeManager.getInstance().getCurrentGenome();
        this.counts = counts;
        this.spliceJunctionHelper = spliceJunctionHelper;
        this.downsampledIntervals = downsampledIntervals;
        this.renderOptions = renderOptions;
    }

    static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f2 = features.get(idx);
            if (f2.contains(right)) {
                return f2;
            }
            if (f2.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    public byte getReference(int pos) {
        if (this.genome == null) {
            return 0;
        }
        return this.genome.getReference(this.getChr(), pos);
    }

    public AlignmentCounts getCounts() {
        return this.counts;
    }

    public int getCount(int pos, byte b2) {
        AlignmentCounts c2 = this.counts;
        if (pos >= c2.getStart() && pos < c2.getEnd()) {
            return c2.getCount(pos, b2);
        }
        return 0;
    }

    public int getMaxCount(int origin, int end) {
        return this.counts.getMaxCount(origin, end);
    }

    public int getTotalCount(int pos) {
        AlignmentCounts c2 = this.counts;
        if (pos >= c2.getStart() && pos < c2.getEnd()) {
            return c2.getTotalCount(pos);
        }
        return 0;
    }

    public int getDelCount(int pos) {
        AlignmentCounts c2 = this.counts;
        if (pos >= c2.getStart() && pos < c2.getEnd()) {
            return c2.getDelCount(pos);
        }
        return 0;
    }

    public List<Alignment> getAlignments() {
        return Collections.unmodifiableList(this.alignments);
    }

    public Iterator<Alignment> getAlignmentIterator() {
        return this.alignments.iterator();
    }

    public List<DownsampledInterval> getDownsampledIntervals() {
        return this.downsampledIntervals;
    }

    public SpliceJunctionHelper getSpliceJunctionHelper() {
        return this.spliceJunctionHelper;
    }

    public Range getRange() {
        return new Range(this.getChr(), this.getStart(), this.getEnd());
    }

    static class AlignmentIterator
    implements Iterator<Alignment> {
        PriorityQueue<Row> rows = new PriorityQueue<Row>(5, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                return o1.getNextStartPos() - o2.getNextStartPos();
            }
        });
        Alignment nextAlignment;

        AlignmentIterator(Map<String, List<Row>> groupedAlignmentRows) {
            for (List<Row> alignmentRows : groupedAlignmentRows.values()) {
                for (Row r2 : alignmentRows) {
                    r2.resetIdx();
                    this.rows.add(r2);
                }
            }
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public Alignment next() {
            Alignment tmp = this.nextAlignment;
            if (tmp != null) {
                this.advance();
            }
            return tmp;
        }

        private void advance() {
            this.nextAlignment = null;
            Row nextRow = null;
            block0: while (this.nextAlignment == null && !this.rows.isEmpty()) {
                while ((nextRow = this.rows.poll()) != null) {
                    if (!nextRow.hasNext()) continue;
                    this.nextAlignment = nextRow.nextAlignment();
                    continue block0;
                }
            }
            if (nextRow != null && this.nextAlignment != null) {
                this.rows.add(nextRow);
            }
        }

        @Override
        public void remove() {
        }
    }
}

