/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.goby;

import com.google.protobuf.ByteString;
import edu.cornell.med.icb.goby.alignments.Alignments;
import edu.cornell.med.icb.goby.alignments.EntryFlagHelper;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.lang.MutableString;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.data.CharArrayList;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.goby.GobyAlignmentIterator;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public class GobyAlignment
implements Alignment {
    private static final Logger LOG = Logger.getLogger(GobyAlignment.class);
    protected final Alignments.AlignmentEntry entry;
    private final GobyAlignmentIterator iterator;
    protected AlignmentBlock[] block = new AlignmentBlock[1];
    protected AlignmentBlock[] insertionBlock;
    private CharArrayList gapTypes = null;
    private static final ReadMate unmappedMate = new ReadMate("*", -1, false, true);
    private Comparator<? super AlignmentBlock> blockComparator = new Comparator<AlignmentBlock>(){

        @Override
        public int compare(AlignmentBlock alignmentBlock, AlignmentBlock alignmentBlock1) {
            return alignmentBlock.getStart() - alignmentBlock1.getStart();
        }
    };

    public GobyAlignment(GobyAlignmentIterator iterator, Alignments.AlignmentEntry entry) {
        this.iterator = iterator;
        this.entry = entry;
        this.buildBlocks(entry);
    }

    private boolean hasReadInsertion(String from) {
        return from.length() > 0 && from.charAt(0) == '-';
    }

    public void buildBlocks(Alignments.AlignmentEntry alignmentEntry) {
        int index;
        ObjectArrayList<AlignmentBlock> blocks = new ObjectArrayList<AlignmentBlock>();
        ObjectArrayList insertionBlocks = new ObjectArrayList();
        int start = alignmentEntry.getPosition();
        ByteArrayList bases = new ByteArrayList();
        ByteArrayList scores = new ByteArrayList();
        int readLength = alignmentEntry.getQueryLength();
        byte[] readBases = new byte[readLength];
        byte[] readQual = new byte[readLength];
        Arrays.fill(readBases, (byte)61);
        if (alignmentEntry.hasReadQualityScores()) {
            readQual = alignmentEntry.getReadQualityScores().toByteArray();
        } else {
            Arrays.fill(readQual, (byte)40);
        }
        int j2 = 0;
        int insertedBases = 0;
        int deletedBases = 0;
        int leftPadding = alignmentEntry.getQueryPosition();
        boolean showSoftClipped = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_SOFT_CLIPPED");
        if (showSoftClipped && this.entry.hasSoftClippedBasesLeft()) {
            int clipLength = this.entry.getSoftClippedBasesLeft().length();
            this.addSoftClipBlock(blocks, Math.max(0, this.entry.getPosition() - clipLength), this.entry.getSoftClippedBasesLeft(), readQual, this.entry.hasSoftClippedQualityLeft(), this.entry.getSoftClippedQualityLeft().toByteArray(), 0);
        }
        for (Alignments.SequenceVariation var : alignmentEntry.getSequenceVariationsList()) {
            int i2;
            String from = var.getFrom();
            int fromLength = from.length();
            String to = var.getTo();
            int toLength = from.length();
            int sequenceVariationLength = Math.max(fromLength, toLength);
            ByteString toQuality = var.getToQuality();
            if (this.hasReadInsertion(from)) {
                bases.clear();
                scores.clear();
                for (i2 = 0; i2 < sequenceVariationLength; ++i2) {
                    int toChar = i2 >= toLength ? 45 : (int)to.charAt(i2);
                    int size = toQuality.size();
                    byte qual = size > 0 && i2 < size ? (byte)toQuality.byteAt(i2) : (byte)40;
                    bases.add((byte)toChar);
                    scores.add(qual);
                    ++deletedBases;
                }
                this.addBlock((ObjectArrayList<AlignmentBlock>)insertionBlocks, alignmentEntry.getPosition() + var.getPosition(), bases, scores);
                bases.clear();
                scores.clear();
                continue;
            }
            if (!to.contains("-")) {
                for (i2 = 0; i2 < toLength; ++i2) {
                    int offset = j2 + var.getPosition() + i2 - 1 + leftPadding - insertedBases;
                    if (offset <= 0 || offset >= readBases.length) continue;
                    readBases[offset] = (byte)to.charAt(i2);
                    if (i2 >= toQuality.size()) continue;
                    readQual[offset] = toQuality.byteAt(i2);
                }
                continue;
            }
            ++insertedBases;
        }
        int matchLength = alignmentEntry.getQueryAlignedLength() - deletedBases;
        int endAlignmentRefPosition = matchLength + start;
        bases.clear();
        scores.clear();
        int maxIndex = Math.min(readBases.length, readQual.length);
        for (int pos = start; pos < endAlignmentRefPosition && (index = pos - start + leftPadding) < maxIndex; ++pos) {
            bases.add(readBases[index]);
            scores.add(readQual[index]);
        }
        this.addBlock(blocks, start, bases, scores);
        blocks = this.introduceDeletions(blocks, this.entry);
        if (showSoftClipped && this.entry.hasSoftClippedBasesRight()) {
            int targetAlignedLength = this.entry.getTargetAlignedLength();
            this.addSoftClipBlock(blocks, this.entry.getPosition() + targetAlignedLength, this.entry.getSoftClippedBasesRight(), readQual, this.entry.hasSoftClippedQualityRight(), this.entry.getSoftClippedQualityRight().toByteArray(), this.entry.getQueryAlignedLength() + this.entry.getSoftClippedBasesLeft().length());
        }
        this.block = (AlignmentBlock[])blocks.toArray((Object[])new AlignmentBlock[blocks.size()]);
        Arrays.sort(this.block, this.blockComparator);
        this.insertionBlock = (AlignmentBlock[])insertionBlocks.toArray((Object[])new AlignmentBlock[insertionBlocks.size()]);
        Arrays.sort(this.insertionBlock, this.blockComparator);
        ObjectArrayList<GobyAlignment> list = null;
        if ((alignmentEntry.hasSplicedForwardAlignmentLink() || alignmentEntry.hasSplicedBackwardAlignmentLink()) && (list = this.iterator.cacheSpliceComponent(this)).size() > 1 && this.spliceListIsValid(list)) {
            GobyAlignment spliceHeadAlignment = (GobyAlignment)list.get(0);
            ObjectArrayList splicedBlocks = new ObjectArrayList();
            splicedBlocks.addAll((Collection)ObjectArrayList.wrap((Object[])spliceHeadAlignment.block));
            splicedBlocks.addAll(blocks);
            spliceHeadAlignment.block = (AlignmentBlock[])splicedBlocks.toArray((Object[])new AlignmentBlock[splicedBlocks.size()]);
            ObjectArrayList splicedInsertionBlocks = new ObjectArrayList();
            splicedInsertionBlocks.addAll((Collection)ObjectArrayList.wrap((Object[])spliceHeadAlignment.insertionBlock));
            splicedInsertionBlocks.addAll((Collection)insertionBlocks);
            spliceHeadAlignment.insertionBlock = (AlignmentBlock[])splicedInsertionBlocks.toArray((Object[])new AlignmentBlock[splicedInsertionBlocks.size()]);
            if (spliceHeadAlignment.gapTypes == null) {
                spliceHeadAlignment.gapTypes = new CharArrayList(10);
            }
            spliceHeadAlignment.gapTypes.add('N');
            this.block = this.keepSoftClips(this.block);
            this.insertionBlock = new AlignmentBlock[0];
        }
        this.block = this.removeNulls(this.block);
    }

    private AlignmentBlock[] removeNulls(AlignmentBlock[] block) {
        int nullCount = 0;
        for (int i2 = 0; i2 < block.length; ++i2) {
            AlignmentBlock alignmentBlock = block[i2];
            if (alignmentBlock != null) continue;
            ++nullCount;
        }
        if (nullCount == 0) {
            return block;
        }
        int newLength = block.length - nullCount;
        AlignmentBlock[] result = new AlignmentBlock[newLength];
        int j2 = 0;
        for (int i3 = 0; i3 < result.length; ++i3) {
            result[i3] = block[j2++];
        }
        return result;
    }

    private AlignmentBlock[] keepSoftClips(AlignmentBlock[] blocks) {
        int numSoftCLippedBlocks = 0;
        for (AlignmentBlock block : blocks) {
            if (!block.isSoftClipped()) continue;
            ++numSoftCLippedBlocks;
        }
        AlignmentBlock[] tmp = new AlignmentBlock[numSoftCLippedBlocks];
        int j2 = 0;
        for (int i2 = 0; i2 < numSoftCLippedBlocks; ++i2) {
            AlignmentBlock block;
            if (!(block = blocks[j2++]).isSoftClipped()) continue;
            tmp[i2] = block;
        }
        return tmp;
    }

    private void addSoftClipBlock(ObjectArrayList<AlignmentBlock> blocks, int position, String softClippedBasesLeft, byte[] readQualScores, boolean hasSoftClippedQuality, byte[] softClippedQuality, int j2) {
        int length = softClippedBasesLeft.length();
        byte[] bases = new byte[length];
        byte[] scores = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bases[i2] = (byte)softClippedBasesLeft.charAt(i2);
            scores[i2] = hasSoftClippedQuality ? softClippedQuality[i2] : readQualScores[j2++];
        }
        AlignmentBlock alignmentBlock = AlignmentBlock.getInstance(this.getChr(), position, bases, scores);
        alignmentBlock.setSoftClipped(true);
        blocks.add((Object)alignmentBlock);
    }

    boolean spliceListIsValid(ObjectArrayList<GobyAlignment> list) {
        if (list != null && list.size() > 1) {
            Alignments.AlignmentEntry prevEntry = ((GobyAlignment)list.get((int)0)).entry;
            for (int i2 = 1; i2 < list.size(); ++i2) {
                Alignments.AlignmentEntry currentEntry = ((GobyAlignment)list.get((int)i2)).entry;
                if (!currentEntry.hasSplicedBackwardAlignmentLink()) {
                    return false;
                }
                Alignments.RelatedAlignmentEntry currentBackwardLink = currentEntry.getSplicedBackwardAlignmentLink();
                if (prevEntry.getQueryIndex() != currentEntry.getQueryIndex() || prevEntry.getFragmentIndex() != currentBackwardLink.getFragmentIndex() || prevEntry.getPosition() != currentBackwardLink.getPosition() || prevEntry.getTargetIndex() != currentBackwardLink.getTargetIndex()) {
                    return false;
                }
                prevEntry = currentEntry;
            }
        }
        return true;
    }

    private ObjectArrayList<AlignmentBlock> introduceDeletions(ObjectArrayList<AlignmentBlock> blocks, Alignments.AlignmentEntry alignmentEntry) {
        ObjectArrayList newBlocks = new ObjectArrayList();
        for (Alignments.SequenceVariation var : alignmentEntry.getSequenceVariationsList()) {
            for (AlignmentBlock block : blocks) {
                if (block.isSoftClipped()) continue;
                int vrPos = var.getPosition() + this.entry.getPosition();
                if (!this.hasReadDeletion(var) || vrPos < block.getStart() || vrPos > block.getEnd()) continue;
                ByteArrayList leftBases = new ByteArrayList(block.getBases());
                ByteArrayList leftScores = new ByteArrayList(block.getQualities());
                ByteArrayList rightBases = new ByteArrayList(block.getBases());
                ByteArrayList rightScores = new ByteArrayList(block.getQualities());
                int deletionPosition = var.getPosition() - 1;
                leftBases = leftBases.subList(0, deletionPosition);
                rightBases = rightBases.subList(deletionPosition, rightBases.size());
                leftScores = leftScores.subList(0, deletionPosition);
                rightScores = rightScores.subList(deletionPosition, rightScores.size());
                AlignmentBlock left = AlignmentBlock.getInstance(this.getChr(), block.getStart(), leftBases.toByteArray(new byte[leftBases.size()]), leftScores.toByteArray(new byte[leftScores.size()]));
                AlignmentBlock right = AlignmentBlock.getInstance(this.getChr(), block.getStart() + leftBases.size() + var.getFrom().length(), rightBases.toByteArray(new byte[rightBases.size()]), rightScores.toByteArray(new byte[rightScores.size()]));
                blocks.remove((Object)block);
                newBlocks.add((Object)left);
                newBlocks.add((Object)right);
            }
        }
        newBlocks.addAll(blocks);
        return newBlocks;
    }

    private boolean hasReadDeletion(Alignments.SequenceVariation var) {
        return var.getTo().contains("-");
    }

    private int addBlock(ObjectArrayList<AlignmentBlock> blocks, int start, ByteArrayList bases, ByteArrayList scores) {
        blocks.add((Object)AlignmentBlock.getInstance(this.getChr(), start, bases.toByteArray(new byte[bases.size()]), scores.toByteArray(new byte[scores.size()])));
        bases.clear();
        scores.clear();
        return start += bases.size();
    }

    @Override
    public String getReadName() {
        return Integer.toString(this.entry.getQueryIndex());
    }

    @Override
    public String getReadSequence() {
        return "read-sequence";
    }

    @Override
    public String getChromosome() {
        return this.getChromosome(this.entry.getTargetIndex());
    }

    public String getChromosome(int targetIndex) {
        return "chr" + this.iterator.getId(targetIndex).toString();
    }

    @Override
    public String getChr() {
        return this.getChromosome();
    }

    @Override
    public int getAlignmentStart() {
        return this.entry.getPosition();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return this.block;
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        return this.insertionBlock;
    }

    @Override
    public char[] getGapTypes() {
        if (this.gapTypes == null) {
            return new char[0];
        }
        return this.gapTypes.toArray();
    }

    @Override
    public String getCigarString() {
        return null;
    }

    @Override
    public int getInferredInsertSize() {
        if (this.entry.hasInsertSize()) {
            return this.entry.getInsertSize();
        }
        return 0;
    }

    @Override
    public int getMappingQuality() {
        if (this.entry.hasMappingQuality()) {
            return this.entry.getMappingQuality();
        }
        return 255;
    }

    @Override
    public ReadMate getMate() {
        if (this.entry.hasPairAlignmentLink()) {
            Alignments.RelatedAlignmentEntry link = this.entry.getPairAlignmentLink();
            String mateChr = this.getChromosome(link.getTargetIndex());
            int mateStart = link.getPosition();
            boolean mateNegativeStrand = EntryFlagHelper.isMateReverseStrand((Alignments.AlignmentEntry)this.entry);
            boolean isReadUnmappedFlag = EntryFlagHelper.isReadUnmapped((Alignments.AlignmentEntry)this.entry);
            ReadMate mate = new ReadMate(mateChr, mateStart, mateNegativeStrand, isReadUnmappedFlag);
            return mate;
        }
        return unmappedMate;
    }

    @Override
    public boolean isProperPair() {
        if (this.entry.hasPairFlags()) {
            return EntryFlagHelper.isProperlyPaired((Alignments.AlignmentEntry)this.entry);
        }
        return false;
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public boolean isPaired() {
        if (this.entry.hasPairFlags()) {
            return EntryFlagHelper.isPaired((Alignments.AlignmentEntry)this.entry);
        }
        return false;
    }

    @Override
    public boolean isNegativeStrand() {
        return this.entry.getMatchingReverseStrand();
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public int getAlignmentEnd() {
        return this.entry.getPosition() + this.entry.getTargetAlignedLength();
    }

    @Override
    public String getSample() {
        return null;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public String getLibrary() {
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        if (this.isPaired()) {
            if (this.isFirstOfPair()) {
                return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
            }
            ReadMate mate = this.getMate();
            if (mate.isMapped() && this.isProperPair()) {
                return mate.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
            }
            return Strand.NONE;
        }
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        if (this.isPaired()) {
            if (this.isSecondOfPair()) {
                return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
            }
            ReadMate mate = this.getMate();
            if (mate.isMapped() && this.isProperPair()) {
                return mate.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
            }
            return Strand.NONE;
        }
        return Strand.NONE;
    }

    @Override
    public void setMateSequence(String sequence) {
    }

    @Override
    public String getPairOrientation() {
        String pairOrientation = "";
        if (EntryFlagHelper.isPaired((Alignments.AlignmentEntry)this.entry) && !EntryFlagHelper.isMateUnmapped((Alignments.AlignmentEntry)this.entry) && this.entry.getTargetIndex() == this.entry.getPairAlignmentLink().getTargetIndex()) {
            int s1 = EntryFlagHelper.isReadReverseStrand((Alignments.AlignmentEntry)this.entry) ? 82 : 70;
            int s2 = EntryFlagHelper.isMateReverseStrand((Alignments.AlignmentEntry)this.entry) ? 82 : 70;
            int o1 = 32;
            int o2 = 32;
            char[] tmp = new char[4];
            if (EntryFlagHelper.isFirstInPair((Alignments.AlignmentEntry)this.entry)) {
                o1 = 49;
                o2 = 50;
            } else if (EntryFlagHelper.isSecondInPair((Alignments.AlignmentEntry)this.entry)) {
                o1 = 50;
                o2 = 49;
            }
            if (this.getInferredInsertSize() > 0) {
                tmp[0] = s1;
                tmp[1] = o1;
                tmp[2] = s2;
                tmp[3] = o2;
            } else {
                tmp[2] = s1;
                tmp[3] = o1;
                tmp[0] = s2;
                tmp[1] = o2;
            }
            pairOrientation = new String(tmp);
        }
        return pairOrientation;
    }

    @Override
    public boolean isSmallInsert() {
        return false;
    }

    @Override
    public boolean isVendorFailedRead() {
        return false;
    }

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public int getStart() {
        return this.entry.getPosition();
    }

    @Override
    public int getEnd() {
        if (this.block.length == 0) {
            return this.getStart();
        }
        int last = this.block.length - 1;
        if (this.block[last] == null) {
            return this.entry.getPosition() + this.entry.getTargetAlignedLength();
        }
        return this.block[last].getEnd();
    }

    @Override
    public void setStart(int start) {
        throw new UnsupportedOperationException("setStart is not supported");
    }

    @Override
    public void setEnd(int end) {
        throw new UnsupportedOperationException("setEnd is not supported");
    }

    @Override
    public float getScore() {
        return this.entry.getScore();
    }

    public LocusScore copy() {
        return this;
    }

    @Override
    public String getClipboardString(double location) {
        return this.getValueString(location, null);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        MutableString buffer = new MutableString();
        buffer.append(this.entry.toString());
        buffer.replace("\n", "<br>");
        if (this.isPaired()) {
            buffer.append("----------------------<br>");
            buffer.append("Pair start = " + this.getMate().positionString() + "<br>");
            buffer.append("Pair is mapped = " + (this.getMate().isMapped() ? "yes" : "no") + "<br>");
            if (this.getChr().equals(this.getMate().getChr())) {
                buffer.append("Insert size = " + this.getInferredInsertSize() + "<br>");
            }
            if (this.getPairOrientation().length() > 0) {
                buffer.append("Pair orientation = " + this.getPairOrientation() + "<br>");
            }
            if (this.isFirstOfPair()) {
                buffer.append("First of pair <br>");
            }
            if (this.isSecondOfPair()) {
                buffer.append("Second of pair <br>");
            }
        }
        return buffer.toString();
    }

    @Override
    public byte getBase(double position) {
        int basePosition = (int)position;
        for (AlignmentBlock block : this.getAlignmentBlocks()) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte base = block.getBase(offset);
            return base;
        }
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        int basePosition = (int)position;
        for (AlignmentBlock block : this.getAlignmentBlocks()) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte score = block.getQuality(offset);
            return score;
        }
        return 0;
    }

    @Override
    public boolean isFirstOfPair() {
        return EntryFlagHelper.isFirstInPair((Alignments.AlignmentEntry)this.entry);
    }

    @Override
    public boolean isSecondOfPair() {
        return EntryFlagHelper.isSecondInPair((Alignments.AlignmentEntry)this.entry);
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isPrimary() {
        return !EntryFlagHelper.isNotPrimaryAlignment((Alignments.AlignmentEntry)this.entry);
    }

    @Override
    public boolean isSupplementary() {
        return false;
    }
}

