/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Strand;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;

public class GenbankParser {
    private static Logger log = Logger.getLogger(GenbankParser.class);
    private String path;
    private String accession;
    private byte[] sequence;
    private List<Feature> features;
    private String locusName;

    public GenbankParser(String path) throws IOException {
        this.path = path;
        this.readFeatures(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFeatures(boolean readSequence) throws IOException {
        BufferedReader reader = null;
        try {
            reader = ParsingUtils.openBufferedReader(this.path);
            this.readLocus(reader);
            this.readAccession(reader);
            this.readFeatures(reader);
            if (readSequence) {
                this.readOriginSequence(reader);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public byte[] getSequence(String chr, int qstart, int qend) {
        if (this.sequence == null) {
            return null;
        }
        int start = Math.max(0, qstart);
        int end = Math.min(this.sequence.length, qend);
        int len = end - start;
        byte[] bytes = new byte[len];
        Arrays.fill(bytes, (byte)0);
        int s2 = Math.max(start, 0);
        System.arraycopy(this.sequence, s2, bytes, 0, len);
        return bytes;
    }

    public int getSequenceLenth() {
        return this.sequence == null ? 0 : this.sequence.length;
    }

    private void readLocus(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        String[] tokens = Globals.whitespacePattern.split(line);
        if (!tokens[0].equalsIgnoreCase("LOCUS")) {
            // empty if block
        }
        this.locusName = tokens[1].trim();
    }

    private void readAccession(BufferedReader reader) throws IOException {
        String line = null;
        while (!(line = reader.readLine()).startsWith("ACCESSION")) {
        }
        if (line == null) {
            log.info("Genbank file missing ACCESSION line. ");
        } else {
            String[] tokens = Globals.whitespacePattern.split(line);
            if (tokens.length < 2) {
                log.info("Genbank file missing ACCESSION number.");
            } else {
                this.accession = tokens[1].trim();
            }
        }
    }

    private void readOriginSequence(BufferedReader reader) throws IOException {
        String nextLine;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100000);
        while ((nextLine = reader.readLine()) != null && !nextLine.startsWith("//")) {
            nextLine = nextLine.trim();
            String[] tokens = Globals.whitespacePattern.split(nextLine);
            for (int i2 = 1; i2 < tokens.length; ++i2) {
                buffer.write(tokens[i2].getBytes());
            }
        }
        this.sequence = buffer.toByteArray();
    }

    public String getChr() {
        return this.accession == null ? this.locusName : this.accession;
    }

    private void readFeatures(BufferedReader reader) throws IOException {
        String nextLine;
        while (!(nextLine = reader.readLine()).startsWith("FEATURES")) {
        }
        String chr = this.getChr();
        this.features = new ArrayList<Feature>();
        BasicFeature f2 = null;
        String currentLocQualifier = null;
        while ((nextLine = reader.readLine()) != null && !nextLine.startsWith("ORIGIN")) {
            if (nextLine.charAt(5) != ' ') {
                String featureType = nextLine.substring(5, 21).trim();
                f2 = new BasicFeature();
                f2.setChr(chr);
                f2.setType(featureType);
                currentLocQualifier = nextLine.substring(21);
                if (featureType.toLowerCase().equals("source")) continue;
                this.features.add(f2);
                continue;
            }
            String tmp = nextLine.substring(21).trim();
            if (tmp.length() <= 0) continue;
            if (tmp.charAt(0) == '/') {
                if (currentLocQualifier.charAt(0) == '/') {
                    String[] tokens = Globals.equalPattern.split(currentLocQualifier, 2);
                    if (tokens.length > 1) {
                        String keyName = tokens[0].length() > 1 ? tokens[0].substring(1) : "";
                        f2.setAttribute(keyName, tokens[1]);
                    }
                } else {
                    Strand strand = currentLocQualifier.contains("complement") ? Strand.NEGATIVE : Strand.POSITIVE;
                    f2.setStrand(strand);
                    String joinString = currentLocQualifier.replace("join", "");
                    joinString = joinString.replace("order", "");
                    joinString = joinString.replace("complement", "");
                    joinString = joinString.replace("(", "");
                    joinString = joinString.replace(")", "");
                    if (joinString.contains("..")) {
                        joinString = joinString.replace("<", "");
                        joinString = joinString.replace(">", "");
                        List<Exon> exons = this.createExons(joinString, strand);
                        FeatureUtils.sortFeatureList(exons);
                        Exon firstExon = exons.get(0);
                        f2.setStart(firstExon.getStart());
                        Exon lastExon = exons.get(exons.size() - 1);
                        f2.setEnd(lastExon.getEnd());
                        if (exons.size() > 1) {
                            for (Exon exon : exons) {
                                f2.addExon(exon);
                            }
                        }
                    } else {
                        int start = Integer.parseInt(joinString) - 1;
                        int end = start + 1;
                        f2.setStart(start);
                        f2.setEnd(end);
                    }
                }
                currentLocQualifier = tmp;
                continue;
            }
            currentLocQualifier = currentLocQualifier == null ? tmp : currentLocQualifier + tmp;
        }
    }

    List<Exon> createExons(String joinString, Strand strand) {
        String[] lociArray = joinString.split(",");
        ArrayList<Exon> exons = new ArrayList<Exon>(lociArray.length);
        boolean isNegative = joinString.contains("complement");
        for (String loci : lociArray) {
            String[] tmp = loci.split("\\.\\.");
            int exonStart = 0;
            try {
                exonStart = Integer.parseInt(tmp[0]) - 1;
            }
            catch (NumberFormatException e2) {
                e2.printStackTrace();
            }
            int exonEnd = exonStart + 1;
            if (tmp.length > 1) {
                exonEnd = Integer.parseInt(tmp[1]);
            }
            Exon r2 = new Exon(this.accession, exonStart, exonEnd, strand);
            exons.add(r2);
        }
        return exons;
    }

    public String getAccession() {
        return this.accession;
    }

    public byte[] getSequence() {
        return this.sequence;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public String getLocusName() {
        return this.locusName;
    }
}

