/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.dev.db;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broad.igv.dev.db.DBManager;
import org.broad.igv.dev.db.DBProfile;
import org.broad.igv.dev.db.DBQueryReader;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.track.FeatureSource;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineIteratorImpl;

public class SQLCodecSource
extends DBQueryReader<Feature>
implements FeatureSource {
    private static Logger log = Logger.getLogger(SQLCodecSource.class);
    public static String UCSC_CHROMO_COL = "chrom";
    public static String UCSC_START_COL = "txStart";
    public static String UCSC_END_COL = "txEnd";
    protected AsciiFeatureCodec codec;
    protected String chromoColName = UCSC_CHROMO_COL;
    protected String posStartColName = UCSC_START_COL;
    protected String posEndColName = UCSC_END_COL;
    protected String binColName;
    protected int startColIndex = 1;
    protected int endColIndex = Integer.MAX_VALUE;
    private int featureWindowSize = 1000000;
    private static final int MAX_BINS = 20;
    private static final int SMALLEST_BIN_SIZE = 131072;
    private static final int BINRANGE_MAXEND_512M = 0x20000000;
    private static final int _binOffsetOldToExtended = 4681;

    SQLCodecSource(DBProfile.DBTable table, AsciiFeatureCodec codec) {
        super(table);
        this.codec = codec;
        this.binColName = table.getBinColName();
        this.chromoColName = table.getChromoColName();
        this.posStartColName = table.getPosStartColName();
        this.posEndColName = table.getPosEndColName();
        this.startColIndex = table.getStartColIndex();
        this.endColIndex = table.getEndColIndex();
        this.readHeader();
    }

    private void readHeader() {
        Object[] columnLabels;
        List<String> headerLines = this.table.getHeaderLines();
        if (this.table.getColumnLabelMap() != null) {
            columnLabels = DBProfile.DBTable.columnMapToArray(this.table.getColumnLabelMap());
        } else {
            String queryString = String.format("SELECT * FROM %s WHERE 0 = 1", this.table.getName());
            ResultSet rs = this.executeQuery(queryString);
            try {
                columnLabels = DBManager.lineToArray(rs, this.table.getStartColIndex(), this.table.getEndColIndex(), true);
            }
            catch (SQLException e2) {
                log.error("Error reading column labels", e2);
                columnLabels = null;
            }
            DBManager.closeAll(rs);
        }
        if (columnLabels != null) {
            if (headerLines == null) {
                headerLines = new ArrayList<String>(1);
            }
            String columnLine = StringUtils.join((Object[])columnLabels, (String)"\t");
            columnLine = "#" + columnLine;
            headerLines.add(columnLine);
        }
        if (headerLines != null) {
            String lines = StringUtils.join(headerLines, (String)"\n");
            byte[] bytes = lines.getBytes();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            LineIteratorImpl reader = new LineIteratorImpl(new AsciiLineReader(is));
            try {
                this.codec.readHeader(reader);
            }
            catch (IOException e3) {
                log.error(e3.getMessage(), e3);
            }
        }
    }

    public static SQLCodecSource getFromTable(DBProfile.DBTable table) {
        FeatureCodec codec = CodecFactory.getCodec("." + table.getFormat(), GenomeManager.getInstance().getCurrentGenome());
        if (codec != null && codec instanceof AsciiFeatureCodec) {
            return new SQLCodecSource(table, (AsciiFeatureCodec)codec);
        }
        return null;
    }

    public static SQLCodecSource getFromProfile(String profilePath, String tableName) {
        DBProfile dbProfile = DBProfile.parseProfile(profilePath);
        SQLCodecSource source = null;
        for (DBProfile.DBTable table : dbProfile.getTableList()) {
            if (!table.getName().equals(tableName)) continue;
            source = SQLCodecSource.getFromTable(table);
            break;
        }
        return source;
    }

    private String rowToStringLine(ResultSet rs) throws SQLException {
        Object[] tokens = this.rowToStringArray(rs);
        return StringUtils.join((Object[])tokens, (String)"\t");
    }

    private String[] rowToStringArray(ResultSet rs) throws SQLException {
        String[] tokens = this.table.getColumnLabelMap() != null ? DBManager.lineToArray(rs, this.table.getColumnLabelMap()) : DBManager.lineToArray(rs, this.startColIndex, this.endColIndex, false);
        return tokens;
    }

    @Override
    protected Feature processResult(ResultSet rs) throws SQLException {
        String line = this.rowToStringLine(rs);
        return this.codec.decode(line);
    }

    private PreparedStatement generateQueryStatement(boolean useBinning) throws IOException {
        String prependWord = this.baseQueryString.contains("WHERE") ? " AND " : " WHERE ";
        String queryString = this.baseQueryString + prependWord + String.format("%s = ? AND ( (%s >= ? AND %s < ?)", this.chromoColName, this.posStartColName, this.posStartColName);
        if (this.posEndColName != null) {
            queryString = queryString + String.format(" OR (%s < ? AND %s >= ?)", this.posStartColName, this.posEndColName);
        }
        queryString = queryString + " )";
        String orderClause = "ORDER BY " + this.posStartColName;
        try {
            PreparedStatement queryStatement;
            if (useBinning) {
                Object[] qs = new String[20];
                Arrays.fill(qs, "?");
                String binnedQueryString = queryString + String.format(" AND %s IN (%s) %s", this.binColName, StringUtils.join((Object[])qs, (char)','), orderClause);
                queryStatement = DBManager.getConnection(this.locator).prepareStatement(binnedQueryString);
            } else {
                queryStatement = DBManager.getConnection(this.locator).prepareStatement(queryString + " " + orderClause);
            }
            return queryStatement;
        }
        catch (SQLException e2) {
            log.error("Error initializing query statement", e2);
            throw new IOException(e2);
        }
    }

    private Iterator query(String chr, int start, int end) throws IOException {
        Set<Integer> bins = null;
        boolean useBinning = false;
        if (this.binColName != null) {
            bins = this.calculateBins(start, end);
            useBinning = bins.size() < 20;
        }
        PreparedStatement statement = this.generateQueryStatement(useBinning);
        try {
            statement.clearParameters();
            statement.setString(1, chr);
            statement.setInt(3, end);
            int[] startCols = new int[]{2};
            if (this.posEndColName != null) {
                startCols = new int[]{2, 4, 5};
            }
            int[] arr$ = startCols;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer cc = arr$[i$];
                statement.setInt(cc, start);
            }
            if (useBinning) {
                int qnum = 6;
                for (Integer bin : bins) {
                    statement.setInt(qnum, bin);
                    ++qnum;
                }
                while (qnum <= statement.getParameterMetaData().getParameterCount()) {
                    statement.setNull(qnum, 4);
                    ++qnum;
                }
            }
        }
        catch (SQLException e2) {
            log.error(e2.getMessage(), e2);
            throw new IOException(e2);
        }
        return this.loadIterator(statement);
    }

    private Set<Integer> calculateBins(int start, int end) {
        int length = end - start;
        HashSet<Integer> bins = new HashSet<Integer>(2 * length / 131072);
        for (int sweepLength = 131072; sweepLength < 0x20000000; sweepLength *= 2) {
            int tstStart = Math.max(start - sweepLength / 2, 0);
            while (tstStart < end) {
                bins.add(SQLCodecSource.binFromRange(tstStart, tstStart += sweepLength));
                if (tstStart >= 0) continue;
                throw new IllegalArgumentException("Overflow while calculating bins");
            }
        }
        bins.add(SQLCodecSource.binFromRange(start, end));
        return bins;
    }

    public static int binFromRange(int start, int end) {
        if (start < 0 || end < 0) {
            throw new IllegalArgumentException("start " + start + ", end " + end + " must be > 0");
        }
        boolean extended = false;
        if (end > 0x20000000) {
            extended = true;
        }
        int[] binOffsetsExtended = new int[]{4681, 585, 73, 9, 1, 0};
        int[] binOffsets = Arrays.copyOfRange(binOffsetsExtended, extended ? 0 : 1, binOffsetsExtended.length);
        int _binFirstShift = 17;
        int _binNextShift = 3;
        int startBin = start;
        int endBin = end - 1;
        startBin >>= 17;
        endBin >>= 17;
        int bin = -1;
        for (int binOffset : binOffsets) {
            if (startBin == endBin) {
                bin = binOffset + startBin;
                if (!extended) break;
                bin += 4681;
                break;
            }
            startBin >>= 3;
            endBin >>= 3;
        }
        return bin;
    }

    Iterator iterator() throws IOException {
        String queryString = String.format("%s ORDER BY %s LIMIT %s", this.baseQueryString, this.posStartColName, this.featureWindowSize);
        return this.loadIterator(this.executeQuery(queryString));
    }

    public List<String> getSequenceNames() {
        String queryString = String.format("SELECT DISTINCT %s FROM %s", this.chromoColName, this.getTableName());
        ResultSet results = this.executeQuery(queryString);
        ArrayList<String> names = new ArrayList<String>();
        try {
            while (results.next()) {
                names.add(results.getString(1));
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
        catch (SQLException e2) {
            log.error(e2.getMessage(), e2);
            throw new RuntimeException(e2);
        }
        finally {
            DBManager.closeAll(results);
        }
    }

    public Iterator getFeatures(String chr, int start, int end) throws IOException {
        if (end - start > this.featureWindowSize) {
            return null;
        }
        return this.query(chr, start, end);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
    }
}

