/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class HC256Engine
implements StreamCipher {
    private int[] p = new int[1024];
    private int[] q = new int[1024];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private int step() {
        int ret;
        int j2 = this.cnt & 0x3FF;
        if (this.cnt < 1024) {
            int x2 = this.p[j2 - 3 & 0x3FF];
            int y = this.p[j2 - 1023 & 0x3FF];
            int n2 = j2;
            this.p[n2] = this.p[n2] + (this.p[j2 - 10 & 0x3FF] + (HC256Engine.rotateRight(x2, 10) ^ HC256Engine.rotateRight(y, 23)) + this.q[(x2 ^ y) & 0x3FF]);
            x2 = this.p[j2 - 12 & 0x3FF];
            ret = this.q[x2 & 0xFF] + this.q[(x2 >> 8 & 0xFF) + 256] + this.q[(x2 >> 16 & 0xFF) + 512] + this.q[(x2 >> 24 & 0xFF) + 768] ^ this.p[j2];
        } else {
            int x3 = this.q[j2 - 3 & 0x3FF];
            int y = this.q[j2 - 1023 & 0x3FF];
            int n3 = j2;
            this.q[n3] = this.q[n3] + (this.q[j2 - 10 & 0x3FF] + (HC256Engine.rotateRight(x3, 10) ^ HC256Engine.rotateRight(y, 23)) + this.p[(x3 ^ y) & 0x3FF]);
            x3 = this.q[j2 - 12 & 0x3FF];
            ret = this.p[x3 & 0xFF] + this.p[(x3 >> 8 & 0xFF) + 256] + this.p[(x3 >> 16 & 0xFF) + 512] + this.p[(x3 >> 24 & 0xFF) + 768] ^ this.q[j2];
        }
        this.cnt = this.cnt + 1 & 0x7FF;
        return ret;
    }

    private void init() {
        int i2;
        if (this.key.length != 32 && this.key.length != 16) {
            throw new IllegalArgumentException("The key must be 128/256 bits long");
        }
        if (this.iv.length < 16) {
            throw new IllegalArgumentException("The IV must be at least 128 bits long");
        }
        if (this.key.length != 32) {
            byte[] k2 = new byte[32];
            System.arraycopy(this.key, 0, k2, 0, this.key.length);
            System.arraycopy(this.key, 0, k2, 16, this.key.length);
            this.key = k2;
        }
        if (this.iv.length < 32) {
            byte[] newIV = new byte[32];
            System.arraycopy(this.iv, 0, newIV, 0, this.iv.length);
            System.arraycopy(this.iv, 0, newIV, this.iv.length, newIV.length - this.iv.length);
            this.iv = newIV;
        }
        this.cnt = 0;
        int[] w2 = new int[2560];
        for (i2 = 0; i2 < 32; ++i2) {
            int n2 = i2 >> 2;
            w2[n2] = w2[n2] | (this.key[i2] & 0xFF) << 8 * (i2 & 3);
        }
        for (i2 = 0; i2 < 32; ++i2) {
            int n3 = (i2 >> 2) + 8;
            w2[n3] = w2[n3] | (this.iv[i2] & 0xFF) << 8 * (i2 & 3);
        }
        for (i2 = 16; i2 < 2560; ++i2) {
            int x2 = w2[i2 - 2];
            int y = w2[i2 - 15];
            w2[i2] = (HC256Engine.rotateRight(x2, 17) ^ HC256Engine.rotateRight(x2, 19) ^ x2 >>> 10) + w2[i2 - 7] + (HC256Engine.rotateRight(y, 7) ^ HC256Engine.rotateRight(y, 18) ^ y >>> 3) + w2[i2 - 16] + i2;
        }
        System.arraycopy(w2, 512, this.p, 0, 1024);
        System.arraycopy(w2, 1536, this.q, 0, 1024);
        for (i2 = 0; i2 < 4096; ++i2) {
            this.step();
        }
        this.cnt = 0;
    }

    public String getAlgorithmName() {
        return "HC-256";
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        CipherParameters keyParam = params;
        if (params instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)params).getIV();
            keyParam = ((ParametersWithIV)params).getParameters();
        } else {
            this.iv = new byte[0];
        }
        if (!(keyParam instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC256 init - " + params.getClass().getName());
        }
        this.key = ((KeyParameter)keyParam).getKey();
        this.init();
        this.initialised = true;
    }

    private byte getByte() {
        if (this.idx == 0) {
            int step = this.step();
            this.buf[0] = (byte)(step & 0xFF);
            this.buf[1] = (byte)((step >>= 8) & 0xFF);
            this.buf[2] = (byte)((step >>= 8) & 0xFF);
            this.buf[3] = (byte)((step >>= 8) & 0xFF);
        }
        byte ret = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return ret;
    }

    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < len; ++i2) {
            out[outOff + i2] = (byte)(in[inOff + i2] ^ this.getByte());
        }
    }

    public void reset() {
        this.idx = 0;
        this.init();
    }

    public byte returnByte(byte in) {
        return (byte)(in ^ this.getByte());
    }

    private static int rotateRight(int x2, int bits) {
        return x2 >>> bits | x2 << -bits;
    }
}

