/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeader;

public class PKIMessage
extends ASN1Object {
    private PKIHeader header;
    private PKIBody body;
    private DERBitString protection;
    private ASN1Sequence extraCerts;

    private PKIMessage(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        this.header = PKIHeader.getInstance(en.nextElement());
        this.body = PKIBody.getInstance(en.nextElement());
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this.protection = DERBitString.getInstance(tObj, true);
                continue;
            }
            this.extraCerts = ASN1Sequence.getInstance(tObj, true);
        }
    }

    public static PKIMessage getInstance(Object o2) {
        if (o2 instanceof PKIMessage) {
            return (PKIMessage)o2;
        }
        if (o2 != null) {
            return new PKIMessage(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PKIMessage(PKIHeader header, PKIBody body, DERBitString protection, CMPCertificate[] extraCerts) {
        this.header = header;
        this.body = body;
        this.protection = protection;
        if (extraCerts != null) {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            for (int i2 = 0; i2 < extraCerts.length; ++i2) {
                v2.add(extraCerts[i2]);
            }
            this.extraCerts = new DERSequence(v2);
        }
    }

    public PKIMessage(PKIHeader header, PKIBody body, DERBitString protection) {
        this(header, body, protection, null);
    }

    public PKIMessage(PKIHeader header, PKIBody body) {
        this(header, body, null, null);
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public DERBitString getProtection() {
        return this.protection;
    }

    public CMPCertificate[] getExtraCerts() {
        if (this.extraCerts == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.extraCerts.size()];
        for (int i2 = 0; i2 < results.length; ++i2) {
            results[i2] = CMPCertificate.getInstance(this.extraCerts.getObjectAt(i2));
        }
        return results;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.header);
        v2.add(this.body);
        this.addOptional(v2, 0, this.protection);
        this.addOptional(v2, 1, this.extraCerts);
        return new DERSequence(v2);
    }

    private void addOptional(ASN1EncodableVector v2, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v2.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

