/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.util.CleanerThread;

public class SoftReferenceCache {
    protected final Map map = new HashMap();

    protected SoftReferenceCache() {
    }

    public synchronized void flush() {
        this.map.clear();
        this.notifyAll();
    }

    protected final synchronized boolean isPresentImpl(Object key) {
        if (!this.map.containsKey(key)) {
            return false;
        }
        Object o2 = this.map.get(key);
        if (o2 == null) {
            return true;
        }
        SoftReference sr = (SoftReference)o2;
        if ((o2 = sr.get()) != null) {
            return true;
        }
        this.clearImpl(key);
        return false;
    }

    protected final synchronized boolean isDoneImpl(Object key) {
        Object o2 = this.map.get(key);
        if (o2 == null) {
            return false;
        }
        SoftReference sr = (SoftReference)o2;
        if ((o2 = sr.get()) != null) {
            return true;
        }
        this.clearImpl(key);
        return false;
    }

    protected final synchronized Object requestImpl(Object key) {
        if (this.map.containsKey(key)) {
            SoftReference sr;
            Object o2 = this.map.get(key);
            while (o2 == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (!this.map.containsKey(key)) break;
                o2 = this.map.get(key);
            }
            if (o2 != null && (o2 = (sr = (SoftReference)o2).get()) != null) {
                return o2;
            }
        }
        this.map.put(key, null);
        return null;
    }

    protected final synchronized void clearImpl(Object key) {
        this.map.remove(key);
        this.notifyAll();
    }

    protected final synchronized void putImpl(Object key, Object object) {
        if (this.map.containsKey(key)) {
            SoftRefKey ref = new SoftRefKey(object, key);
            this.map.put(key, ref);
            this.notifyAll();
        }
    }

    class SoftRefKey
    extends CleanerThread.SoftReferenceCleared {
        Object key;

        public SoftRefKey(Object o2, Object key) {
            super(o2);
            this.key = key;
        }

        public void cleared() {
            SoftReferenceCache cache = SoftReferenceCache.this;
            if (cache == null) {
                return;
            }
            SoftReferenceCache softReferenceCache = cache;
            synchronized (softReferenceCache) {
                if (!cache.map.containsKey(this.key)) {
                    return;
                }
                Object o2 = cache.map.remove(this.key);
                if (this == o2) {
                    cache.notifyAll();
                } else {
                    cache.map.put(this.key, o2);
                }
            }
        }
    }
}

