/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class MultiplyAlphaRed
extends AbstractRed {
    public MultiplyAlphaRed(CachableRed src, CachableRed alpha) {
        super(MultiplyAlphaRed.makeList(src, alpha), MultiplyAlphaRed.makeBounds(src, alpha), MultiplyAlphaRed.fixColorModel(src), MultiplyAlphaRed.fixSampleModel(src), src.getTileGridXOffset(), src.getTileGridYOffset(), null);
    }

    public boolean is_INT_PACK_BYTE_COMP(SampleModel srcSM, SampleModel alpSM) {
        if (!(srcSM instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (!(alpSM instanceof ComponentSampleModel)) {
            return false;
        }
        if (srcSM.getDataType() != 3) {
            return false;
        }
        if (alpSM.getDataType() != 0) {
            return false;
        }
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)srcSM;
        int[] masks = sppsm.getBitMasks();
        if (masks.length != 4) {
            return false;
        }
        if (masks[0] != 0xFF0000) {
            return false;
        }
        if (masks[1] != 65280) {
            return false;
        }
        if (masks[2] != 255) {
            return false;
        }
        if (masks[3] != -16777216) {
            return false;
        }
        ComponentSampleModel csm = (ComponentSampleModel)alpSM;
        if (csm.getNumBands() != 1) {
            return false;
        }
        return csm.getPixelStride() == 1;
    }

    public WritableRaster INT_PACK_BYTE_COMP_Impl(WritableRaster wr) {
        CachableRed srcRed = (CachableRed)this.getSources().get(0);
        CachableRed alphaRed = (CachableRed)this.getSources().get(1);
        srcRed.copyData(wr);
        Rectangle rgn = wr.getBounds();
        rgn = rgn.intersection(alphaRed.getBounds());
        Raster r2 = alphaRed.getData(rgn);
        ComponentSampleModel csm = (ComponentSampleModel)r2.getSampleModel();
        int alpScanStride = csm.getScanlineStride();
        DataBufferByte alpDB = (DataBufferByte)r2.getDataBuffer();
        int alpBase = alpDB.getOffset() + csm.getOffset(rgn.x - r2.getSampleModelTranslateX(), rgn.y - r2.getSampleModelTranslateY());
        byte[] alpPixels = alpDB.getBankData()[0];
        SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)wr.getSampleModel();
        int srcScanStride = sppsm.getScanlineStride();
        DataBufferInt srcDB = (DataBufferInt)wr.getDataBuffer();
        int srcBase = srcDB.getOffset() + sppsm.getOffset(rgn.x - wr.getSampleModelTranslateX(), rgn.y - wr.getSampleModelTranslateY());
        int[] srcPixels = srcDB.getBankData()[0];
        ColorModel cm = srcRed.getColorModel();
        if (cm.isAlphaPremultiplied()) {
            int y = 0;
            while (y < rgn.height) {
                int sp = srcBase + y * srcScanStride;
                int ap = alpBase + y * alpScanStride;
                int end = sp + rgn.width;
                while (sp < end) {
                    int a2 = alpPixels[ap++] & 0xFF;
                    int pix = srcPixels[sp];
                    srcPixels[sp] = ((pix >>> 24) * a2 & 0xFF00) << 16 | ((pix >>> 16 & 0xFF) * a2 & 0xFF00) << 8 | (pix >>> 8 & 0xFF) * a2 & 0xFF00 | ((pix & 0xFF) * a2 & 0xFF00) >> 8;
                    ++sp;
                }
                ++y;
            }
        } else {
            int y = 0;
            while (y < rgn.height) {
                int sp = srcBase + y * srcScanStride;
                int ap = alpBase + y * alpScanStride;
                int end = sp + rgn.width;
                while (sp < end) {
                    int a3 = alpPixels[ap++] & 0xFF;
                    int sa = srcPixels[sp] >>> 24;
                    srcPixels[sp] = (sa * a3 & 0xFF00) << 16 | srcPixels[sp] & 0xFFFFFF;
                    ++sp;
                }
                ++y;
            }
        }
        return wr;
    }

    public WritableRaster copyData(WritableRaster wr) {
        CachableRed srcRed = (CachableRed)this.getSources().get(0);
        CachableRed alphaRed = (CachableRed)this.getSources().get(1);
        if (this.is_INT_PACK_BYTE_COMP(srcRed.getSampleModel(), alphaRed.getSampleModel())) {
            return this.INT_PACK_BYTE_COMP_Impl(wr);
        }
        ColorModel cm = srcRed.getColorModel();
        if (cm.hasAlpha()) {
            srcRed.copyData(wr);
            Rectangle rgn = wr.getBounds();
            if (!rgn.intersects(alphaRed.getBounds())) {
                return wr;
            }
            rgn = rgn.intersection(alphaRed.getBounds());
            int[] wrData = null;
            int[] alphaData = null;
            Raster r2 = alphaRed.getData(rgn);
            int w2 = rgn.width;
            int bands = wr.getSampleModel().getNumBands();
            if (cm.isAlphaPremultiplied()) {
                int y = rgn.y;
                while (y < rgn.y + rgn.height) {
                    wrData = wr.getPixels(rgn.x, y, w2, 1, wrData);
                    alphaData = r2.getSamples(rgn.x, y, w2, 1, 0, alphaData);
                    int i2 = 0;
                    switch (bands) {
                        case 2: {
                            int a2;
                            int x2 = 0;
                            while (x2 < alphaData.length) {
                                a2 = alphaData[x2] & 0xFF;
                                wrData[i2] = (wrData[i2] & 0xFF) * a2 >> 8;
                                wrData[++i2] = (wrData[i2] & 0xFF) * a2 >> 8;
                                ++i2;
                                ++x2;
                            }
                            break;
                        }
                        case 4: {
                            int a2;
                            int x3 = 0;
                            while (x3 < alphaData.length) {
                                a2 = alphaData[x3] & 0xFF;
                                wrData[i2] = (wrData[i2] & 0xFF) * a2 >> 8;
                                wrData[++i2] = (wrData[i2] & 0xFF) * a2 >> 8;
                                wrData[++i2] = (wrData[i2] & 0xFF) * a2 >> 8;
                                wrData[++i2] = (wrData[i2] & 0xFF) * a2 >> 8;
                                ++i2;
                                ++x3;
                            }
                            break;
                        }
                        default: {
                            int a2;
                            int x4 = 0;
                            while (x4 < alphaData.length) {
                                a2 = alphaData[x4] & 0xFF;
                                int b2 = 0;
                                while (b2 < bands) {
                                    wrData[i2] = (wrData[i2] & 0xFF) * a2 >> 8;
                                    ++i2;
                                    ++b2;
                                }
                                ++x4;
                            }
                            break block0;
                        }
                    }
                    wr.setPixels(rgn.x, y, w2, 1, wrData);
                    ++y;
                }
            } else {
                int b3 = srcRed.getSampleModel().getNumBands() - 1;
                int y = rgn.y;
                while (y < rgn.y + rgn.height) {
                    wrData = wr.getSamples(rgn.x, y, w2, 1, b3, wrData);
                    alphaData = r2.getSamples(rgn.x, y, w2, 1, 0, alphaData);
                    int i3 = 0;
                    while (i3 < wrData.length) {
                        wrData[i3] = (wrData[i3] & 0xFF) * (alphaData[i3] & 0xFF) >> 8;
                        ++i3;
                    }
                    wr.setSamples(rgn.x, y, w2, 1, b3, wrData);
                    ++y;
                }
            }
            return wr;
        }
        int[] bands = new int[wr.getNumBands() - 1];
        int i4 = 0;
        while (i4 < bands.length) {
            bands[i4] = i4;
            ++i4;
        }
        WritableRaster subWr = wr.createWritableChild(wr.getMinX(), wr.getMinY(), wr.getWidth(), wr.getHeight(), wr.getMinX(), wr.getMinY(), bands);
        srcRed.copyData(subWr);
        Rectangle rgn = wr.getBounds();
        rgn = rgn.intersection(alphaRed.getBounds());
        bands = new int[]{wr.getNumBands() - 1};
        subWr = wr.createWritableChild(rgn.x, rgn.y, rgn.width, rgn.height, rgn.x, rgn.y, bands);
        alphaRed.copyData(subWr);
        return wr;
    }

    public static List makeList(CachableRed src1, CachableRed src2) {
        ArrayList<CachableRed> ret = new ArrayList<CachableRed>(2);
        ret.add(src1);
        ret.add(src2);
        return ret;
    }

    public static Rectangle makeBounds(CachableRed src1, CachableRed src2) {
        Rectangle r1 = src1.getBounds();
        Rectangle r2 = src2.getBounds();
        return r1.intersection(r2);
    }

    public static SampleModel fixSampleModel(CachableRed src) {
        ColorModel cm = src.getColorModel();
        SampleModel srcSM = src.getSampleModel();
        if (cm.hasAlpha()) {
            return srcSM;
        }
        int w2 = srcSM.getWidth();
        int h2 = srcSM.getHeight();
        int b2 = srcSM.getNumBands() + 1;
        int[] offsets = new int[b2];
        int i2 = 0;
        while (i2 < b2) {
            offsets[i2] = i2;
            ++i2;
        }
        return new PixelInterleavedSampleModel(0, w2, h2, b2, w2 * b2, offsets);
    }

    public static ColorModel fixColorModel(CachableRed src) {
        ColorModel cm = src.getColorModel();
        if (cm.hasAlpha()) {
            return cm;
        }
        int b2 = src.getSampleModel().getNumBands() + 1;
        int[] bits = new int[b2];
        int i2 = 0;
        while (i2 < b2) {
            bits[i2] = 8;
            ++i2;
        }
        ColorSpace cs = cm.getColorSpace();
        return new ComponentColorModel(cs, bits, true, false, 3, 0);
    }
}

