/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.math.BigDecimal;

public class MathUtil {
    public static final double MAX_PROB_BELOW_ONE = 0.9999999999999999;
    public static final LogMath LOG_2_MATH = new LogMath(2.0);
    public static final LogMath NATURAL_LOG_MATH = new LogMath(Math.exp(1.0)){

        @Override
        public double getLogValue(double nonLogValue) {
            return Math.log(nonLogValue);
        }
    };
    public static final LogMath LOG_10_MATH = new LogMath(10.0){

        @Override
        public double getLogValue(double nonLogValue) {
            return Math.log10(nonLogValue);
        }
    };

    public static double mean(double[] in, int start, int stop) {
        double total = 0.0;
        for (int i2 = start; i2 < stop; ++i2) {
            total += in[i2];
        }
        return total / (double)(stop - start);
    }

    public static double stddev(double[] in, int start, int length) {
        return MathUtil.stddev(in, start, length, MathUtil.mean(in, start, length));
    }

    public static double stddev(double[] in, int start, int stop, double mean) {
        double total = 0.0;
        for (int i2 = start; i2 < stop; ++i2) {
            total += in[i2] * in[i2];
        }
        return Math.sqrt(total / (double)(stop - start) - mean * mean);
    }

    public static int compare(int v1, int v2) {
        return v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
    }

    public static Double percentageOrNull(Long numerator, Long denominator) {
        if (numerator != null && denominator != null && denominator != 0L) {
            return numerator.doubleValue() / denominator.doubleValue();
        }
        return null;
    }

    public static double round(double num, int precision) {
        BigDecimal bd = new BigDecimal(num);
        bd = bd.setScale(precision, 4);
        return bd.doubleValue();
    }

    public static double max(double[] nums) {
        double max = nums[0];
        for (int i2 = 1; i2 < nums.length; ++i2) {
            if (!(nums[i2] > max)) continue;
            max = nums[i2];
        }
        return max;
    }

    public static double min(double[] nums) {
        double min = nums[0];
        for (int i2 = 1; i2 < nums.length; ++i2) {
            if (!(nums[i2] < min)) continue;
            min = nums[i2];
        }
        return min;
    }

    public static double[] promote(int[] is) {
        double[] ds = new double[is.length];
        for (int i2 = 0; i2 < is.length; ++i2) {
            ds[i2] = is[i2];
        }
        return ds;
    }

    public static double[] logLikelihoodsToProbs(double[] likelihoods) {
        double maxLikelihood = MathUtil.max(likelihoods);
        double bump = 300.0 - maxLikelihood;
        double[] tmp = new double[likelihoods.length];
        double total = 0.0;
        for (int i2 = 0; i2 < likelihoods.length; ++i2) {
            tmp[i2] = Math.pow(10.0, likelihoods[i2] + bump);
            total += tmp[i2];
        }
        double maxP = 0.9999999999999999;
        double minP = (double)1.110223E-16f / (double)(tmp.length - 1);
        for (int i3 = 0; i3 < likelihoods.length; ++i3) {
            int n2 = i3;
            tmp[n2] = tmp[n2] / total;
            if (tmp[i3] > 0.9999999999999999) {
                tmp[i3] = 0.9999999999999999;
                continue;
            }
            if (!(tmp[i3] < minP)) continue;
            tmp[i3] = minP;
        }
        return tmp;
    }

    public static double[] multiply(double[] lhs, double[] rhs) {
        if (lhs.length != rhs.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int len = lhs.length;
        double[] result = new double[len];
        for (int i2 = 0; i2 < len; ++i2) {
            result[i2] = lhs[i2] * rhs[i2];
        }
        return result;
    }

    public static double sum(double[] arr) {
        double result = 0.0;
        for (double next : arr) {
            result += next;
        }
        return result;
    }

    public static class LogMath {
        private final double base;

        private LogMath(double base) {
            this.base = base;
        }

        public double getNonLogValue(double logValue) {
            return Math.pow(this.base, logValue);
        }

        public double getLogValue(double nonLogValue) {
            return Math.log(nonLogValue) / Math.log(this.base);
        }

        public double mean(double ... logValues) {
            return this.sum(logValues) - this.getLogValue(logValues.length);
        }

        public double sum(double ... logValues) {
            double scalingFactor = MathUtil.max(logValues);
            double simpleAdditionResult = 0.0;
            for (double v2 : logValues) {
                simpleAdditionResult += this.getNonLogValue(v2 - scalingFactor);
            }
            return this.getLogValue(simpleAdditionResult) + scalingFactor;
        }

        public double product(double ... logValues) {
            return MathUtil.sum(logValues);
        }
    }
}

