/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.AbstractAlignmentMerger;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.DelegatingIterator;
import net.sf.samtools.util.SortingCollection;

public class SamAlignmentMerger
extends AbstractAlignmentMerger {
    private final Log log = Log.getInstance(SamAlignmentMerger.class);
    private final List<File> alignedSamFile;
    private final List<File> read1AlignedSamFile;
    private final List<File> read2AlignedSamFile;
    private final int maxGaps;
    private boolean forceSort = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SamAlignmentMerger(File unmappedBamFile, File targetBamFile, File referenceFasta, SAMProgramRecord programRecord, boolean clipAdapters, boolean bisulfiteSequence, boolean pairedRun, boolean alignedReadsOnly, List<File> alignedSamFile, int maxGaps, List<String> attributesToRetain, Integer read1BasesTrimmed, Integer read2BasesTrimmed, List<File> read1AlignedSamFile, List<File> read2AlignedSamFile, List<SamPairUtil.PairOrientation> expectedOrientations, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        super(unmappedBamFile, targetBamFile, referenceFasta, clipAdapters, bisulfiteSequence, alignedReadsOnly, programRecord, attributesToRetain, read1BasesTrimmed, read2BasesTrimmed, expectedOrientations, sortOrder, primaryAlignmentSelectionStrategy);
        if (!(alignedSamFile != null && alignedSamFile.size() != 0 || read1AlignedSamFile != null && read1AlignedSamFile.size() != 0 && read2AlignedSamFile != null && read2AlignedSamFile.size() != 0)) {
            throw new IllegalArgumentException("Either alignedSamFile or BOTH of read1AlignedSamFile and read2AlignedSamFile must be specified.");
        }
        if (alignedSamFile != null) {
            for (File f2 : alignedSamFile) {
                IoUtil.assertFileIsReadable(f2);
            }
        } else {
            for (File f2 : read1AlignedSamFile) {
                IoUtil.assertFileIsReadable(f2);
            }
            for (File f2 : read2AlignedSamFile) {
                IoUtil.assertFileIsReadable(f2);
            }
        }
        this.alignedSamFile = alignedSamFile;
        this.read1AlignedSamFile = read1AlignedSamFile;
        this.read2AlignedSamFile = read2AlignedSamFile;
        this.maxGaps = maxGaps;
        if (programRecord == null) {
            File tmpFile = this.alignedSamFile != null && this.alignedSamFile.size() > 0 ? this.alignedSamFile.get(0) : this.read1AlignedSamFile.get(0);
            SAMFileReader tmpReader = new SAMFileReader(tmpFile);
            tmpReader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            if (tmpReader.getFileHeader().getProgramRecords().size() == 1) {
                this.setProgramRecord(tmpReader.getFileHeader().getProgramRecords().get(0));
            }
            tmpReader.close();
        }
        if (this.getProgramRecord() != null) {
            SAMFileReader tmp = new SAMFileReader(unmappedBamFile);
            try {
                for (SAMProgramRecord pg : tmp.getFileHeader().getProgramRecords()) {
                    if (!pg.getId().equals(this.getProgramRecord().getId())) continue;
                    throw new PicardException("Program Record ID already in use in unmapped BAM file.");
                }
            }
            finally {
                tmp.close();
            }
        }
        this.log.info("Processing SAM file(s): " + alignedSamFile != null ? alignedSamFile : read1AlignedSamFile + "," + read2AlignedSamFile);
    }

    @Override
    public void mergeAlignment() {
        try {
            super.mergeAlignment();
        }
        catch (IllegalStateException e2) {
            this.forceSort = true;
            this.resetRefSeqFileWalker();
            super.mergeAlignment();
        }
    }

    @Override
    protected CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords() {
        SAMFileHeader header;
        CloseableIterator<SAMRecord> mergingIterator;
        if (this.alignedSamFile != null && this.alignedSamFile.size() > 0) {
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(this.alignedSamFile.size());
            ArrayList<SAMFileReader> readers = new ArrayList<SAMFileReader>(this.alignedSamFile.size());
            for (File f2 : this.alignedSamFile) {
                SAMFileReader r2 = new SAMFileReader(f2);
                headers.add(r2.getFileHeader());
                readers.add(r2);
            }
            SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, false);
            mergingIterator = new MergingSamRecordIterator(headerMerger, readers, true);
            header = headerMerger.getMergedHeader();
        } else {
            mergingIterator = new SeparateEndAlignmentIterator(this.read1AlignedSamFile, this.read2AlignedSamFile);
            header = ((SeparateEndAlignmentIterator)mergingIterator).getHeader();
        }
        if (!this.forceSort) {
            return mergingIterator;
        }
        final SortingCollection<SAMRecord> alignmentSorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(header), new SAMRecordQueryNameComparator(), 500000);
        int count = 0;
        while (mergingIterator.hasNext()) {
            alignmentSorter.add((SAMRecord)mergingIterator.next());
            if (++count <= 0 || count % 1000000 != 0) continue;
            this.log.info("Read " + count + " records from alignment SAM/BAM.");
        }
        this.log.info("Finished reading " + count + " total records from alignment SAM/BAM.");
        mergingIterator.close();
        return new DelegatingIterator<SAMRecord>(alignmentSorter.iterator()){

            @Override
            public void close() {
                super.close();
                alignmentSorter.cleanup();
            }
        };
    }

    @Override
    protected boolean ignoreAlignment(SAMRecord sam) {
        if (this.maxGaps == -1) {
            return false;
        }
        int gaps = 0;
        for (CigarElement el : sam.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.I && el.getOperator() != CigarOperator.D) continue;
            ++gaps;
        }
        return gaps > this.maxGaps;
    }

    public boolean getForceSort() {
        return this.forceSort;
    }

    private class SeparateEndAlignmentIterator
    implements CloseableIterator<SAMRecord> {
        private final PeekableIterator<SAMRecord> read1Iterator;
        private final PeekableIterator<SAMRecord> read2Iterator;
        private final SAMFileHeader header;

        public SeparateEndAlignmentIterator(List<File> read1Alignments, List<File> read2Alignments) {
            SAMFileReader r2;
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
            ArrayList<SAMFileReader> read1 = new ArrayList<SAMFileReader>(read1Alignments.size());
            ArrayList<SAMFileReader> read2 = new ArrayList<SAMFileReader>(read2Alignments.size());
            for (File f2 : read1Alignments) {
                r2 = new SAMFileReader(f2);
                headers.add(r2.getFileHeader());
                read1.add(r2);
            }
            for (File f2 : read2Alignments) {
                r2 = new SAMFileReader(f2);
                headers.add(r2.getFileHeader());
                read2.add(r2);
            }
            SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, false);
            this.read1Iterator = new PeekableIterator<SAMRecord>(new SuffixTrimingSamRecordIterator(new MergingSamRecordIterator(headerMerger, read1, true), "/1"));
            this.read2Iterator = new PeekableIterator<SAMRecord>(new SuffixTrimingSamRecordIterator(new MergingSamRecordIterator(headerMerger, read2, true), "/2"));
            this.header = headerMerger.getMergedHeader();
        }

        @Override
        public void close() {
            this.read1Iterator.close();
            this.read2Iterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.read1Iterator.hasNext() || this.read2Iterator.hasNext();
        }

        @Override
        public SAMRecord next() {
            if (this.read1Iterator.hasNext()) {
                if (this.read2Iterator.hasNext()) {
                    return this.read1Iterator.peek().getReadName().compareTo(this.read2Iterator.peek().getReadName()) <= 0 ? this.setPairFlags(this.read1Iterator.next(), true) : this.setPairFlags(this.read2Iterator.next(), false);
                }
                return this.setPairFlags(this.read1Iterator.next(), true);
            }
            return this.setPairFlags(this.read2Iterator.next(), false);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        public SAMFileHeader getHeader() {
            return this.header;
        }

        private SAMRecord setPairFlags(SAMRecord sam, boolean firstOfPair) {
            sam.setReadPairedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
            return sam;
        }
    }

    private class SuffixTrimingSamRecordIterator
    implements CloseableIterator<SAMRecord> {
        private final CloseableIterator<SAMRecord> underlyingIterator;
        private final String suffixToTrim;

        private SuffixTrimingSamRecordIterator(CloseableIterator<SAMRecord> underlyingIterator, String suffixToTrim) {
            this.underlyingIterator = underlyingIterator;
            this.suffixToTrim = suffixToTrim;
        }

        @Override
        public void close() {
            this.underlyingIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.underlyingIterator.hasNext();
        }

        @Override
        public SAMRecord next() {
            SAMRecord rec = (SAMRecord)this.underlyingIterator.next();
            String readName = rec.getReadName();
            if (readName.endsWith(this.suffixToTrim)) {
                rec.setReadName(readName.substring(0, readName.length() - this.suffixToTrim.length()));
            }
            return rec;
        }

        @Override
        public void remove() {
            this.underlyingIterator.remove();
        }
    }
}

