/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.FileAppendStreamLRUCache;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;

public class CoordinateSortedPairInfoMap<KEY, REC>
implements Iterable<Map.Entry<KEY, REC>> {
    private final int INVALID_SEQUENCE_INDEX = -2;
    private final File workDir = IoUtil.createTempDir("CSPI.", null);
    private int sequenceIndexOfMapInRam = -2;
    private Map<KEY, REC> mapInRam = null;
    private final FileAppendStreamLRUCache outputStreams;
    private final Codec<KEY, REC> elementCodec;
    private final Map<Integer, Integer> sizeOfMapOnDisk = new HashMap<Integer, Integer>();
    private boolean iterationInProgress = false;

    CoordinateSortedPairInfoMap(int maxOpenFiles, Codec<KEY, REC> elementCodec) {
        this.elementCodec = elementCodec;
        this.workDir.deleteOnExit();
        this.outputStreams = new FileAppendStreamLRUCache(maxOpenFiles);
    }

    public REC remove(int sequenceIndex, KEY key) {
        if (this.iterationInProgress) {
            throw new IllegalStateException("Cannot be called when iteration is in progress");
        }
        this.ensureSequenceLoaded(sequenceIndex);
        return this.mapInRam.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSequenceLoaded(int sequenceIndex) {
        block15: {
            try {
                Integer numRecords;
                File mapOnDisk;
                block16: {
                    if (this.sequenceIndexOfMapInRam == sequenceIndex) {
                        return;
                    }
                    if (this.mapInRam != null) {
                        File spillFile = this.makeFileForSequence(this.sequenceIndexOfMapInRam);
                        if (spillFile.exists()) {
                            throw new IllegalStateException(spillFile + " should not exist.");
                        }
                        if (!this.mapInRam.isEmpty()) {
                            OutputStream os = this.getOutputStreamForSequence(this.sequenceIndexOfMapInRam);
                            this.elementCodec.setOutputStream(os);
                            for (Map.Entry<KEY, REC> entry : this.mapInRam.entrySet()) {
                                this.elementCodec.encode(entry.getKey(), entry.getValue());
                            }
                            this.sizeOfMapOnDisk.put(this.sequenceIndexOfMapInRam, this.mapInRam.size());
                            this.mapInRam.clear();
                        }
                    } else {
                        this.mapInRam = new HashMap<KEY, REC>();
                    }
                    this.sequenceIndexOfMapInRam = sequenceIndex;
                    mapOnDisk = this.makeFileForSequence(sequenceIndex);
                    if (this.outputStreams.containsKey(mapOnDisk)) {
                        ((FileOutputStream)this.outputStreams.remove(mapOnDisk)).close();
                    }
                    numRecords = this.sizeOfMapOnDisk.remove(sequenceIndex);
                    if (!mapOnDisk.exists()) break block16;
                    if (numRecords == null) {
                        throw new IllegalStateException("null numRecords for " + mapOnDisk);
                    }
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(mapOnDisk);
                        this.elementCodec.setInputStream(is);
                        for (int i2 = 0; i2 < numRecords; ++i2) {
                            Map.Entry<KEY, REC> keyAndRecord = this.elementCodec.decode();
                            if (this.mapInRam.containsKey(keyAndRecord.getKey())) {
                                throw new PicardException("Value was put into PairInfoMap more than once.  " + sequenceIndex + ": " + keyAndRecord.getKey());
                            }
                            this.mapInRam.put(keyAndRecord.getKey(), keyAndRecord.getValue());
                        }
                    }
                    catch (Throwable throwable) {
                        CloserUtil.close(is);
                        throw throwable;
                    }
                    CloserUtil.close(is);
                    IOUtil.deleteFiles(mapOnDisk);
                    break block15;
                }
                if (numRecords != null && numRecords > 0) {
                    throw new IllegalStateException("Non-zero numRecords but " + mapOnDisk + " does not exist");
                }
            }
            catch (IOException e2) {
                throw new PicardException("Error loading new map from disk.", e2);
            }
        }
    }

    public void put(int sequenceIndex, KEY key, REC record) {
        if (this.iterationInProgress) {
            throw new IllegalStateException("Cannot be called when iteration is in progress");
        }
        if (sequenceIndex == this.sequenceIndexOfMapInRam) {
            if (this.mapInRam.containsKey(key)) {
                throw new IllegalArgumentException("Putting value into PairInfoMap that already existed. " + sequenceIndex + ": " + key);
            }
            this.mapInRam.put(key, record);
        } else {
            OutputStream os = this.getOutputStreamForSequence(sequenceIndex);
            this.elementCodec.setOutputStream(os);
            this.elementCodec.encode(key, record);
            Integer prevCount = this.sizeOfMapOnDisk.get(sequenceIndex);
            if (prevCount == null) {
                prevCount = 0;
            }
            this.sizeOfMapOnDisk.put(sequenceIndex, prevCount + 1);
        }
    }

    private File makeFileForSequence(int index) {
        File file = new File(this.workDir, index + ".tmp");
        file.deleteOnExit();
        return file;
    }

    private OutputStream getOutputStreamForSequence(int mateSequenceIndex) {
        return (OutputStream)this.outputStreams.get(this.makeFileForSequence(mateSequenceIndex));
    }

    public int size() {
        int total = this.sizeInRam();
        for (Integer mapSize : this.sizeOfMapOnDisk.values()) {
            if (mapSize == null) continue;
            total += mapSize.intValue();
        }
        return total;
    }

    public int sizeInRam() {
        return this.mapInRam != null ? this.mapInRam.size() : 0;
    }

    @Override
    public CloseableIterator<Map.Entry<KEY, REC>> iterator() {
        if (this.iterationInProgress) {
            throw new IllegalStateException("Cannot be called when iteration is in progress");
        }
        this.iterationInProgress = true;
        return new MapIterator();
    }

    static /* synthetic */ Map access$100(CoordinateSortedPairInfoMap x0) {
        return x0.sizeOfMapOnDisk;
    }

    public static interface Codec<KEY, REC> {
        public void setOutputStream(OutputStream var1);

        public void setInputStream(InputStream var1);

        public void encode(KEY var1, REC var2);

        public Map.Entry<KEY, REC> decode();
    }

    private class MapIterator
    implements CloseableIterator<Map.Entry<KEY, REC>> {
        private boolean closed = false;
        private Set<Integer> referenceIndices = new HashSet(CoordinateSortedPairInfoMap.access$100(CoordinateSortedPairInfoMap.this).keySet());
        private final Iterator<Integer> referenceIndexIterator;
        private Iterator<Map.Entry<KEY, REC>> currentReferenceIterator = null;

        private MapIterator() {
            if (CoordinateSortedPairInfoMap.this.sequenceIndexOfMapInRam != -2) {
                this.referenceIndices.add(CoordinateSortedPairInfoMap.this.sequenceIndexOfMapInRam);
            }
            this.referenceIndexIterator = this.referenceIndices.iterator();
            this.advanceToNextNonEmptyReferenceIndex();
        }

        private void advanceToNextNonEmptyReferenceIndex() {
            while (this.referenceIndexIterator.hasNext()) {
                int nextReferenceIndex = this.referenceIndexIterator.next();
                CoordinateSortedPairInfoMap.this.ensureSequenceLoaded(nextReferenceIndex);
                if (CoordinateSortedPairInfoMap.this.mapInRam.isEmpty()) continue;
                this.createIteratorForMapInRam();
                return;
            }
            this.currentReferenceIterator = null;
        }

        private void createIteratorForMapInRam() {
            this.currentReferenceIterator = CoordinateSortedPairInfoMap.this.mapInRam.entrySet().iterator();
        }

        @Override
        public void close() {
            this.closed = true;
            CoordinateSortedPairInfoMap.this.iterationInProgress = false;
        }

        @Override
        public boolean hasNext() {
            if (this.closed) {
                throw new IllegalStateException("Iterator has been closed");
            }
            if (this.currentReferenceIterator != null && !this.currentReferenceIterator.hasNext()) {
                throw new IllegalStateException("Should not happen");
            }
            return this.currentReferenceIterator != null;
        }

        @Override
        public Map.Entry<KEY, REC> next() {
            if (this.closed) {
                throw new IllegalStateException("Iterator has been closed");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry ret = this.currentReferenceIterator.next();
            if (!this.currentReferenceIterator.hasNext()) {
                this.advanceToNextNonEmptyReferenceIndex();
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

