/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Comparator;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

class ComparableSamRecordIterator
extends PeekableIterator<SAMRecord>
implements Comparable<ComparableSamRecordIterator> {
    private final Comparator<SAMRecord> comparator;
    private final SAMFileReader reader;

    public ComparableSamRecordIterator(SAMFileReader sam, CloseableIterator<SAMRecord> iterator, Comparator<SAMRecord> comparator) {
        super(iterator);
        this.reader = sam;
        this.comparator = comparator;
    }

    public SAMFileReader getReader() {
        return this.reader;
    }

    @Override
    public int compareTo(ComparableSamRecordIterator that) {
        if (this.comparator.getClass() != that.comparator.getClass()) {
            throw new IllegalStateException("Attempt to compare two ComparableSAMRecordIterators that have different orderings internally");
        }
        SAMRecord record = (SAMRecord)this.peek();
        SAMRecord record2 = (SAMRecord)that.peek();
        return this.comparator.compare(record, record2);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        return this.compareTo((ComparableSamRecordIterator)o2) == 0;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ComparableSamRecordIterator should not be hashed because it can change value");
    }
}

