/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import java.lang.reflect.Field;
import net.sf.picard.PicardException;
import net.sf.picard.util.FormatUtil;

public class MetricBase {
    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2.getClass() != this.getClass()) {
            return false;
        }
        for (Field f2 : this.getClass().getFields()) {
            try {
                Object lhs = f2.get(this);
                Object rhs = f2.get(o2);
                if (lhs == null) {
                    if (rhs == null || rhs == null) continue;
                    return false;
                }
                if (lhs.equals(rhs)) continue;
                return false;
            }
            catch (IllegalAccessException iae) {
                throw new PicardException("Could not read field " + f2.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (Field f2 : this.getClass().getFields()) {
            try {
                result = 31 * result + f2.get(this).hashCode();
            }
            catch (IllegalAccessException e2) {
                throw new PicardException("Could not read field " + f2.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        FormatUtil formatter = new FormatUtil();
        for (Field f2 : this.getClass().getFields()) {
            try {
                buffer.append(f2.getName());
                buffer.append("\t");
                buffer.append(formatter.format(f2.get(this)));
                buffer.append("\n");
            }
            catch (IllegalAccessException iae) {
                throw new PicardException("Could not read field " + f2.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return buffer.toString();
    }

    public boolean equals(MetricBase that) {
        for (Field field : this.getClass().getFields()) {
            try {
                if (field.get(this).equals(field.get(that))) continue;
                return false;
            }
            catch (IllegalAccessException ex) {
                return false;
            }
        }
        return true;
    }
}

