/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.RnaSeqMetrics;
import net.sf.picard.annotation.Gene;
import net.sf.picard.annotation.LocusFunction;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.PerUnitMetricCollector;
import net.sf.picard.metrics.SAMRecordMultiLevelCollector;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.MathUtil;
import net.sf.picard.util.OverlapDetector;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CoordMath;
import net.sf.samtools.util.SequenceUtil;

public class RnaSeqMetricsCollector
extends SAMRecordMultiLevelCollector<RnaSeqMetrics, Integer> {
    private final int minimumLength;
    private final StrandSpecificity strandSpecificity;
    private final double rrnaFragmentPercentage;
    private final Long ribosomalInitialValue;
    private final Set<Integer> ignoredSequenceIndices;
    private final OverlapDetector<Gene> geneOverlapDetector;
    private final OverlapDetector<Interval> ribosomalSequenceOverlapDetector;

    public RnaSeqMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, Long ribosomalBasesInitialValue, OverlapDetector<Gene> geneOverlapDetector, OverlapDetector<Interval> ribosomalSequenceOverlapDetector, HashSet<Integer> ignoredSequenceIndices, int minimumLength, StrandSpecificity strandSpecificity, double rrnaFragmentPercentage) {
        this.ribosomalInitialValue = ribosomalBasesInitialValue;
        this.ignoredSequenceIndices = ignoredSequenceIndices;
        this.geneOverlapDetector = geneOverlapDetector;
        this.ribosomalSequenceOverlapDetector = ribosomalSequenceOverlapDetector;
        this.minimumLength = minimumLength;
        this.strandSpecificity = strandSpecificity;
        this.rrnaFragmentPercentage = rrnaFragmentPercentage;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<RnaSeqMetrics, Integer, SAMRecord> makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitRnaSeqMetricsCollector(sample, library, readGroup, this.ribosomalInitialValue);
    }

    public static OverlapDetector<Interval> makeOverlapDetector(File samFile, SAMFileHeader header, File ribosomalIntervalsFile) {
        OverlapDetector<Interval> ribosomalSequenceOverlapDetector = new OverlapDetector<Interval>(0, 0);
        if (ribosomalIntervalsFile != null) {
            IntervalList ribosomalIntervals = IntervalList.fromFile(ribosomalIntervalsFile);
            try {
                SequenceUtil.assertSequenceDictionariesEqual(header.getSequenceDictionary(), ribosomalIntervals.getHeader().getSequenceDictionary());
            }
            catch (SequenceUtil.SequenceListsDifferException e2) {
                throw new PicardException("Sequence dictionaries differ in " + samFile.getAbsolutePath() + " and " + ribosomalIntervalsFile.getAbsolutePath(), e2);
            }
            ribosomalIntervals.unique();
            List<Interval> intervals = ribosomalIntervals.getIntervals();
            ribosomalSequenceOverlapDetector.addAll(intervals, intervals);
        }
        return ribosomalSequenceOverlapDetector;
    }

    public static HashSet<Integer> makeIgnoredSequenceIndicesSet(SAMFileHeader header, Set<String> ignoredSequence) {
        HashSet<Integer> ignoredSequenceIndices = new HashSet<Integer>();
        for (String sequenceName : ignoredSequence) {
            SAMSequenceRecord sequenceRecord = header.getSequence(sequenceName);
            if (sequenceRecord == null) {
                throw new PicardException("Unrecognized sequence " + sequenceName + " passed as argument to IGNORE_SEQUENCE");
            }
            ignoredSequenceIndices.add(sequenceRecord.getSequenceIndex());
        }
        return ignoredSequenceIndices;
    }

    private class PerUnitRnaSeqMetricsCollector
    implements PerUnitMetricCollector<RnaSeqMetrics, Integer, SAMRecord> {
        final RnaSeqMetrics metrics = new RnaSeqMetrics();
        private final Map<Gene.Transcript, int[]> coverageByTranscript = new HashMap<Gene.Transcript, int[]>();

        public PerUnitRnaSeqMetricsCollector(String sample, String library, String readGroup, Long ribosomalBasesInitialValue) {
            this.metrics.SAMPLE = sample;
            this.metrics.LIBRARY = library;
            this.metrics.READ_GROUP = readGroup;
            this.metrics.RIBOSOMAL_BASES = ribosomalBasesInitialValue;
        }

        @Override
        public void acceptRecord(SAMRecord rec) {
            Interval fragmentInterval;
            if (rec.getReadFailsVendorQualityCheckFlag() || rec.isSecondaryOrSupplementary()) {
                return;
            }
            this.metrics.PF_BASES += (long)rec.getReadLength();
            if (rec.getReadUnmappedFlag()) {
                return;
            }
            if (RnaSeqMetricsCollector.this.ignoredSequenceIndices.contains(rec.getReferenceIndex())) {
                ++this.metrics.IGNORED_READS;
                return;
            }
            Interval readInterval = new Interval(rec.getReferenceName(), rec.getAlignmentStart(), rec.getAlignmentEnd());
            if (!rec.getReadPairedFlag()) {
                fragmentInterval = readInterval;
            } else if (rec.getMateUnmappedFlag() || rec.getReferenceIndex() != rec.getMateReferenceIndex()) {
                fragmentInterval = null;
            } else {
                int fragmentStart = Math.min(rec.getAlignmentStart(), rec.getMateAlignmentStart());
                int fragmentEnd = CoordMath.getEnd(fragmentStart, Math.abs(rec.getInferredInsertSize()));
                fragmentInterval = new Interval(rec.getReferenceName(), fragmentStart, fragmentEnd);
            }
            if (fragmentInterval != null) {
                Collection overlappingRibosomalIntervals = RnaSeqMetricsCollector.this.ribosomalSequenceOverlapDetector.getOverlaps(fragmentInterval);
                int intersectionLength = 0;
                for (Interval overlappingInterval : overlappingRibosomalIntervals) {
                    int thisIntersectionLength = overlappingInterval.getIntersectionLength(fragmentInterval);
                    intersectionLength = Math.max(intersectionLength, thisIntersectionLength);
                }
                if ((double)intersectionLength / (double)fragmentInterval.length() >= RnaSeqMetricsCollector.this.rrnaFragmentPercentage) {
                    RnaSeqMetrics i$ = this.metrics;
                    i$.RIBOSOMAL_BASES = i$.RIBOSOMAL_BASES + (long)rec.getReadLength();
                    int numAlignedBases = 0;
                    for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
                        numAlignedBases += alignmentBlock.getLength();
                    }
                    this.metrics.PF_ALIGNED_BASES += (long)numAlignedBases;
                    return;
                }
            }
            Collection overlappingGenes = RnaSeqMetricsCollector.this.geneOverlapDetector.getOverlaps(readInterval);
            List<AlignmentBlock> alignmentBlocks = rec.getAlignmentBlocks();
            boolean overlapsExon = false;
            for (AlignmentBlock alignmentBlock : alignmentBlocks) {
                LocusFunction[] locusFunctions = new LocusFunction[alignmentBlock.getLength()];
                Arrays.fill((Object[])locusFunctions, 0, locusFunctions.length, (Object)LocusFunction.INTERGENIC);
                for (Gene gene : overlappingGenes) {
                    for (Gene.Transcript transcript : gene) {
                        transcript.assignLocusFunctionForRange(alignmentBlock.getReferenceStart(), locusFunctions);
                        int[] coverage = this.coverageByTranscript.get(transcript);
                        if (coverage == null) {
                            coverage = new int[transcript.length()];
                            this.coverageByTranscript.put(transcript, coverage);
                        }
                        transcript.addCoverageCounts(alignmentBlock.getReferenceStart(), CoordMath.getEnd(alignmentBlock.getReferenceStart(), alignmentBlock.getLength()), coverage);
                    }
                }
                block12: for (LocusFunction locusFunction : locusFunctions) {
                    ++this.metrics.PF_ALIGNED_BASES;
                    switch (locusFunction) {
                        case INTERGENIC: {
                            ++this.metrics.INTERGENIC_BASES;
                            continue block12;
                        }
                        case INTRONIC: {
                            ++this.metrics.INTRONIC_BASES;
                            continue block12;
                        }
                        case UTR: {
                            ++this.metrics.UTR_BASES;
                            overlapsExon = true;
                            continue block12;
                        }
                        case CODING: {
                            ++this.metrics.CODING_BASES;
                            overlapsExon = true;
                            continue block12;
                        }
                        case RIBOSOMAL: {
                            RnaSeqMetrics rnaSeqMetrics = this.metrics;
                            Long.valueOf(rnaSeqMetrics.RIBOSOMAL_BASES + 1L);
                            rnaSeqMetrics.RIBOSOMAL_BASES = rnaSeqMetrics.RIBOSOMAL_BASES;
                        }
                    }
                }
            }
            if (overlapsExon && RnaSeqMetricsCollector.this.strandSpecificity != StrandSpecificity.NONE && overlappingGenes.size() == 1) {
                boolean thisReadExpectedToAgree;
                boolean negativeTranscriptionStrand = ((Gene)overlappingGenes.iterator().next()).isNegativeStrand();
                boolean negativeReadStrand = rec.getReadNegativeStrandFlag();
                boolean readAndTranscriptStrandsAgree = negativeReadStrand == negativeTranscriptionStrand;
                boolean readOneOrUnpaired = !rec.getReadPairedFlag() || rec.getFirstOfPairFlag();
                boolean firstReadExpectedToAgree = RnaSeqMetricsCollector.this.strandSpecificity == StrandSpecificity.FIRST_READ_TRANSCRIPTION_STRAND;
                boolean bl = thisReadExpectedToAgree = readOneOrUnpaired == firstReadExpectedToAgree;
                if (readAndTranscriptStrandsAgree == thisReadExpectedToAgree) {
                    ++this.metrics.CORRECT_STRAND_READS;
                } else {
                    ++this.metrics.INCORRECT_STRAND_READS;
                }
            }
        }

        @Override
        public void finish() {
            if (this.metrics.PF_ALIGNED_BASES > 0L) {
                if (this.metrics.RIBOSOMAL_BASES != null) {
                    this.metrics.PCT_RIBOSOMAL_BASES = (double)this.metrics.RIBOSOMAL_BASES.longValue() / (double)this.metrics.PF_ALIGNED_BASES;
                }
                this.metrics.PCT_CODING_BASES = (double)this.metrics.CODING_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_UTR_BASES = (double)this.metrics.UTR_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTRONIC_BASES = (double)this.metrics.INTRONIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_INTERGENIC_BASES = (double)this.metrics.INTERGENIC_BASES / (double)this.metrics.PF_ALIGNED_BASES;
                this.metrics.PCT_MRNA_BASES = this.metrics.PCT_CODING_BASES + this.metrics.PCT_UTR_BASES;
                this.metrics.PCT_USABLE_BASES = (double)(this.metrics.CODING_BASES + this.metrics.UTR_BASES) / (double)this.metrics.PF_BASES;
            }
            if (this.metrics.CORRECT_STRAND_READS > 0L || this.metrics.INCORRECT_STRAND_READS > 0L) {
                this.metrics.PCT_CORRECT_STRAND_READS = (double)this.metrics.CORRECT_STRAND_READS / (double)(this.metrics.CORRECT_STRAND_READS + this.metrics.INCORRECT_STRAND_READS);
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<RnaSeqMetrics, Integer> file) {
            Histogram<Integer> normalizedCovByPos = this.computeCoverageMetrics();
            file.addMetric(this.metrics);
            file.addHistogram(normalizedCovByPos);
        }

        private Histogram<Integer> computeCoverageMetrics() {
            Histogram<Double> cvs = new Histogram<Double>();
            Histogram<Double> fivePrimeSkews = new Histogram<Double>();
            Histogram<Double> threePrimeSkews = new Histogram<Double>();
            Histogram gapBasesPerKb = new Histogram();
            Histogram<Double> fiveToThreeSkews = new Histogram<Double>();
            String prefix = null;
            prefix = this.metrics.READ_GROUP != null ? this.metrics.READ_GROUP + "." : (this.metrics.LIBRARY != null ? this.metrics.LIBRARY + "." : (this.metrics.SAMPLE != null ? this.metrics.SAMPLE + "." : "All_Reads."));
            Histogram<Integer> normalizedCoverageByNormalizedPosition = new Histogram<Integer>("normalized_position", prefix + "normalized_coverage");
            Map<Gene.Transcript, int[]> transcripts = this.pickTranscripts(this.coverageByTranscript);
            double transcriptCount = transcripts.size();
            for (Map.Entry<Gene.Transcript, int[]> entry : transcripts.entrySet()) {
                Gene.Transcript tx = entry.getKey();
                double[] tmp = MathUtil.promote(entry.getValue());
                double[] coverage = tx.getGene().isPositiveStrand() ? tmp : this.copyAndReverse(tmp);
                double mean = MathUtil.mean(coverage, 0, coverage.length);
                double stdev = MathUtil.stddev(coverage, 0, coverage.length, mean);
                double cv = stdev / mean;
                cvs.increment(cv);
                int PRIME_BASES = 100;
                double fivePrimeCoverage = MathUtil.mean(coverage, 0, 100);
                double threePrimeCoverage = MathUtil.mean(coverage, coverage.length - 100, coverage.length);
                fivePrimeSkews.increment(fivePrimeCoverage / mean);
                threePrimeSkews.increment(threePrimeCoverage / mean);
                fiveToThreeSkews.increment(fivePrimeCoverage / threePrimeCoverage);
                int lastIndex = coverage.length - 1;
                for (int percent = 0; percent <= 100; ++percent) {
                    double p2 = (double)percent / 100.0;
                    int start = (int)Math.max(0.0, (double)lastIndex * (p2 - 0.005));
                    int end = (int)Math.min((double)lastIndex, (double)lastIndex * (p2 + 0.005));
                    int length = end - start + 1;
                    double sum = 0.0;
                    for (int i2 = start; i2 <= end; ++i2) {
                        sum += coverage[i2];
                    }
                    double normalized = sum / (double)length / mean;
                    normalizedCoverageByNormalizedPosition.increment(percent, normalized / transcriptCount);
                }
            }
            this.metrics.MEDIAN_CV_COVERAGE = cvs.getMedian();
            this.metrics.MEDIAN_5PRIME_BIAS = fivePrimeSkews.getMedian();
            this.metrics.MEDIAN_3PRIME_BIAS = threePrimeSkews.getMedian();
            this.metrics.MEDIAN_5PRIME_TO_3PRIME_BIAS = fiveToThreeSkews.getMedian();
            return normalizedCoverageByNormalizedPosition;
        }

        private double[] copyAndReverse(double[] in) {
            double[] out = new double[in.length];
            int i2 = 0;
            int j2 = in.length - 1;
            while (i2 < in.length) {
                out[j2] = in[i2];
                ++i2;
                --j2;
            }
            return out;
        }

        public Map<Gene.Transcript, int[]> pickTranscripts(Map<Gene.Transcript, int[]> transcriptCoverage) {
            HashMap<Gene.Transcript, Double> bestPerGene = new HashMap<Gene.Transcript, Double>();
            for (Gene gene : RnaSeqMetricsCollector.this.geneOverlapDetector.getAll()) {
                Gene.Transcript best = null;
                double bestMean = 0.0;
                for (Gene.Transcript transcript : gene) {
                    double mean;
                    int[] cov = transcriptCoverage.get(transcript);
                    if (transcript.length() < Math.max(RnaSeqMetricsCollector.this.minimumLength, 100) || cov == null || (mean = MathUtil.mean(MathUtil.promote(cov), 0, cov.length)) < 1.0 || best != null && !(mean > bestMean)) continue;
                    best = transcript;
                    bestMean = mean;
                }
                if (best == null) continue;
                bestPerGene.put(best, bestMean);
            }
            double[] coverages = new double[bestPerGene.size()];
            int i2 = 0;
            Iterator i$ = bestPerGene.values().iterator();
            while (i$.hasNext()) {
                double d2 = (Double)i$.next();
                coverages[i2++] = d2;
            }
            Arrays.sort(coverages);
            double min = coverages.length == 0 ? 0.0 : coverages[Math.max(0, coverages.length - 1001)];
            HashMap<Gene.Transcript, int[]> retval = new HashMap<Gene.Transcript, int[]>();
            for (Map.Entry entry : bestPerGene.entrySet()) {
                Gene.Transcript tx = (Gene.Transcript)entry.getKey();
                double coverage = (Double)entry.getValue();
                if (!(coverage >= min)) continue;
                retval.put(tx, transcriptCoverage.get(tx));
            }
            return retval;
        }
    }

    public static enum StrandSpecificity {
        NONE,
        FIRST_READ_TRANSCRIPTION_STRAND,
        SECOND_READ_TRANSCRIPTION_STRAND;

    }
}

