/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import java.awt.Color;

public class HexColorConverter
extends ColorConverter {
    private boolean _alphaIncluded = false;

    public HexColorConverter() {
    }

    public HexColorConverter(boolean alphaIncluded) {
        this._alphaIncluded = alphaIncluded;
    }

    public boolean isAlphaIncluded() {
        return this._alphaIncluded;
    }

    public void setAlphaIncluded(boolean alphaIncluded) {
        this._alphaIncluded = alphaIncluded;
    }

    protected String getHexString(int color) {
        String value = Integer.toHexString(color).toUpperCase();
        if (value.length() == 1) {
            value = "0" + value;
        }
        return value;
    }

    public String toString(Object object, ConverterContext context) {
        if (object instanceof Color) {
            Color color = (Color)object;
            StringBuffer colorText = new StringBuffer("#");
            if (this.isAlphaIncluded()) {
                colorText.append(this.getHexString(color.getAlpha()));
            }
            colorText.append(this.getHexString(color.getRed()));
            colorText.append(this.getHexString(color.getGreen()));
            colorText.append(this.getHexString(color.getBlue()));
            return new String(colorText);
        }
        return "";
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public Object fromString(String string, ConverterContext context) {
        long value;
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (this.isAlphaIncluded()) {
            if (string.length() > 8) {
                string = string.substring(string.length() - 8);
            }
        } else if (string.length() > 6) {
            string = string.substring(string.length() - 6);
        }
        try {
            value = Long.parseLong(string, 16);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        return new Color((int)value, this.isAlphaIncluded());
    }
}

