/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ActivationRuleManager;
import com.google.java.contract.core.agent.ClassContractHandle;
import com.google.java.contract.core.agent.ContractAnalyzer;
import com.google.java.contract.core.agent.ContractFixingClassAdapter;
import com.google.java.contract.core.agent.ContractHandle;
import com.google.java.contract.core.agent.LineNumberingClassAdapter;
import com.google.java.contract.core.agent.MethodContractHandle;
import com.google.java.contract.core.agent.SpecificationClassAdapter;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.util.DebugUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"methodStart != null", "methodEnd != null", "contracts != null", "ClassName.isBinaryName(className)", "methodName != null", "methodDesc != null", "Iterables.all(oldValueLocals, Predicates.between(0, null))", "Iterables.all(signalOldValueLocals, Predicates.between(0, null))"})
public class SpecificationMethodAdapter
extends AdviceAdapter {
    private static final Type CLASS_TYPE = Type.getObjectType("java/lang/Class");
    private static final Type EXCEPTION_TYPE = Type.getObjectType("java/lang/Exception");
    private static final Type CONTRACT_RUNTIME_TYPE = Type.getObjectType("com/google/java/contract/core/runtime/ContractRuntime");
    private static final Type CONTRACT_CONTEXT_TYPE = Type.getObjectType("com/google/java/contract/core/runtime/ContractContext");
    private static final Method GET_CLASS_METHOD = Method.getMethod("java.lang.Class getClass()");
    private static final Method GET_CONTEXT_METHOD = Method.getMethod("com.google.java.contract.core.runtime.ContractContext getContext()");
    private static final Method TRY_ENTER_CONTRACT_METHOD = Method.getMethod("boolean tryEnterContract()");
    private static final Method LEAVE_CONTRACT_METHOD = Method.getMethod("void leaveContract()");
    private static final Method TRY_ENTER_METHOD = Method.getMethod("boolean tryEnter(Object)");
    private static final Method LEAVE_METHOD = Method.getMethod("void leave(Object)");
    protected Label methodStart = new Label();
    protected Label methodEnd = new Label();
    protected ContractAnalyzer contracts;
    protected String className;
    protected String methodName;
    protected String methodDesc;
    protected Type thisType;
    protected boolean statik;
    protected boolean isConstructor;
    protected boolean isStaticInit;
    protected int contextLocal;
    protected int checkInvariantsLocal;
    protected List<Integer> oldValueLocals;
    protected List<Integer> signalOldValueLocals;
    protected SpecificationClassAdapter classAdapter;
    protected boolean withPreconditions;
    protected boolean withPostconditions;
    protected boolean withInvariants;

    @Requires(value={"ca != null", "mv != null", "methodName != null", "methodDesc != null"})
    public SpecificationMethodAdapter(SpecificationClassAdapter specificationClassAdapter, MethodVisitor methodVisitor, int n2, String string, String string2) {
        super(methodVisitor, n2, string, string2);
        this.contracts = specificationClassAdapter.getContracts();
        this.className = specificationClassAdapter.getClassName();
        this.methodName = string;
        this.methodDesc = string2;
        this.thisType = Type.getType("L" + this.className + ";");
        this.statik = (n2 & 8) != 0;
        this.isConstructor = string.equals("<init>");
        this.isStaticInit = string.endsWith("<clinit>");
        this.contextLocal = -1;
        this.checkInvariantsLocal = -1;
        this.oldValueLocals = new ArrayList<Integer>();
        this.signalOldValueLocals = new ArrayList<Integer>();
        this.classAdapter = specificationClassAdapter;
        ActivationRuleManager activationRuleManager = ActivationRuleManager.getInstance();
        this.withPreconditions = activationRuleManager.hasPreconditionsEnabled(this.className);
        this.withPostconditions = activationRuleManager.hasPostconditionsEnabled(this.className);
        this.withInvariants = activationRuleManager.hasInvariantsEnabled(this.className);
    }

    @Requires(value={"label != null"})
    protected static boolean labelIsResolved(Label label) {
        try {
            label.getOffset();
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return true;
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        if (!SpecificationMethodAdapter.labelIsResolved(label)) {
            return;
        }
        if (!SpecificationMethodAdapter.labelIsResolved(label2)) {
            label2 = label;
        }
        super.visitLocalVariable(string, string2, string3, label, label2, n2);
    }

    @Override
    protected void onMethodEnter() {
        if (this.withPreconditions || this.withPostconditions || this.withInvariants) {
            this.enterContractedMethod();
            if (this.withPostconditions) {
                this.allocateOldValues(ContractKind.OLD, this.oldValueLocals);
                this.allocateOldValues(ContractKind.SIGNAL_OLD, this.signalOldValueLocals);
            }
            this.mark(this.methodStart);
            Label label = this.enterBusySection();
            if (this.withInvariants && !this.statik && !this.isConstructor && !this.isStaticInit) {
                this.invokeInvariants();
            }
            if (this.withPreconditions) {
                this.invokePreconditions();
            }
            if (this.withPostconditions) {
                this.invokeOldValues(ContractKind.OLD, this.oldValueLocals);
                this.invokeOldValues(ContractKind.SIGNAL_OLD, this.signalOldValueLocals);
            }
            this.leaveBusySection(label);
        }
    }

    @Override
    protected void onMethodExit(int n2) {
        if ((this.withPreconditions || this.withPostconditions || this.withInvariants) && n2 != 191) {
            if (this.withPostconditions || this.withInvariants) {
                Label label = this.enterBusySection();
                if (this.withPostconditions) {
                    Type type = Type.getReturnType(this.methodDesc);
                    int n3 = -1;
                    if (type.getSort() != 0) {
                        if (type.getSize() == 2) {
                            this.dup2();
                        } else {
                            this.dup();
                        }
                        n3 = this.newLocal(type);
                        this.storeLocal(n3);
                    }
                    this.invokeCommonPostconditions(ContractKind.POST, this.oldValueLocals, n3);
                }
                if (this.withInvariants && !this.statik) {
                    this.invokeInvariants();
                }
                this.leaveBusySection(label);
            }
            this.leaveContractedMethod();
        }
    }

    @Override
    public void visitMaxs(int n2, int n3) {
        if (this.withPreconditions || this.withPostconditions || this.withInvariants) {
            this.mark(this.methodEnd);
            this.catchException(this.methodStart, this.methodEnd, null);
            if (this.withPostconditions) {
                Label label = new Label();
                this.dup();
                this.instanceOf(EXCEPTION_TYPE);
                this.ifZCmp(153, label);
                Label label2 = this.enterBusySection();
                int n4 = this.newLocal(EXCEPTION_TYPE);
                this.checkCast(EXCEPTION_TYPE);
                this.storeLocal(n4);
                this.invokeCommonPostconditions(ContractKind.SIGNAL, this.signalOldValueLocals, n4);
                if (this.withInvariants && !this.statik) {
                    this.invokeInvariants();
                }
                this.loadLocal(n4);
                this.leaveBusySection(label2);
                this.mark(label);
            }
            this.leaveContractedMethod();
            this.throwException();
        }
        super.visitMaxs(n2, n3);
    }

    @Requires(value={"kind != null", "kind.isOld()", "list != null"})
    protected void allocateOldValues(ContractKind contractKind, List<Integer> list) {
        List<MethodContractHandle> list2 = this.contracts.getMethodHandles(contractKind, this.methodName, this.methodDesc, 0);
        if (list2.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[list2.size()];
        for (MethodContractHandle methodContractHandle : list2) {
            int n2 = methodContractHandle.getKey();
            integerArray[n2] = this.newLocal(Type.getReturnType(methodContractHandle.getContractMethod().desc));
            this.push((String)null);
            this.storeLocal(integerArray[n2]);
        }
        list.addAll(Arrays.asList(integerArray));
    }

    @Requires(value={"kind != null", "kind.isOld()", "list != null"})
    protected void invokeOldValues(ContractKind contractKind, List<Integer> list) {
        List<MethodContractHandle> list2 = this.contracts.getMethodHandles(contractKind, this.methodName, this.methodDesc, 0);
        if (list2.isEmpty()) {
            return;
        }
        for (MethodContractHandle methodContractHandle : list2) {
            MethodNode methodNode = this.injectContractMethod(methodContractHandle);
            int n2 = methodContractHandle.getKey();
            if (!this.statik) {
                this.loadThis();
            }
            this.loadArgs();
            this.invokeContractMethod(methodNode);
            this.storeLocal(list.get(n2));
        }
    }

    protected void invokeInvariants() {
        ClassContractHandle classContractHandle = this.contracts.getClassHandle(ContractKind.INVARIANT);
        if (classContractHandle == null) {
            return;
        }
        MethodNode methodNode = this.injectContractMethod(classContractHandle);
        Label label = new Label();
        if (this.isConstructor) {
            this.loadThis();
            this.invokeVirtual(this.thisType, GET_CLASS_METHOD);
            this.loadThisClass();
            this.ifCmp(CLASS_TYPE, 154, label);
        } else {
            this.loadLocal(this.checkInvariantsLocal);
            this.ifZCmp(153, label);
        }
        if (!this.statik) {
            this.loadThis();
        }
        this.invokeContractMethod(methodNode);
        this.mark(label);
    }

    protected void invokePreconditions() {
        MethodContractHandle methodContractHandle = this.contracts.getMethodHandle(ContractKind.PRE, this.methodName, this.methodDesc, 0);
        if (methodContractHandle == null) {
            return;
        }
        MethodNode methodNode = this.injectContractMethod(methodContractHandle);
        if (!this.statik) {
            this.loadThis();
        }
        this.loadArgs();
        this.invokeContractMethod(methodNode);
    }

    @Requires(value={"kind != null", "kind.isPostcondition()", "oldLocals != null", "extraIndex >= -1"})
    protected void invokeCommonPostconditions(ContractKind contractKind, List<Integer> list, int n2) {
        MethodContractHandle methodContractHandle = this.contracts.getMethodHandle(contractKind, this.methodName, this.methodDesc, this.getPostDescOffset(list, n2));
        if (methodContractHandle == null) {
            return;
        }
        MethodNode methodNode = this.injectContractMethod(methodContractHandle);
        if (!this.statik) {
            this.loadThis();
        }
        this.loadArgs();
        if (n2 != -1) {
            this.loadLocal(n2);
        }
        for (Integer n3 : list) {
            this.loadLocal(n3);
        }
        this.invokeContractMethod(methodNode);
    }

    @Requires(value={"oldLocals != null", "extraIndex >= -1"})
    @Ensures(value={"result >= 0"})
    protected int getPostDescOffset(List<Integer> list, int n2) {
        int n3 = 0;
        if (n2 != -1) {
            ++n3;
        }
        return n3 += list.size();
    }

    @Requires(value={"handle != null"})
    @Ensures(value={"result != null"})
    protected MethodNode injectContractMethod(ContractHandle contractHandle) {
        MethodNode methodNode = contractHandle.getContractMethod();
        if (!contractHandle.isInjected()) {
            DebugUtils.info("instrument", "contract method " + this.className + "." + methodNode.name + methodNode.desc);
            ClassVisitor classVisitor = this.classAdapter.getParent();
            List<Long> list = contractHandle.getLineNumbers();
            if (list != null) {
                classVisitor = new LineNumberingClassAdapter(classVisitor, list);
            }
            methodNode.accept(new ContractFixingClassAdapter(classVisitor));
            contractHandle.setInjected(true);
        }
        return methodNode;
    }

    @Requires(value={"contractMethod != null"})
    protected void invokeContractMethod(MethodNode methodNode) {
        if (!this.statik) {
            this.mv.visitMethodInsn(183, this.className, methodNode.name, methodNode.desc);
        } else {
            this.mv.visitMethodInsn(184, this.className, methodNode.name, methodNode.desc);
        }
    }

    @Requires(value={"contextLocal >= 0", "checkInvariantsLocal >= 0"})
    @Ensures(value={"result != null"})
    protected Label enterBusySection() {
        Label label = new Label();
        this.loadLocal(this.contextLocal);
        this.invokeVirtual(CONTRACT_CONTEXT_TYPE, TRY_ENTER_CONTRACT_METHOD);
        this.ifZCmp(153, label);
        return label;
    }

    @Requires(value={"contextLocal >= 0", "skip != null"})
    protected void leaveBusySection(Label label) {
        this.loadLocal(this.contextLocal);
        this.invokeVirtual(CONTRACT_CONTEXT_TYPE, LEAVE_CONTRACT_METHOD);
        this.mark(label);
    }

    protected void loadThisClass() {
        this.visitLdcInsn(this.thisType);
    }

    @Ensures(value={"contextLocal >= 0", "checkInvariantsLocal >= 0"})
    protected void enterContractedMethod() {
        this.contextLocal = this.newLocal(CONTRACT_CONTEXT_TYPE);
        this.checkInvariantsLocal = this.newLocal(Type.BOOLEAN_TYPE);
        this.invokeStatic(CONTRACT_RUNTIME_TYPE, GET_CONTEXT_METHOD);
        this.dup();
        this.storeLocal(this.contextLocal);
        if (this.statik) {
            this.loadThisClass();
        } else {
            this.loadThis();
        }
        this.invokeVirtual(CONTRACT_CONTEXT_TYPE, TRY_ENTER_METHOD);
        this.storeLocal(this.checkInvariantsLocal);
    }

    @Requires(value={"contextLocal >= 0"})
    protected void leaveContractedMethod() {
        Label label = new Label();
        this.loadLocal(this.checkInvariantsLocal);
        this.ifZCmp(153, label);
        this.loadLocal(this.contextLocal);
        if (this.statik) {
            this.loadThisClass();
        } else {
            this.loadThis();
        }
        this.invokeVirtual(CONTRACT_CONTEXT_TYPE, LEAVE_METHOD);
        this.mark(label);
    }
}

