/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.LineNumberingMethodAdapter;
import java.util.List;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

@Invariant(value={"ContractMethodSignatures.isLineNumberList(lineNumbers)"})
class LineNumberingClassAdapter
extends ClassAdapter {
    protected List<Long> lineNumbers;

    @Requires(value={"cv != null", "ContractMethodSignatures.isLineNumberList(lineNumbers)"})
    public LineNumberingClassAdapter(ClassVisitor classVisitor, List<Long> list) {
        super(classVisitor);
        this.lineNumbers = list;
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n2 | 0x1000, string, string2, string3, stringArray);
        return new LineNumberingMethodAdapter(methodVisitor, n2 | 0x1000, string, string2){

            @Override
            protected void onMethodEnter() {
                this.lineNumbers = LineNumberingClassAdapter.this.lineNumbers;
                super.onMethodEnter();
            }
        };
    }
}

