/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractAnalyzer;
import com.google.java.contract.core.agent.HelperClassAdapter;
import com.google.java.contract.core.agent.SpecificationClassAdapter;
import com.google.java.contract.core.runtime.BlacklistManager;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.JavaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javax.tools.JavaFileObject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ContractClassFileTransformer
implements ClassFileTransformer {
    protected BlacklistManager blacklistManager = BlacklistManager.getInstance();

    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        if (this.blacklistManager.isIgnored(string)) {
            DebugUtils.info("agent", "ignoring " + string);
            return null;
        }
        try {
            ContractAnalyzer contractAnalyzer = this.analyze(classLoader, string);
            if (contractAnalyzer == null) {
                if (string.endsWith("$com$google$java$contract$H")) {
                    DebugUtils.info("agent", "adding source info to " + string);
                    return this.instrumentWithDebug(byArray);
                }
                return null;
            }
            DebugUtils.info("agent", "adding contracts to " + string);
            return this.instrumentWithContracts(byArray, contractAnalyzer);
        }
        catch (Throwable throwable) {
            DebugUtils.err("agent", "while instrumenting " + string, throwable);
            throw new RuntimeException(throwable);
        }
    }

    @Requires(value={"bytecode != null", "contractBytecode != null"})
    @Ensures(value={"result != null"})
    public byte[] transformWithContracts(byte[] byArray, byte[] byArray2) throws IllegalClassFormatException {
        try {
            ContractAnalyzer contractAnalyzer = this.extractContracts(new ClassReader(byArray2));
            return this.instrumentWithContracts(byArray, contractAnalyzer);
        }
        catch (Throwable throwable) {
            IllegalClassFormatException illegalClassFormatException = new IllegalClassFormatException();
            illegalClassFormatException.initCause(throwable);
            throw illegalClassFormatException;
        }
    }

    @Requires(value={"bytecode != null"})
    @Ensures(value={"result != null"})
    public byte[] transformWithDebug(byte[] byArray) throws IllegalClassFormatException {
        try {
            return this.instrumentWithDebug(byArray);
        }
        catch (Throwable throwable) {
            IllegalClassFormatException illegalClassFormatException = new IllegalClassFormatException();
            illegalClassFormatException.initCause(throwable);
            throw illegalClassFormatException;
        }
    }

    @Requires(value={"ClassName.isBinaryName(className)"})
    protected ContractAnalyzer analyze(ClassLoader classLoader, String string) throws IOException {
        if (string.endsWith("$com$google$java$contract$H")) {
            return null;
        }
        String string2 = string + "$com$google$java$contract$H" + JavaFileObject.Kind.CLASS.extension;
        if (JavaUtils.resourceExists(classLoader, string2)) {
            return null;
        }
        InputStream inputStream = JavaUtils.getContractClassInputStream(classLoader, string);
        if (inputStream == null) {
            return null;
        }
        return this.extractContracts(new ClassReader(inputStream));
    }

    @Requires(value={"reader != null"})
    protected ContractAnalyzer extractContracts(ClassReader classReader) {
        ContractAnalyzer contractAnalyzer = new ContractAnalyzer();
        classReader.accept(contractAnalyzer, 8);
        return contractAnalyzer;
    }

    @Requires(value={"bytecode != null", "contracts != null"})
    @Ensures(value={"result != null"})
    protected byte[] instrumentWithContracts(byte[] byArray, ContractAnalyzer contractAnalyzer) {
        ClassReader classReader = new ClassReader(byArray);
        NonLoadingClassWriter nonLoadingClassWriter = new NonLoadingClassWriter(classReader, 3);
        SpecificationClassAdapter specificationClassAdapter = new SpecificationClassAdapter(nonLoadingClassWriter, contractAnalyzer);
        classReader.accept(specificationClassAdapter, 8);
        return nonLoadingClassWriter.toByteArray();
    }

    @Requires(value={"bytecode != null"})
    @Ensures(value={"result != null"})
    private byte[] instrumentWithDebug(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        NonLoadingClassWriter nonLoadingClassWriter = new NonLoadingClassWriter(classReader, 0);
        classReader.accept(new HelperClassAdapter(nonLoadingClassWriter), 8);
        return nonLoadingClassWriter.toByteArray();
    }

    protected class NonLoadingClassWriter
    extends ClassWriter {
        @Requires(value={"reader != null"})
        public NonLoadingClassWriter(ClassReader classReader, int n2) {
            super(classReader, n2);
        }

        @Override
        protected String getCommonSuperClass(String string, String string2) {
            return "java/lang/Object";
        }
    }
}

