/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.math.BigInteger;

@GwtCompatible
final class MathPreconditions {
    static int checkPositive(String role, int x2) {
        if (x2 <= 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    static long checkPositive(String role, long x2) {
        if (x2 <= 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    static BigInteger checkPositive(String role, BigInteger x2) {
        if (x2.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    static int checkNonNegative(String role, int x2) {
        if (x2 < 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static long checkNonNegative(String role, long x2) {
        if (x2 < 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static BigInteger checkNonNegative(String role, BigInteger x2) {
        if (Preconditions.checkNotNull(x2).signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static double checkNonNegative(String role, double x2) {
        if (!(x2 >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRange(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("not in range");
        }
    }

    static void checkNoOverflow(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("overflow");
        }
    }

    private MathPreconditions() {
    }
}

