/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilterStrategies;
import com.google.common.hash.Funnel;
import java.io.Serializable;

@Beta
public final class BloomFilter<T>
implements Serializable {
    private final BloomFilterStrategies.BitArray bits;
    private final int numHashFunctions;
    private final Funnel<T> funnel;
    private final Strategy strategy;
    private static final double LN2 = Math.log(2.0);
    private static final double LN2_SQUARED = LN2 * LN2;

    private BloomFilter(BloomFilterStrategies.BitArray bits, int numHashFunctions, Funnel<T> funnel, Strategy strategy) {
        Preconditions.checkArgument(numHashFunctions > 0, "numHashFunctions zero or negative");
        this.bits = Preconditions.checkNotNull(bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = Preconditions.checkNotNull(funnel);
        this.strategy = strategy;
        if (numHashFunctions > 255) {
            throw new AssertionError((Object)"Currently we don't allow BloomFilters that would use more than255 hash functions, please contact the guava team");
        }
    }

    public BloomFilter<T> copy() {
        return new BloomFilter<T>(this.bits.copy(), this.numHashFunctions, this.funnel, this.strategy);
    }

    public boolean mightContain(T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.bits);
    }

    public boolean put(T object) {
        return this.strategy.put(object, this.funnel, this.numHashFunctions, this.bits);
    }

    public double expectedFalsePositiveProbability() {
        return Math.pow((double)this.bits.bitCount() / (double)this.bits.size(), this.numHashFunctions);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof BloomFilter) {
            BloomFilter that = (BloomFilter)o2;
            return this.numHashFunctions == that.numHashFunctions && this.bits.equals(that.bits) && this.funnel == that.funnel && this.strategy == that.strategy;
        }
        return false;
    }

    public int hashCode() {
        return this.bits.hashCode();
    }

    @VisibleForTesting
    int getHashCount() {
        return this.numHashFunctions;
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions, double falsePositiveProbability) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(expectedInsertions >= 0, "Expected insertions cannot be negative");
        Preconditions.checkArgument(falsePositiveProbability > 0.0 & falsePositiveProbability < 1.0, "False positive probability in (0.0, 1.0)");
        if (expectedInsertions == 0) {
            expectedInsertions = 1;
        }
        int numBits = BloomFilter.optimalNumOfBits(expectedInsertions, falsePositiveProbability);
        int numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        return new BloomFilter<T>(new BloomFilterStrategies.BitArray(numBits), numHashFunctions, funnel, BloomFilterStrategies.MURMUR128_MITZ_32);
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions) {
        return BloomFilter.create(funnel, expectedInsertions, 0.03);
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(int n2, int m2) {
        return Math.max(1, (int)Math.round((double)(m2 / n2) * LN2));
    }

    @VisibleForTesting
    static int optimalNumOfBits(int n2, double p2) {
        return (int)((double)(-n2) * Math.log(p2) / LN2_SQUARED);
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    private static class SerialForm<T>
    implements Serializable {
        final long[] data;
        final int numHashFunctions;
        final Funnel<T> funnel;
        final Strategy strategy;
        private static final long serialVersionUID = 1L;

        SerialForm(BloomFilter<T> bf) {
            this.data = ((BloomFilter)bf).bits.data;
            this.numHashFunctions = ((BloomFilter)bf).numHashFunctions;
            this.funnel = ((BloomFilter)bf).funnel;
            this.strategy = ((BloomFilter)bf).strategy;
        }

        Object readResolve() {
            return new BloomFilter(new BloomFilterStrategies.BitArray(this.data), this.numHashFunctions, this.funnel, this.strategy);
        }
    }

    static interface Strategy
    extends Serializable {
        public <T> boolean put(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.BitArray var4);

        public <T> boolean mightContain(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.BitArray var4);

        public int ordinal();
    }
}

